/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel;

import com.google.gson.GsonBuilder;
import com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel.GradleDependencyReportGenerator;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

public class GradleDependencyReportTask
extends DefaultTask {
    private List<String> configurations;
    private File outputFile;

    @Input
    public List<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<String> configurations) {
        this.configurations = configurations;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @TaskAction
    public void generate() throws IOException {
        Collection<Configuration> configurations = this.getSelectedConfigurations();
        GradleDependencyReportGenerator generator = new GradleDependencyReportGenerator();
        ArrayList<DependencyScopeNode> graph = new ArrayList<DependencyScopeNode>();
        for (Configuration configuration : configurations) {
            if (!configuration.isCanBeResolved()) continue;
            graph.add(generator.buildDependencyGraph(configuration, this.getProject()));
        }
        Path outputFilePath = this.outputFile.toPath();
        Files.createDirectories(outputFilePath.getParent(), new FileAttribute[0]);
        Files.write(outputFilePath, new GsonBuilder().create().toJson(graph).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @NotNull
    private Collection<Configuration> getSelectedConfigurations() {
        if (this.configurations.isEmpty()) {
            ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
            if (configurationContainer == null) {
                GradleDependencyReportTask.$$$reportNull$$$0(0);
            }
            return configurationContainer;
        }
        ArrayList<Configuration> selectedProjectConfigurations = new ArrayList<Configuration>();
        for (String configurationName : this.configurations) {
            Configuration configuration = (Configuration)this.getProject().getConfigurations().findByName(configurationName);
            if (configuration == null) continue;
            selectedProjectConfigurations.add(configuration);
        }
        ArrayList<Configuration> arrayList = selectedProjectConfigurations;
        if (arrayList == null) {
            GradleDependencyReportTask.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gradle/toolingExtension/impl/model/dependencyGraphModel/GradleDependencyReportTask", "getSelectedConfigurations"));
    }
}

