/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.jvm.analysis.quickFix.ReplaceCallableExpressionQuickFix;
import com.intellij.jvm.analysis.refactoring.CallChainReplacementInfo;
import com.intellij.jvm.analysis.refactoring.CallReplacementInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.testFrameworks.UAssertHint;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitAssertEqualsMayBeAssertSameVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "couldBeAssertSameArgument", "expression", "Lorg/jetbrains/uast/UExpression;", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnitAssertEqualsMayBeAssertSameInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitAssertEqualsMayBeAssertSameInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitAssertEqualsMayBeAssertSameVisitor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,55:1\n37#2,2:56\n*S KotlinDebug\n*F\n+ 1 JUnitAssertEqualsMayBeAssertSameInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitAssertEqualsMayBeAssertSameVisitor\n*L\n41#1:56,2\n*E\n"})
final class JUnitAssertEqualsMayBeAssertSameVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public JUnitAssertEqualsMayBeAssertSameVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UAssertHint uAssertHint = UAssertHint.Companion.createAssertEqualsHint(node);
        if (uAssertHint == null) {
            return true;
        }
        UAssertHint assertHint = uAssertHint;
        if (!this.couldBeAssertSameArgument(assertHint.getFirstArgument())) {
            return true;
        }
        if (!this.couldBeAssertSameArgument(assertHint.getSecondArgument())) {
            return true;
        }
        String string = JUnitBundle.message("jvm.inspections.junit.assertequals.may.be.assertsame.problem.descriptor", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
        CallReplacementInfo[] callReplacementInfoArray = new CallReplacementInfo[1];
        Collection $this$toTypedArray$iv = node.getValueArguments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UExpression[] uExpressionArray = thisCollection$iv.toArray(new UExpression[0]);
        callReplacementInfoArray[0] = new CallReplacementInfo("assertSame", null, Arrays.copyOf(uExpressionArray, uExpressionArray.length));
        localQuickFixArray[0] = new ReplaceCallableExpressionQuickFix(new CallChainReplacementInfo(null, callReplacementInfoArray));
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UCallExpression)node, (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
        return true;
    }

    private final boolean couldBeAssertSameArgument(UExpression expression) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression.getExpressionType());
        if (psiClass == null) {
            return false;
        }
        PsiClass argumentClass = psiClass;
        if (!argumentClass.hasModifierProperty("final")) {
            return false;
        }
        PsiMethod[] psiMethodArray = argumentClass.findMethodsByName("equals", true);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        PsiMethod[] methods = psiMethodArray;
        PsiElement psiElement = expression.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
            return false;
        }
        PsiElement project = psiElement;
        PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", argumentClass.getResolveScope());
        if (psiClass2 == null) {
            return false;
        }
        PsiClass objectClass = psiClass2;
        for (PsiMethod method : methods) {
            if (Intrinsics.areEqual((Object)objectClass, (Object)method.getContainingClass())) continue;
            return false;
        }
        return true;
    }
}

