/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.IntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.graph.utils.impl.ByteArrayUtils;
import com.intellij.vcs.log.graph.utils.impl.PermanentListIntToIntMap;
import org.jetbrains.annotations.NotNull;

final class IntDeltaCompressor
implements IntList {
    private final byte @NotNull [] myCompressedDeltas;
    @NotNull
    private final Flags myStartedDeltaIndex;
    @NotNull
    private final IntToIntMap myStartIndexMap;

    @NotNull
    public static IntDeltaCompressor newInstance(@NotNull IntList deltaList) {
        if (deltaList == null) {
            IntDeltaCompressor.$$$reportNull$$$0(0);
        }
        if (deltaList.size() < 0) {
            throw new NegativeArraySizeException("size < 0: " + deltaList.size());
        }
        int bytesAfterCompression = ByteArrayUtils.countBytesAfterCompression(deltaList);
        BitSetFlags startedDeltaIndex = new BitSetFlags(bytesAfterCompression);
        byte[] compressedDeltas = new byte[bytesAfterCompression];
        int currentStartIndex = 0;
        for (int i = 0; i < deltaList.size(); ++i) {
            startedDeltaIndex.set(currentStartIndex, true);
            int value = deltaList.get(i);
            int sizeOf = ByteArrayUtils.sizeOf(value);
            ByteArrayUtils.writeDelta(currentStartIndex, value, sizeOf, compressedDeltas);
            currentStartIndex += sizeOf;
        }
        return new IntDeltaCompressor(compressedDeltas, startedDeltaIndex, deltaList.size());
    }

    private IntDeltaCompressor(byte @NotNull [] compressedDeltas, @NotNull Flags startedDeltaIndex, int countDeltas) {
        if (startedDeltaIndex == null) {
            IntDeltaCompressor.$$$reportNull$$$0(1);
        }
        if (compressedDeltas == null) {
            IntDeltaCompressor.$$$reportNull$$$0(2);
        }
        this.myCompressedDeltas = compressedDeltas;
        this.myStartedDeltaIndex = startedDeltaIndex;
        this.myStartIndexMap = PermanentListIntToIntMap.newInstance(startedDeltaIndex, countDeltas);
    }

    public int getSumOfInterval(int left, int right) {
        if (left < 0 || left > right || right > this.size()) {
            throw new IllegalArgumentException("Size is: " + this.size() + ", but interval is: (" + left + ", " + right + ")");
        }
        if (left == this.size()) {
            return 0;
        }
        int startIndex = this.myStartIndexMap.getLongIndex(left);
        int sum = 0;
        for (int i = 0; i < right - left; ++i) {
            int sizeOf = this.getNextStartIndex(startIndex) - startIndex;
            sum += ByteArrayUtils.readDelta(startIndex, sizeOf, this.myCompressedDeltas);
            startIndex += sizeOf;
        }
        return sum;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Size is: " + this.size() + ", but index is: " + index);
        }
        int startIndex = this.myStartIndexMap.getLongIndex(index);
        int sizeOf = this.getNextStartIndex(startIndex) - startIndex;
        return ByteArrayUtils.readDelta(startIndex, sizeOf, this.myCompressedDeltas);
    }

    @Override
    public int size() {
        return this.myStartIndexMap.shortSize();
    }

    private int getNextStartIndex(int currentIndex) {
        for (int i = currentIndex + 1; i < this.myStartedDeltaIndex.size(); ++i) {
            if (!this.myStartedDeltaIndex.get(i)) continue;
            return i;
        }
        return this.myStartedDeltaIndex.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deltaList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startedDeltaIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compressedDeltas";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/IntDeltaCompressor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

