/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.model.DefaultGradleConfiguration;
import org.jetbrains.plugins.gradle.model.DefaultGradleConvention;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtension;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.DefaultGradleProperty;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.GradleProperty;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

public class GradleExtensionsSettings {
    private static final Logger LOG = Logger.getInstance(GradleExtensionsSettings.class);
    private final Settings myState = new Settings();

    public GradleExtensionsSettings(Project project2) {
        ExternalSystemApiUtil.subscribe((Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemSettingsListener)new GradleSettingsListener(){

            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleExtensionsSettings.this.myState.remove(linkedProjectPaths);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPaths", "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$1", "onProjectsUnlinked"));
            }
        });
    }

    @NotNull
    public static Settings getInstance(@NotNull Project project2) {
        if (project2 == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(0);
        }
        Settings settings = ((GradleExtensionsSettings)project2.getService(GradleExtensionsSettings.class)).myState;
        if (settings == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(1);
        }
        return settings;
    }

    public static void load(Project project2) {
        Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project2, GradleConstants.SYSTEM_ID);
        for (ExternalProjectInfo projectInfo : projectsData) {
            DataNode projectDataNode = projectInfo.getExternalProjectStructure();
            if (projectDataNode == null) continue;
            String projectPath = projectInfo.getExternalProjectPath();
            try {
                SmartList nodes = new SmartList();
                for (DataNode moduleNode : ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE)) {
                    ContainerUtil.addIfNotNull((Collection)nodes, (Object)ExternalSystemApiUtil.find((DataNode)moduleNode, GradleExtensionsDataService.KEY));
                }
                GradleExtensionsSettings.getInstance(project2).add(projectPath, (Collection<? extends DataNode<GradleExtensions>>)nodes);
            }
            catch (ClassCastException e) {
                LOG.debug((Throwable)e);
                ExternalProjectsManager.getInstance((Project)project2).getExternalProjectsWatcher().markDirty(projectPath);
            }
        }
    }

    @Nullable
    public static GradleProject getRootProject(@NotNull PsiElement element) {
        if (element == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(2);
        }
        PsiFile containingFile = element.getContainingFile().getOriginalFile();
        Project project2 = containingFile.getProject();
        return GradleExtensionsSettings.getInstance(project2).getRootGradleProject(GradleExtensionsSettings.getRootProjectPath(element));
    }

    @Nullable
    public static String getRootProjectPath(@NotNull PsiElement element) {
        if (element == null) {
            GradleExtensionsSettings.$$$reportNull$$$0(3);
        }
        PsiFile containingFile = element.getContainingFile().getOriginalFile();
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)containingFile);
        return ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Settings {
        @NotNull
        private final Map<String, GradleProject> projects = new HashMap<String, GradleProject>();

        public void add(@NotNull String rootPath, @NotNull Collection<? extends DataNode<GradleExtensions>> extensionsData) {
            if (rootPath == null) {
                Settings.$$$reportNull$$$0(0);
            }
            if (extensionsData == null) {
                Settings.$$$reportNull$$$0(1);
            }
            HashMap<String, GradleExtensions> extensionMap = new HashMap<String, GradleExtensions>();
            for (DataNode<GradleExtensions> dataNode : extensionsData) {
                DataNode parent = dataNode.getParent();
                if (parent == null || !(parent.getData() instanceof ModuleData)) continue;
                String gradlePath2 = GradleModuleDataKt.getGradleIdentityPath((ModuleData)parent.getData());
                extensionMap.put(gradlePath2, (GradleExtensions)dataNode.getData());
            }
            this.add(rootPath, extensionMap);
        }

        public void add(@NotNull String rootPath, @NotNull Map<String, GradleExtensions> extensions) {
            if (rootPath == null) {
                Settings.$$$reportNull$$$0(2);
            }
            if (extensions == null) {
                Settings.$$$reportNull$$$0(3);
            }
            GradleProject gradleProject = new GradleProject();
            GradleExtensionDataFactory factory = new GradleExtensionDataFactory();
            for (Map.Entry<String, GradleExtensions> entry : extensions.entrySet()) {
                GradleExtensionsData extensionsData = factory.getGradleExtensionsData(entry.getValue(), gradleProject);
                gradleProject.extensions.put(entry.getKey(), extensionsData);
            }
            this.projects.put(rootPath, gradleProject);
        }

        public void remove(@NotNull Set<String> rootPaths) {
            if (rootPaths == null) {
                Settings.$$$reportNull$$$0(4);
            }
            for (String path : rootPaths) {
                this.projects.remove(path);
            }
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable Module module) {
            if (module == null) {
                return null;
            }
            return this.getExtensionsFor(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module), GradleProjectResolverUtil.getGradleIdentityPathOrNull(module));
        }

        @Nullable
        public GradleExtensionsData getExtensionsFor(@Nullable String rootProjectPath, @Nullable String gradlePath2) {
            GradleProject gradleProject = this.getRootGradleProject(rootProjectPath);
            if (gradleProject == null) {
                return null;
            }
            return gradleProject.extensions.get(gradlePath2);
        }

        @Contract(value="null -> null")
        @Nullable
        public GradleProject getRootGradleProject(@Nullable String rootProjectPath) {
            if (rootProjectPath == null) {
                return null;
            }
            return this.projects.get(rootProjectPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionsData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPaths";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$Settings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GradleProject {
        public Map<String, GradleExtensionsData> extensions = new HashMap<String, GradleExtensionsData>();
    }

    public static class GradleConfiguration {
        @NotNull
        private final String name;
        private final boolean visible;
        private final boolean scriptClasspath;
        @Nullable
        private final String description;
        @NotNull
        private final List<String> declarationAlternatives;

        public GradleConfiguration(@NotNull String name, boolean visible, boolean scriptClasspath, @Nullable String description, @NotNull List<String> declarationAlternatives) {
            if (name == null) {
                GradleConfiguration.$$$reportNull$$$0(0);
            }
            if (declarationAlternatives == null) {
                GradleConfiguration.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.visible = visible;
            this.scriptClasspath = scriptClasspath;
            this.description = description;
            this.declarationAlternatives = declarationAlternatives;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                GradleConfiguration.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isScriptClasspath() {
            return this.scriptClasspath;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public List<String> getDeclarationAlternatives() {
            List<String> list = this.declarationAlternatives;
            if (list == null) {
                GradleConfiguration.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declarationAlternatives";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleConfiguration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclarationAlternatives";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class GradleTask
    implements TypeAware {
        @ApiStatus.Internal
        @NotNull
        public final String name;
        @ApiStatus.Internal
        @NotNull
        public final String typeFqn;

        public GradleTask(@NotNull String name, @NotNull String typeFqn) {
            if (name == null) {
                GradleTask.$$$reportNull$$$0(0);
            }
            if (typeFqn == null) {
                GradleTask.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.typeFqn = typeFqn;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                GradleTask.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getTypeFqn() {
            String string = this.typeFqn;
            if (string == null) {
                GradleTask.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeFqn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class GradleProp
    implements TypeAware {
        @NotNull
        private final String name;
        @NotNull
        private final String typeFqn;

        public GradleProp(@NotNull String name, @NotNull String typeFqn) {
            if (name == null) {
                GradleProp.$$$reportNull$$$0(0);
            }
            if (typeFqn == null) {
                GradleProp.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.typeFqn = typeFqn;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                GradleProp.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getTypeFqn() {
            String string = this.typeFqn;
            if (string == null) {
                GradleProp.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeFqn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleProp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleProp";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class GradleConvention
    implements TypeAware {
        @NotNull
        private final String name;
        @NotNull
        private final String typeFqn;

        public GradleConvention(@NotNull String name, @NotNull String typeFqn) {
            if (name == null) {
                GradleConvention.$$$reportNull$$$0(0);
            }
            if (typeFqn == null) {
                GradleConvention.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.typeFqn = typeFqn;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                GradleConvention.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getTypeFqn() {
            String string = this.typeFqn;
            if (string == null) {
                GradleConvention.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeFqn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleConvention";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleConvention";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class GradleExtension
    implements TypeAware {
        @NotNull
        private final String name;
        @NotNull
        private final String typeFqn;

        public GradleExtension(@NotNull String name, @NotNull String typeFqn) {
            if (name == null) {
                GradleExtension.$$$reportNull$$$0(0);
            }
            if (typeFqn == null) {
                GradleExtension.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.typeFqn = typeFqn;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                GradleExtension.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getTypeFqn() {
            String string = this.typeFqn;
            if (string == null) {
                GradleExtension.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeFqn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtension";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface TypeAware {
        public String getTypeFqn();
    }

    private static class GradleExtensionDataFactory {
        @NotNull
        private final Map<DefaultGradleExtension, GradleExtension> extensionCache = new HashMap<DefaultGradleExtension, GradleExtension>();
        @NotNull
        private final Map<DefaultGradleConvention, GradleConvention> conventionCache = new HashMap<DefaultGradleConvention, GradleConvention>();
        @NotNull
        private final Map<DefaultGradleProperty, GradleProp> propertyCache = new HashMap<DefaultGradleProperty, GradleProp>();
        @NotNull
        private final Map<String, GradleTask> taskCache = new HashMap<String, GradleTask>();
        @NotNull
        private final Map<DefaultGradleConfiguration, GradleConfiguration> configurationCache = new HashMap<DefaultGradleConfiguration, GradleConfiguration>();
        @NotNull
        private final Map<DefaultGradleExtensions, GradleExtensionsData> gradleExtensionsCache = new HashMap<DefaultGradleExtensions, GradleExtensionsData>();

        private GradleExtensionDataFactory() {
        }

        @NotNull
        public GradleExtensionsData getGradleExtensionsData(@NotNull GradleExtensions gradleExtensions, @NotNull GradleProject gradleProject) {
            if (gradleExtensions == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(0);
            }
            if (gradleProject == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(1);
            }
            GradleExtensionsData gradleExtensionsData = this.gradleExtensionsCache.computeIfAbsent((DefaultGradleExtensions)gradleExtensions, e -> this.convertGradleExtensionsData((GradleExtensions)e, gradleProject));
            if (gradleExtensionsData == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(2);
            }
            return gradleExtensionsData;
        }

        @NotNull
        private GradleExtensionsData convertGradleExtensionsData(@NotNull GradleExtensions gradleExtensions, @NotNull GradleProject gradleProject) {
            if (gradleExtensions == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(3);
            }
            if (gradleProject == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(4);
            }
            HashMap<String, GradleExtension> extensions = new HashMap<String, GradleExtension>();
            for (Object extension : gradleExtensions.getExtensions()) {
                GradleExtension gradleExtension = this.extensionCache.computeIfAbsent((DefaultGradleExtension)extension, GradleExtensionDataFactory::convertGradleExtension);
                extensions.put(gradleExtension.getName(), gradleExtension);
            }
            SmartList conventions = new SmartList();
            for (Object convention : gradleExtensions.getConventions()) {
                GradleConvention gradleConvention = this.conventionCache.computeIfAbsent((DefaultGradleConvention)convention, GradleExtensionDataFactory::convertGradleConvention);
                conventions.add(gradleConvention);
            }
            HashMap<String, GradleProp> properties = new HashMap<String, GradleProp>();
            for (Object property : gradleExtensions.getGradleProperties()) {
                GradleProp gradleProp = this.propertyCache.computeIfAbsent((DefaultGradleProperty)property, GradleExtensionDataFactory::convertGradleProp);
                properties.put(gradleProp.getName(), gradleProp);
            }
            LinkedHashMap<String, GradleTask> tasksMap = new LinkedHashMap<String, GradleTask>();
            for (ExternalTask task2 : gradleExtensions.getTasks()) {
                GradleTask gradleTask = this.taskCache.computeIfAbsent(task2.getName() + task2.getType(), __ -> GradleExtensionDataFactory.convertGradleTask(task2));
                tasksMap.put(gradleTask.getName(), gradleTask);
            }
            HashMap<String, GradleConfiguration> configurations = new HashMap<String, GradleConfiguration>();
            HashMap<String, GradleConfiguration> buildScriptConfigurations = new HashMap<String, GradleConfiguration>();
            for (org.jetbrains.plugins.gradle.model.GradleConfiguration configuration : gradleExtensions.getConfigurations()) {
                GradleConfiguration gradleConfiguration = this.configurationCache.computeIfAbsent((DefaultGradleConfiguration)configuration, GradleExtensionDataFactory::convertGradleConfiguration);
                if (gradleConfiguration.scriptClasspath) {
                    buildScriptConfigurations.put(gradleConfiguration.getName(), gradleConfiguration);
                    continue;
                }
                configurations.put(gradleConfiguration.getName(), gradleConfiguration);
            }
            return new GradleExtensionsData(gradleProject, gradleExtensions.getParentProjectPath(), extensions, (List<GradleConvention>)conventions, properties, tasksMap, configurations, buildScriptConfigurations);
        }

        @NotNull
        private static GradleExtension convertGradleExtension(@NotNull org.jetbrains.plugins.gradle.model.GradleExtension extension) {
            if (extension == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(5);
            }
            return new GradleExtension(extension.getName(), extension.getTypeFqn());
        }

        @NotNull
        private static GradleConvention convertGradleConvention(@NotNull org.jetbrains.plugins.gradle.model.GradleConvention convention) {
            if (convention == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(6);
            }
            return new GradleConvention(convention.getName(), convention.getTypeFqn());
        }

        @NotNull
        private static GradleProp convertGradleProp(@NotNull GradleProperty property) {
            if (property == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(7);
            }
            return new GradleProp(property.getName(), property.getTypeFqn());
        }

        @NotNull
        private static GradleTask convertGradleTask(@NotNull ExternalTask task2) {
            if (task2 == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(8);
            }
            return new GradleTask(task2.getName(), Objects.requireNonNullElse(task2.getType(), "org.gradle.api.DefaultTask"));
        }

        @NotNull
        private static GradleConfiguration convertGradleConfiguration(@NotNull org.jetbrains.plugins.gradle.model.GradleConfiguration configuration) {
            if (configuration == null) {
                GradleExtensionDataFactory.$$$reportNull$$$0(9);
            }
            return new GradleConfiguration(configuration.getName(), configuration.isVisible(), configuration.isScriptClasspathConfiguration(), configuration.getDescription(), configuration.getDeclarationAlternatives());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleExtensions";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleProject";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionDataFactory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convention";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionDataFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleExtensionsData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getGradleExtensionsData";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertGradleExtensionsData";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "convertGradleExtension";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convertGradleConvention";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "convertGradleProp";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "convertGradleTask";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "convertGradleConfiguration";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class GradleExtensionsData {
        @Nullable
        private final GradleProject myGradleProject;
        @Nullable
        private final String parent;
        @NotNull
        public final Map<String, GradleExtension> extensions;
        @NotNull
        public final List<GradleConvention> conventions;
        @NotNull
        public final Map<String, GradleProp> properties;
        @NotNull
        public final Map<String, GradleTask> tasksMap;
        @NotNull
        public final Map<String, GradleConfiguration> configurations;
        @NotNull
        public final Map<String, GradleConfiguration> buildScriptConfigurations;

        @VisibleForTesting
        @ApiStatus.Internal
        public GradleExtensionsData(@Nullable GradleProject gradleProject, @Nullable String parent, @NotNull Map<String, GradleExtension> extensions, @NotNull List<GradleConvention> conventions, @NotNull Map<String, GradleProp> properties, @NotNull Map<String, GradleTask> tasksMap, @NotNull Map<String, GradleConfiguration> configurations, @NotNull Map<String, GradleConfiguration> buildScriptConfigurations) {
            if (extensions == null) {
                GradleExtensionsData.$$$reportNull$$$0(0);
            }
            if (conventions == null) {
                GradleExtensionsData.$$$reportNull$$$0(1);
            }
            if (properties == null) {
                GradleExtensionsData.$$$reportNull$$$0(2);
            }
            if (tasksMap == null) {
                GradleExtensionsData.$$$reportNull$$$0(3);
            }
            if (configurations == null) {
                GradleExtensionsData.$$$reportNull$$$0(4);
            }
            if (buildScriptConfigurations == null) {
                GradleExtensionsData.$$$reportNull$$$0(5);
            }
            this.myGradleProject = gradleProject;
            this.parent = parent;
            this.extensions = Collections.unmodifiableMap(extensions);
            this.conventions = Collections.unmodifiableList(conventions);
            this.properties = Collections.unmodifiableMap(properties);
            this.tasksMap = Collections.unmodifiableMap(tasksMap);
            this.configurations = Collections.unmodifiableMap(configurations);
            this.buildScriptConfigurations = Collections.unmodifiableMap(buildScriptConfigurations);
        }

        @Nullable
        public GradleExtensionsData getParent() {
            if (this.myGradleProject == null) {
                return null;
            }
            return this.myGradleProject.extensions.get(this.parent);
        }

        @Nullable
        public GradleProp findProperty(@Nullable String name) {
            return GradleExtensionsData.findProperty(this, name);
        }

        @NotNull
        public Collection<GradleProp> findAllProperties() {
            return GradleExtensionsData.findAllProperties(this, new HashMap<String, GradleProp>());
        }

        @NotNull
        private static Collection<GradleProp> findAllProperties(@NotNull GradleExtensionsData extensionsData, @NotNull Map<String, GradleProp> result) {
            if (extensionsData == null) {
                GradleExtensionsData.$$$reportNull$$$0(6);
            }
            if (result == null) {
                GradleExtensionsData.$$$reportNull$$$0(7);
            }
            for (GradleProp property : extensionsData.properties.values()) {
                result.putIfAbsent(property.name, property);
            }
            if (extensionsData.getParent() != null) {
                GradleExtensionsData.findAllProperties(extensionsData.getParent(), result);
            }
            Collection<GradleProp> collection = result.values();
            if (collection == null) {
                GradleExtensionsData.$$$reportNull$$$0(8);
            }
            return collection;
        }

        @Nullable
        private static GradleProp findProperty(@NotNull GradleExtensionsData extensionsData, String propName) {
            GradleExtensionsData parentData;
            GradleProp prop;
            if (extensionsData == null) {
                GradleExtensionsData.$$$reportNull$$$0(9);
            }
            if ((prop = extensionsData.properties.get(propName)) != null) {
                return prop;
            }
            if (extensionsData.parent != null && extensionsData.myGradleProject != null && (parentData = extensionsData.myGradleProject.extensions.get(extensionsData.parent)) != null) {
                return GradleExtensionsData.findProperty(parentData, propName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conventions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasksMap";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildScriptConfigurations";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionsData";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAllProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findAllProperties";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findProperty";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

