/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.common.highlighter.FenceHighlightingKt;
import org.intellij.plugins.markdown.extensions.common.highlighter.HighlightedRange;
import org.intellij.plugins.markdown.extensions.common.highlighter.HtmlCacheManager;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.ui.preview.html.DefaultCodeFenceGeneratingProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter;", "Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "<init>", "()V", "cacheManager", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager;", "getCacheManager", "()Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager;", "currentFile", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/vfs/VirtualFile;", "isApplicable", "", "language", "", "generateHtmlForFile", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "file", "generateHtml", "processCodeLine", "line", "intellij.markdown"})
@ApiStatus.Internal
public final class MarkdownCodeFencePreviewHighlighter
implements CodeFenceGeneratingProvider {
    @NotNull
    private final ThreadLocal<VirtualFile> currentFile = new ThreadLocal();

    private final HtmlCacheManager getCacheManager() {
        return HtmlCacheManager.Companion.getInstance();
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return CodeFenceLanguageGuesser.guessLanguageForInjection(language) != null;
    }

    @NotNull
    public final String generateHtmlForFile(@NotNull String language, @NotNull String raw, @NotNull ASTNode node, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.currentFile.set(file);
        String result = this.generateHtml(language, raw, node);
        this.currentFile.set(null);
        return result;
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Language injectedLanguage = CodeFenceLanguageGuesser.guessLanguageForInjection(language);
        if (injectedLanguage == null) {
            return DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown(raw);
        }
        String cacheKey = this.getCacheManager().obtainCacheKey(raw, language);
        String cached = this.getCacheManager().obtainCachedHtml(cacheKey);
        if (cached != null) {
            return cached;
        }
        List<HighlightedRange> highlightedRanges = FenceHighlightingKt.collectHighlightedChunks(injectedLanguage, raw);
        String text2 = FenceHighlightingKt.buildHighlightedFenceContent(raw, highlightedRanges, node, true, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return MarkdownCodeFencePreviewHighlighter.access$processCodeLine((MarkdownCodeFencePreviewHighlighter)this.receiver, p0);
            }
        }));
        this.getCacheManager().cacheHtml(cacheKey, text2);
        return text2;
    }

    private final String processCodeLine(String line) {
        CommandRunnerExtension runner;
        VirtualFile virtualFile = this.currentFile.get();
        if (virtualFile == null) {
            return "";
        }
        VirtualFile file = virtualFile;
        CommandRunnerExtension commandRunnerExtension = runner = CommandRunnerExtension.Companion.getRunnerByFile(file);
        String string = commandRunnerExtension != null ? commandRunnerExtension.processCodeLine(line, true) : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static final /* synthetic */ String access$processCodeLine(MarkdownCodeFencePreviewHighlighter $this, String line) {
        return $this.processCodeLine(line);
    }
}

