/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import java.util.Objects;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.lexer.MarkdownMergingLexer;
import org.intellij.plugins.markdown.lang.parser.MarkdownFlavourUtil;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.intellij.plugins.markdown.lang.parser.PsiBuilderFillingVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MarkdownLazyElementType
extends ILazyParseableElementType {
    private static final Logger LOG = Logger.getInstance(MarkdownLazyElementType.class);

    public MarkdownLazyElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            MarkdownLazyElementType.$$$reportNull$$$0(0);
        }
        super(debugName, (Language)MarkdownLanguage.INSTANCE);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            MarkdownLazyElementType.$$$reportNull$$$0(1);
        }
        if (psi == null) {
            MarkdownLazyElementType.$$$reportNull$$$0(2);
        }
        Project project = psi.getProject();
        MarkdownMergingLexer lexer = new MarkdownMergingLexer();
        StringUtil.BombedCharSequence chars = new StringUtil.BombedCharSequence(chameleon.getChars()){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
        PsiFile file = psi.getContainingFile();
        Objects.requireNonNull(file, () -> "Expected a non-null containing file for " + psi);
        MarkdownFlavourDescriptor flavour = MarkdownLazyElementType.obtainFlavour(file);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)lexer, this.getLanguage(), (CharSequence)chars);
        long startTime = System.nanoTime();
        MarkdownParser parser = new MarkdownParser(flavour, true);
        org.intellij.markdown.IElementType nodeType = MarkdownElementType.markdownType(chameleon.getElementType());
        org.intellij.markdown.ast.ASTNode node = parser.parseInline(nodeType, (CharSequence)chars, 0, chars.length());
        PsiBuilder.Marker rootMarker = builder.mark();
        new PsiBuilderFillingVisitor(builder, false).visitNode(node);
        assert (builder.eof());
        rootMarker.done((IElementType)this);
        ASTNode tree = builder.getTreeBuilt();
        ASTNode actualElement = tree.getFirstChildNode().getFirstChildNode();
        ParsingDiagnostics.registerParse((PsiBuilder)builder, (Language)this.getLanguage(), (long)(System.nanoTime() - startTime));
        return actualElement;
    }

    @NotNull
    private static MarkdownFlavourDescriptor obtainFlavour(@NotNull PsiFile file) {
        if (file == null) {
            MarkdownLazyElementType.$$$reportNull$$$0(3);
        }
        if (file instanceof MarkdownFile) {
            MarkdownFile markdownFile = (MarkdownFile)file;
            MarkdownFlavourDescriptor markdownFlavourDescriptor = markdownFile.getFlavour();
            if (markdownFlavourDescriptor == null) {
                MarkdownLazyElementType.$$$reportNull$$$0(4);
            }
            return markdownFlavourDescriptor;
        }
        MarkdownFlavourDescriptor flavour = (MarkdownFlavourDescriptor)file.getUserData(MarkdownParserManager.FLAVOUR_DESCRIPTION);
        if (flavour != null) {
            MarkdownFlavourDescriptor markdownFlavourDescriptor = flavour;
            if (markdownFlavourDescriptor == null) {
                MarkdownLazyElementType.$$$reportNull$$$0(5);
            }
            return markdownFlavourDescriptor;
        }
        MarkdownFlavourDescriptor defaultFlavour = MarkdownFlavourUtil.obtainDefaultMarkdownFlavour();
        LOG.error("Markdown flavour was not set for " + file + ". Using default flavour as a fallback: " + defaultFlavour);
        MarkdownFlavourDescriptor markdownFlavourDescriptor = defaultFlavour;
        if (markdownFlavourDescriptor == null) {
            MarkdownLazyElementType.$$$reportNull$$$0(6);
        }
        return markdownFlavourDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/lang/MarkdownLazyElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/lang/MarkdownLazyElementType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFlavour";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doParseContents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "obtainFlavour";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

