/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/PreviewEncodingUtil;", "", "<init>", "()V", "contentCharset", "Ljava/nio/charset/Charset;", "getContentCharset", "()Ljava/nio/charset/Charset;", "encodeContent", "", "content", "decodeContent", "encodeUrl", "url", "intellij.markdown"})
public final class PreviewEncodingUtil {
    @NotNull
    public static final PreviewEncodingUtil INSTANCE = new PreviewEncodingUtil();

    private PreviewEncodingUtil() {
    }

    private final Charset getContentCharset() {
        return Charsets.UTF_8;
    }

    @NotNull
    public final String encodeContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] byArray = content.getBytes(this.getContentCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = encoder.encode(byArray);
        Intrinsics.checkNotNull((Object)bytes);
        return new String(bytes, this.getContentCharset());
    }

    @NotNull
    public final String decodeContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] bytes = decoder.decode(content);
        Intrinsics.checkNotNull((Object)bytes);
        return new String(bytes, this.getContentCharset());
    }

    @NotNull
    public final String encodeUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = URLEncoder.encode(url, this.getContentCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }
}

