/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0004\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\r\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0001\u00a8\u0006\u0017"}, d2={"transferFrom", "Lkotlinx/io/Buffer;", "input", "Ljava/io/InputStream;", "write", "byteCount", "", "", "forever", "", "readTo", "out", "Ljava/io/OutputStream;", "copyTo", "startIndex", "endIndex", "readAtMostTo", "", "sink", "Ljava/nio/ByteBuffer;", "source", "asByteChannel", "Ljava/nio/channels/ByteChannel;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nBuffersJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n52#2:215\n53#2:217\n109#2:218\n109#2:219\n112#2:220\n1#3:216\n*S KotlinDebug\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n*L\n55#1:215\n55#1:217\n64#1:218\n96#1:219\n144#1:220\n55#1:216\n*E\n"})
public final class BuffersJvmKt {
    @NotNull
    public static final Buffer transferFrom(@NotNull Buffer $this$transferFrom, @NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)$this$transferFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BuffersJvmKt.write($this$transferFrom, input, Long.MAX_VALUE, true);
        return $this$transferFrom;
    }

    @NotNull
    public static final Buffer write(@NotNull Buffer $this$write, @NotNull InputStream input, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        BuffersJvmKt.write($this$write, input, byteCount, false);
        return $this$write;
    }

    private static final void write(Buffer $this$write, InputStream input, long byteCount, boolean forever) {
        int bytesRead;
        for (long remainingByteCount = byteCount; remainingByteCount > 0L || forever; remainingByteCount -= (long)bytesRead) {
            Segment tail = $this$write.writableSegment(1);
            int b$iv = 8192 - tail.getLimit();
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min(remainingByteCount, (long)b$iv);
            bytesRead = input.read(tail.data, tail.getLimit(), maxToCopy);
            if (bytesRead == -1) {
                if (tail.getPos() == tail.getLimit()) {
                    $this$write.recycleTail();
                }
                if (forever) {
                    return;
                }
                throw new EOFException("Stream exhausted before " + byteCount + " bytes were read.");
            }
            tail.setLimit(tail.getLimit() + bytesRead);
            $this$write.setSizeMut($this$write.getSizeMut() + (long)bytesRead);
        }
    }

    public static final void readTo(@NotNull Buffer $this$readTo, @NotNull OutputStream out, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)$this$readTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkOffsetAndCount($this$readTo.getSize(), 0L, byteCount);
        Segment s = $this$readTo.getHead();
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= (long)toCopy) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            int b$iv = segment.getLimit() - s.getPos();
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min(remainingByteCount, (long)b$iv);
            out.write(s.data, s.getPos(), toCopy);
            Segment segment2 = s;
            segment2.setPos(segment2.getPos() + toCopy);
            $this$readTo.setSizeMut($this$readTo.getSizeMut() - (long)toCopy);
            if (s.getPos() != s.getLimit()) continue;
            $this$readTo.recycleHead$kotlinx_io_core();
            s = $this$readTo.getHead();
        }
    }

    public static /* synthetic */ void readTo$default(Buffer buffer, OutputStream outputStream, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = buffer.getSize();
        }
        BuffersJvmKt.readTo(buffer, outputStream, l);
    }

    public static final void copyTo(@NotNull Buffer $this$copyTo, @NotNull OutputStream out, long startIndex, long endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkBounds($this$copyTo.getSize(), startIndex, endIndex);
        if (startIndex == endIndex) {
            return;
        }
        long currentOffset = startIndex;
        long remainingByteCount = endIndex - startIndex;
        Segment s = $this$copyTo.getHead();
        while (true) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            if (currentOffset < (long)(segment.getLimit() - s.getPos())) break;
            currentOffset -= (long)(s.getLimit() - s.getPos());
            s = s.getNext();
        }
        while (remainingByteCount > 0L) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            int pos = (int)((long)segment.getPos() + currentOffset);
            int a$iv = s.getLimit() - pos;
            boolean $i$f$minOf = false;
            int toCopy = (int)Math.min((long)a$iv, remainingByteCount);
            out.write(s.data, pos, toCopy);
            remainingByteCount -= (long)toCopy;
            currentOffset = 0L;
            s = s.getNext();
        }
    }

    public static /* synthetic */ void copyTo$default(Buffer buffer, OutputStream outputStream, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = buffer.getSize();
        }
        BuffersJvmKt.copyTo(buffer, outputStream, l, l2);
    }

    public static final int readAtMostTo(@NotNull Buffer $this$readAtMostTo, @NotNull ByteBuffer sink) {
        Intrinsics.checkNotNullParameter((Object)$this$readAtMostTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Segment segment = $this$readAtMostTo.getHead();
        if (segment == null) {
            return -1;
        }
        Segment s = segment;
        int toCopy = Math.min(sink.remaining(), s.getLimit() - s.getPos());
        sink.put(s.data, s.getPos(), toCopy);
        s.setPos(s.getPos() + toCopy);
        $this$readAtMostTo.setSizeMut($this$readAtMostTo.getSizeMut() - (long)toCopy);
        if (s.getPos() == s.getLimit()) {
            $this$readAtMostTo.recycleHead$kotlinx_io_core();
        }
        return toCopy;
    }

    @NotNull
    public static final Buffer transferFrom(@NotNull Buffer $this$transferFrom, @NotNull ByteBuffer source) {
        int byteCount;
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)$this$transferFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        for (int remaining = byteCount = source.remaining(); remaining > 0; remaining -= toCopy) {
            Segment tail = $this$transferFrom.writableSegment(1);
            toCopy = Math.min(remaining, 8192 - tail.getLimit());
            source.get(tail.data, tail.getLimit(), toCopy);
            tail.setLimit(tail.getLimit() + toCopy);
        }
        $this$transferFrom.setSizeMut($this$transferFrom.getSizeMut() + (long)byteCount);
        return $this$transferFrom;
    }

    @NotNull
    public static final ByteChannel asByteChannel(@NotNull Buffer $this$asByteChannel) {
        Intrinsics.checkNotNullParameter((Object)$this$asByteChannel, (String)"<this>");
        return new ByteChannel($this$asByteChannel){
            final /* synthetic */ Buffer $this_asByteChannel;
            {
                this.$this_asByteChannel = $receiver;
            }

            public int read(ByteBuffer sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                return BuffersJvmKt.readAtMostTo(this.$this_asByteChannel, sink);
            }

            public int write(ByteBuffer source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                long sizeBefore = this.$this_asByteChannel.getSize();
                BuffersJvmKt.transferFrom(this.$this_asByteChannel, source);
                return (int)(this.$this_asByteChannel.getSize() - sizeBefore);
            }

            public void close() {
            }

            public boolean isOpen() {
                return true;
            }
        };
    }
}

