/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirNameConflictsTrackerComponent;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNameConflictsTracker;", "Lorg/jetbrains/kotlin/fir/FirNameConflictsTrackerComponent;", "<init>", "()V", "_redeclaredClassifiers", "", "Lorg/jetbrains/kotlin/name/ClassId;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNameConflictsTracker$ClassifierWithFile;", "redeclaredClassifiers", "", "getRedeclaredClassifiers", "()Ljava/util/Map;", "registerClassifierRedeclaration", "", "classId", "newSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "newSymbolFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "prevSymbol", "prevSymbolFile", "ClassifierWithFile", "checkers"})
public final class FirNameConflictsTracker
extends FirNameConflictsTrackerComponent {
    @NotNull
    private final Map<ClassId, Set<ClassifierWithFile>> _redeclaredClassifiers = new HashMap();

    @NotNull
    public final Map<ClassId, Set<ClassifierWithFile>> getRedeclaredClassifiers() {
        return this._redeclaredClassifiers;
    }

    @Override
    public void registerClassifierRedeclaration(@NotNull ClassId classId, @NotNull FirClassLikeSymbol<?> newSymbol, @NotNull FirFile newSymbolFile, @NotNull FirClassLikeSymbol<?> prevSymbol, @Nullable FirFile prevSymbolFile) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter(newSymbol, (String)"newSymbol");
        Intrinsics.checkNotNullParameter((Object)newSymbolFile, (String)"newSymbolFile");
        Intrinsics.checkNotNullParameter(prevSymbol, (String)"prevSymbol");
        Object[] objectArray = new ClassifierWithFile[]{new ClassifierWithFile(newSymbol, newSymbolFile), new ClassifierWithFile(prevSymbol, prevSymbolFile)};
        this._redeclaredClassifiers.merge(classId, SetsKt.linkedSetOf((Object[])objectArray), (arg_0, arg_1) -> FirNameConflictsTracker.registerClassifierRedeclaration$lambda$1(FirNameConflictsTracker::registerClassifierRedeclaration$lambda$0, arg_0, arg_1));
    }

    private static final Set registerClassifierRedeclaration$lambda$0(Set a, Set b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return SetsKt.plus((Set)a, (Iterable)b);
    }

    private static final Set registerClassifierRedeclaration$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Set)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNameConflictsTracker$ClassifierWithFile;", "", "classifier", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getClassifier", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    public static final class ClassifierWithFile {
        @NotNull
        private final FirClassLikeSymbol<?> classifier;
        @Nullable
        private final FirFile file;

        public ClassifierWithFile(@NotNull FirClassLikeSymbol<?> classifier, @Nullable FirFile file) {
            Intrinsics.checkNotNullParameter(classifier, (String)"classifier");
            this.classifier = classifier;
            this.file = file;
        }

        @NotNull
        public final FirClassLikeSymbol<?> getClassifier() {
            return this.classifier;
        }

        @Nullable
        public final FirFile getFile() {
            return this.file;
        }

        @NotNull
        public final FirClassLikeSymbol<?> component1() {
            return this.classifier;
        }

        @Nullable
        public final FirFile component2() {
            return this.file;
        }

        @NotNull
        public final ClassifierWithFile copy(@NotNull FirClassLikeSymbol<?> classifier, @Nullable FirFile file) {
            Intrinsics.checkNotNullParameter(classifier, (String)"classifier");
            return new ClassifierWithFile(classifier, file);
        }

        public static /* synthetic */ ClassifierWithFile copy$default(ClassifierWithFile classifierWithFile, FirClassLikeSymbol firClassLikeSymbol, FirFile firFile, int n, Object object) {
            if ((n & 1) != 0) {
                firClassLikeSymbol = classifierWithFile.classifier;
            }
            if ((n & 2) != 0) {
                firFile = classifierWithFile.file;
            }
            return classifierWithFile.copy(firClassLikeSymbol, firFile);
        }

        @NotNull
        public String toString() {
            return "ClassifierWithFile(classifier=" + this.classifier + ", file=" + this.file + ')';
        }

        public int hashCode() {
            int result2 = this.classifier.hashCode();
            result2 = result2 * 31 + (this.file == null ? 0 : this.file.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassifierWithFile)) {
                return false;
            }
            ClassifierWithFile classifierWithFile = (ClassifierWithFile)other;
            if (!Intrinsics.areEqual(this.classifier, classifierWithFile.classifier)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)classifierWithFile.file);
        }
    }
}

