/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "analyze", "", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "ignoreWarnings", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getIgnoreWarnings", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "Data", "AddAllWrites", "FindVisibleWrites", "RemoveVisibleWrites", "checkers"})
public final class UnusedChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final UnusedChecker INSTANCE = new UnusedChecker();

    private UnusedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void analyze(@NotNull VariableInitializationInfoData data, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Set<FirVariableSymbol<?>> set = data.getProperties();
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.Set<org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol>");
        Set<FirVariableSymbol<?>> properties = set;
        Data ownData = new Data(properties);
        data.getGraph().traverse(new AddAllWrites(ownData));
        if (!ownData.getUnreadWrites().isEmpty()) {
            ownData.setWritesByNode(CfgTraverserKt.traverseToFixedPoint(data.getGraph(), new FindVisibleWrites(properties)));
        }
        data.getGraph().traverse(new RemoveVisibleWrites(ownData));
        Set variablesWithUnobservedWrites = new LinkedHashSet();
        for (Map.Entry<FirStatement, ControlFlowGraph> entry : ownData.getUnreadWrites().entrySet()) {
            FirStatement statement = entry.getKey();
            ControlFlowGraph scope = entry.getValue();
            if (statement instanceof FirVariableAssignment) {
                Object object = ReferenceUtilsKt.getCalleeReference((FirVariableAssignment)statement);
                if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) continue;
                Object variableSymbol = object;
                variablesWithUnobservedWrites.add(variableSymbol);
                if (!ownData.getVariablesWithoutReads().containsKey(variableSymbol) && !Intrinsics.areEqual((Object)scope, (Object)ownData.getVariableScopes().get(variableSymbol))) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirVariableAssignment)statement).getLValue().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), (DiagnosticContext)context2, null, (int)8, null);
                continue;
            }
            if (!(statement instanceof FirProperty) || ownData.getVariablesWithoutReads().containsKey(((FirProperty)statement).getSymbol()) || this.getIgnoreWarnings(((FirProperty)statement).getSymbol())) continue;
            FirExpression firExpression = ((FirProperty)statement).getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null)), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), (DiagnosticContext)context2, null, (int)8, null);
        }
        for (Map.Entry<Object, Object> entry : ownData.getVariablesWithoutReads().entrySet()) {
            FirPropertySymbol symbol = (FirPropertySymbol)entry.getKey();
            FirProperty fir = (FirProperty)entry.getValue();
            if (this.getIgnoreWarnings(symbol)) continue;
            FirExpression firExpression = fir.getInitializer();
            FirFunctionCall firFunctionCall = firExpression instanceof FirFunctionCall ? (FirFunctionCall)firExpression : null;
            if ((firFunctionCall != null ? FirHelpersKt.isIterator(firFunctionCall) : false) || Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter(fir), (Object)true)) continue;
            KtDiagnosticFactory0 error = variablesWithUnobservedWrites.contains(symbol) ? FirErrors.INSTANCE.getVARIABLE_NEVER_READ() : FirErrors.INSTANCE.getUNUSED_VARIABLE();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)fir.getSource()), (KtDiagnosticFactory0)error, (DiagnosticContext)context2, null, (int)8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getIgnoreWarnings(FirPropertySymbol $this$ignoreWarnings) {
        if (Intrinsics.areEqual((Object)$this$ignoreWarnings.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) return true;
        if ($this$ignoreWarnings.getSource() == null) return true;
        KtSourceElement ktSourceElement = $this$ignoreWarnings.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredAugmentedAssign) return true;
        KtSourceElement ktSourceElement2 = $this$ignoreWarnings.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) return true;
        KtSourceElement ktSourceElement3 = $this$ignoreWarnings.getInitializerSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement3 != null ? ktSourceElement3.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) return false;
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$AddAllWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;)V", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    private static final class AddAllWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Data data;

        public AddAllWrites(@NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ControlFlowGraph graph = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner());
            if (node.getFir().getInitializer() != null) {
                this.data.getUnreadWrites().put(node.getFir(), graph);
            }
            this.data.getVariableScopes().put(node.getFir().getSymbol(), graph);
            this.data.getVariablesWithoutReads().put(node.getFir().getSymbol(), node.getFir());
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirReference firReference = ReferenceUtilsKt.getCalleeReference(node.getFir());
            if (CollectionsKt.contains((Iterable)this.data.getLocalProperties(), firReference != null ? FirReferenceUtilsKt.toResolvedPropertySymbol$default(firReference, false, 1, null) : null)) {
                this.data.getUnreadWrites().put(node.getFir(), FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner()));
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRr\u0010\t\u001aZ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012L\u0012J\u0012\u0004\u0012\u00020\r\u0012<\u0012:\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000ej\u0002`\u000f0\fj\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u000ej\u0002`\u000f`\u00100\fj\u0002`\u00110\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;", "", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Set;)V", "getLocalProperties", "()Ljava/util/Set;", "writesByNode", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lkotlinx/collections/immutable/PersistentSet;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PathAwareVariableWriteInfo;", "getWritesByNode", "()Ljava/util/Map;", "setWritesByNode", "(Ljava/util/Map;)V", "unreadWrites", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "getUnreadWrites", "variableScopes", "getVariableScopes", "variablesWithoutReads", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariablesWithoutReads", "checkers"})
    private static final class Data {
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>>> writesByNode;
        @NotNull
        private final Map<FirStatement, ControlFlowGraph> unreadWrites;
        @NotNull
        private final Map<FirPropertySymbol, ControlFlowGraph> variableScopes;
        @NotNull
        private final Map<FirPropertySymbol, FirProperty> variablesWithoutReads;

        public Data(@NotNull Set<? extends FirPropertySymbol> localProperties) {
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            this.localProperties = localProperties;
            this.writesByNode = MapsKt.emptyMap();
            this.unreadWrites = new LinkedHashMap();
            this.variableScopes = new LinkedHashMap();
            this.variablesWithoutReads = new LinkedHashMap();
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Map<CFGNode<?>, PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>>> getWritesByNode() {
            return this.writesByNode;
        }

        public final void setWritesByNode(@NotNull Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.writesByNode = map;
        }

        @NotNull
        public final Map<FirStatement, ControlFlowGraph> getUnreadWrites() {
            return this.unreadWrites;
        }

        @NotNull
        public final Map<FirPropertySymbol, ControlFlowGraph> getVariableScopes() {
            return this.variableScopes;
        }

        @NotNull
        public final Map<FirPropertySymbol, FirProperty> getVariablesWithoutReads() {
            return this.variablesWithoutReads;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u0001B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ~\u0010\n\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u0002`\f2$\u0010\r\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u0002`\f2$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u0002`\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u00ba\u0001\u0010\u0010\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u0013*J\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0014\u0010\u0015\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005H\u0002J\u00a8\u0001\u0010\u0016\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u00132\u0006\u0010\u000f\u001a\u00020\u00172N\u0010\u0015\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u0013H\u0016J\u00a8\u0001\u0010\u0018\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u00132\u0006\u0010\u000f\u001a\u00020\u00192N\u0010\u0015\u001aJ\u0012\u0004\u0012\u00020\u0011\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u00050\u000bj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\u0002`\u0005`\u00120\u000bj\u0002`\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$FindVisibleWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lkotlinx/collections/immutable/PersistentSet;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWrites;", "properties", "", "<init>", "(Ljava/util/Set;)V", "mergeInfo", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWriteInfo;", "a", "b", "node", "overwrite", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PathAwareVariableWriteInfo;", "symbol", "data", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$FindVisibleWrites\n+ 2 PathAwareControlFlowGraphVisitor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitorKt\n+ 3 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n82#2:173\n83#2:175\n84#2:179\n86#2:182\n89#2:183\n53#3:174\n53#3:184\n412#4:176\n412#4:185\n1246#5,2:177\n1249#5:181\n1246#5,4:186\n1#6:180\n1#6:190\n*S KotlinDebug\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$FindVisibleWrites\n*L\n107#1:173\n107#1:175\n107#1:179\n107#1:182\n110#1:183\n107#1:174\n110#1:184\n107#1:176\n110#1:185\n107#1:177,2\n107#1:181\n110#1:186,4\n107#1:180\n*E\n"})
    private static final class FindVisibleWrites
    extends PathAwareControlFlowGraphVisitor<FirPropertySymbol, PersistentSet<? extends CFGNode<?>>> {
        @NotNull
        private final Set<FirPropertySymbol> properties;

        public FindVisibleWrites(@NotNull Set<? extends FirPropertySymbol> properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            this.properties = properties;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>> mergeInfo(@NotNull PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> a, @NotNull PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> b, @NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(b, (String)"b");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> $this$merge$iv = a;
            boolean $i$f$merge = false;
            PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> $this$mutate$iv$iv = $this$merge$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = (Map)builder2;
            boolean bl = false;
            Map $this$mapValuesTo$iv$iv = (Map)b;
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                Map map;
                Object k;
                block4: {
                    Object rightValue$iv;
                    block3: {
                        void p1;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map2 = it$iv;
                        boolean bl2 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        k = it$iv$iv.getKey();
                        map = map2;
                        boolean bl3 = false;
                        Object label$iv = entry2.getKey();
                        rightValue$iv = entry2.getValue();
                        object = $this$merge$iv.get(label$iv);
                        if (object == null) break block3;
                        Object leftValue$iv = object;
                        boolean bl4 = false;
                        Collection collection = (Collection)rightValue$iv;
                        PersistentSet p0 = (PersistentSet)leftValue$iv;
                        boolean bl5 = false;
                        PersistentSet persistentSet = p0.addAll((Collection)p1);
                        object = persistentSet;
                        if (persistentSet != null) break block4;
                    }
                    object = rightValue$iv;
                }
                Object object2 = object;
                map.put(k, object2);
            }
            return builder2.build();
        }

        /*
         * WARNING - void declaration
         */
        private final PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> overwrite(PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> $this$overwrite, FirPropertySymbol symbol, PersistentSet<? extends CFGNode<?>> data) {
            PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> $this$transformValues$iv = $this$overwrite;
            boolean $i$f$transformValues = false;
            PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> $this$mutate$iv$iv = $this$transformValues$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = (Map)builder2;
            boolean bl = false;
            Map $this$mapValuesTo$iv$iv = (Map)$this$transformValues$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map = it$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl3 = false;
                Object values$iv = entry2.getValue();
                PersistentMap it = (PersistentMap)values$iv;
                boolean bl4 = false;
                PersistentMap persistentMap = it.put((Object)symbol, data);
                map2.put(k, persistentMap);
            }
            return builder2.build();
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> data) {
            PersistentSet persistentSet;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirPropertySymbol firPropertySymbol = node.getFir().getSymbol();
            if (node.getFir().getInitializer() != null) {
                Object[] objectArray = new VariableDeclarationNode[]{node};
                persistentSet = ExtensionsKt.persistentSetOf((Object[])objectArray);
            } else {
                persistentSet = ExtensionsKt.persistentSetOf();
            }
            return this.overwrite(data, firPropertySymbol, persistentSet);
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> data) {
            Object object;
            block3: {
                block2: {
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) break block2;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = this.properties.contains(it) ? object2 : null;
                    if (object != null) break block3;
                }
                return data;
            }
            Object symbol = object;
            Object[] objectArray = new VariableAssignmentNode[]{node};
            return this.overwrite(data, (FirPropertySymbol)symbol, ExtensionsKt.persistentSetOf((Object[])objectArray));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u001c\u0010\u000f\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$RemoveVisibleWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$Data;)V", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitFunctionCallExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallExitNode;", "visitAnnotations", "visitQualifiedAccess", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$RemoveVisibleWrites\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1863#3,2:174\n1863#3:176\n1863#3,2:177\n1864#3:179\n*S KotlinDebug\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedChecker$RemoveVisibleWrites\n*L\n147#1:174,2\n162#1:176\n163#1:177,2\n162#1:179\n*E\n"})
    private static final class RemoveVisibleWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Data data;

        public RemoveVisibleWrites(@NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            this.visitAnnotations(node);
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.visitAnnotations(node);
            this.visitQualifiedAccess(node, node.getFir());
        }

        @Override
        public void visitFunctionCallExitNode(@NotNull FunctionCallExitNode node) {
            block0: {
                FirQualifiedAccessExpression firQualifiedAccessExpression;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.visitAnnotations(node);
                FirFunctionCall firFunctionCall = node.getFir();
                FirImplicitInvokeCall firImplicitInvokeCall = firFunctionCall instanceof FirImplicitInvokeCall ? (FirImplicitInvokeCall)firFunctionCall : null;
                FirExpression firExpression = firImplicitInvokeCall != null ? firImplicitInvokeCall.getExplicitReceiver() : null;
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
                if (firQualifiedAccessExpression == null) break block0;
                FirQualifiedAccessExpression it = firQualifiedAccessExpression;
                boolean bl = false;
                this.visitQualifiedAccess(node, it);
            }
        }

        private final void visitAnnotations(CFGNode<?> node) {
            block1: {
                Object obj = node.getFir();
                Object object = obj instanceof FirAnnotationContainer ? (FirAnnotationContainer)obj : null;
                if (object == null || (object = object.getAnnotations()) == null) break block1;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirAnnotation call2 = (FirAnnotation)element$iv;
                    boolean bl = false;
                    call2.accept(new FirVisitorVoid(this, node){
                        final /* synthetic */ RemoveVisibleWrites this$0;
                        final /* synthetic */ CFGNode<?> $node;
                        {
                            this.this$0 = $receiver;
                            this.$node = $node;
                        }

                        public void visitElement(FirElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            if (element instanceof FirQualifiedAccessExpression) {
                                RemoveVisibleWrites.access$visitQualifiedAccess(this.this$0, this.$node, (FirQualifiedAccessExpression)element);
                            }
                            element.acceptChildren(this);
                        }
                    });
                }
            }
        }

        private final void visitQualifiedAccess(CFGNode<?> node, FirQualifiedAccessExpression fir) {
            block3: {
                FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(fir.getCalleeReference(), false, 1, null);
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol symbol = firPropertySymbol;
                this.data.getVariablesWithoutReads().remove(symbol);
                ImmutableCollection immutableCollection = this.data.getWritesByNode().get(node);
                if (immutableCollection == null || (immutableCollection = (ImmutableCollection)immutableCollection.values()) == null) break block3;
                Iterable $this$forEach$iv = (Iterable)immutableCollection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PersistentMap dataForLabel = (PersistentMap)element$iv;
                    boolean bl = false;
                    PersistentSet persistentSet = (PersistentSet)dataForLabel.get((Object)symbol);
                    if (persistentSet == null) continue;
                    Iterable $this$forEach$iv2 = (Iterable)persistentSet;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CFGNode it = (CFGNode)element$iv2;
                        boolean bl2 = false;
                        Map<FirStatement, ControlFlowGraph> map = this.data.getUnreadWrites();
                        Object e = it.getFir();
                        TypeIntrinsics.asMutableMap(map).remove(e);
                    }
                }
            }
        }

        public static final /* synthetic */ void access$visitQualifiedAccess(RemoveVisibleWrites $this, CFGNode node, FirQualifiedAccessExpression fir) {
            $this.visitQualifiedAccess(node, fir);
        }
    }
}

