/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsModuleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
public final class FirWasmJsModuleChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirWasmJsModuleChecker INSTANCE = new FirWasmJsModuleChecker();

    private FirWasmJsModuleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration instanceof FirFile || !FirAnnotationUtilsKt.hasAnnotation(declaration, WebCommonStandardClassIds.Annotations.JsModule, context2.getSession())) {
            return;
        }
        if (declaration instanceof FirProperty && ((FirProperty)declaration).isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirProperty)declaration).getSource()), (KtDiagnosticFactory0)FirWasmErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_VAR(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (!FirWebCommonHelpersKt.isEffectivelyExternal(declaration.getSymbol(), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirWasmErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_NON_EXTERNAL(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (FirHelpersKt.isTopLevel(context2)) {
            FirFile firFile = context2.getContainingFile();
            boolean bl = firFile != null ? FirAnnotationUtilsKt.hasAnnotation(firFile, WebCommonStandardClassIds.Annotations.JsModule, context2.getSession()) : false;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirWasmErrors.INSTANCE.getNESTED_JS_MODULE_PROHIBITED(), (DiagnosticContext)context2, null, (int)8, null);
            }
        }
    }
}

