/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.bytecode;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

class Location {
    @Nullable
    final Editor editor;
    @Nullable
    final KtFile ktFile;
    final long modificationStamp;
    final int startOffset;
    final int endOffset;

    private Location(@Nullable Editor editor, Project project) {
        this.editor = editor;
        if (editor != null) {
            PsiFile psiFile;
            this.modificationStamp = editor.getDocument().getModificationStamp();
            this.startOffset = editor.getSelectionModel().getSelectionStart();
            this.endOffset = editor.getSelectionModel().getSelectionEnd();
            VirtualFile vFile = editor.getVirtualFile();
            this.ktFile = vFile == null ? null : ((psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) instanceof KtFile ? (KtFile)psiFile : null);
        } else {
            this.modificationStamp = 0L;
            this.startOffset = 0;
            this.endOffset = 0;
            this.ktFile = null;
        }
    }

    public static Location fromEditor(Editor editor, Project project) {
        return new Location(editor, project);
    }

    @Nullable
    public KtFile getKFile() {
        return this.ktFile;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        if (this.modificationStamp != location.modificationStamp) {
            return false;
        }
        if (this.endOffset != location.endOffset) {
            return false;
        }
        if (this.startOffset != location.startOffset) {
            return false;
        }
        if (!Objects.equals(this.editor, location.editor)) {
            return false;
        }
        return Objects.equals(this.ktFile, location.ktFile);
    }

    public int hashCode() {
        int result2 = this.editor != null ? this.editor.hashCode() : 0;
        result2 = 31 * result2 + (this.ktFile != null ? this.ktFile.hashCode() : 0);
        result2 = 31 * result2 + Long.hashCode(this.modificationStamp);
        result2 = 31 * result2 + this.startOffset;
        result2 = 31 * result2 + this.endOffset;
        return result2;
    }
}

