/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinGlobalSearchScopeMerger;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinResolutionScopeProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.DependenciesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProvider;
import org.jetbrains.kotlin.idea.base.analysis.builtins.BuiltInsUtilsKt;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinResolveScopeEnlarger;
import org.jetbrains.kotlin.idea.base.projectStructure.KtSourceModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtSourceModuleByModuleInfoForOutsider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleDependencyCollector;
import org.jetbrains.kotlin.idea.base.projectStructure.ProjectModuleByModuleInfoKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinByModulesResolutionScopeProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinResolutionScopeProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getResolutionScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "adjustScope", "baseScope", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "withBuiltInsScope", "excludeIgnoredModulesByKotlinProjectModel", "moduleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "includeTests", "", "kotlin.base.analysis-api-platform"})
@SourceDebugExtension(value={"SMAP\nIdeKotlinByModulesResolutionScopeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinByModulesResolutionScopeProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinByModulesResolutionScopeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1557#2:99\n1628#2,3:100\n1557#2:103\n1628#2,3:104\n*S KotlinDebug\n*F\n+ 1 IdeKotlinByModulesResolutionScopeProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinByModulesResolutionScopeProvider\n*L\n48#1:99\n48#1:100,3\n91#1:103\n91#1:104,3\n*E\n"})
public final class IdeKotlinByModulesResolutionScopeProvider
implements KotlinResolutionScopeProvider {
    @NotNull
    private final Project project;

    public IdeKotlinByModulesResolutionScopeProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GlobalSearchScope getResolutionScope(@NotNull KaModule module) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KaModule kaModule = module;
        if (kaModule instanceof KaSourceModule) {
            IdeaModuleInfo ideaModuleInfo = KotlinProjectStructureUtils.getModuleInfo(module);
            Intrinsics.checkNotNull((Object)ideaModuleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo");
            moduleInfo = (ModuleSourceInfo)ideaModuleInfo;
            boolean includeTests = moduleInfo instanceof ModuleTestSourceInfo;
            GlobalSearchScope scope = this.excludeIgnoredModulesByKotlinProjectModel(moduleInfo, (KaSourceModule)module, includeTests);
            object = this.adjustScope(scope, (KaSourceModule)module);
        } else if (kaModule instanceof KaDanglingFileModule) {
            Object[] scope = new GlobalSearchScope[]{KotlinScopeUtils.fileScope((PsiFile)((KaDanglingFileModule)module).getFile()), this.getResolutionScope(((KaDanglingFileModule)module).getContextModule())};
            List scopes = CollectionsKt.listOf((Object[])scope);
            moduleInfo = GlobalSearchScope.union((Collection)scopes);
            Intrinsics.checkNotNull((Object)moduleInfo);
            object = moduleInfo;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable scopes;
            List $this$getResolutionScope_u24lambda_u240 = scopes = CollectionsKt.createListBuilder();
            boolean $i$a$-buildList-IdeKotlinByModulesResolutionScopeProvider$getResolutionScope$scope$allModules$22 = false;
            boolean bl = module instanceof KaLibrarySourceModule ? $this$getResolutionScope_u24lambda_u240.add(((KaLibrarySourceModule)module).getBinaryLibrary()) : $this$getResolutionScope_u24lambda_u240.add(module);
            CollectionsKt.addAll((Collection)$this$getResolutionScope_u24lambda_u240, DependenciesKt.allDirectDependencies(module));
            List allModules = CollectionsKt.build((List)scopes);
            scopes = allModules;
            KotlinGlobalSearchScopeMerger kotlinGlobalSearchScopeMerger = KotlinGlobalSearchScopeMerger.Companion.getInstance(this.project);
            boolean $i$f$map = false;
            void $i$a$-buildList-IdeKotlinByModulesResolutionScopeProvider$getResolutionScope$scope$allModules$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KaModule kaModule2 = (KaModule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getContentScope());
            }
            object = kotlinGlobalSearchScopeMerger.union((List)destination$iv$iv);
        }
        GlobalSearchScope scope = object;
        return module instanceof KtSourceModuleByModuleInfo ? KotlinResolveScopeEnlarger.Companion.enlargeScope(scope, ((KtSourceModuleByModuleInfo)module).getIdeaModule(), ((KtSourceModuleByModuleInfo)module).getIdeaModuleInfo() instanceof ModuleTestSourceInfo) : scope;
    }

    private final GlobalSearchScope adjustScope(GlobalSearchScope baseScope, KaSourceModule module) {
        GlobalSearchScope scope = baseScope;
        if (module instanceof KtSourceModuleByModuleInfoForOutsider) {
            scope = ((KtSourceModuleByModuleInfoForOutsider)module).adjustContentScope(scope);
        }
        if (BuiltInsUtilsKt.hasCommonKotlinStdlib(module.getTargetPlatform())) {
            scope = this.withBuiltInsScope(scope, module.getProject());
        }
        return scope;
    }

    private final GlobalSearchScope withBuiltInsScope(GlobalSearchScope $this$withBuiltInsScope, Project project) {
        GlobalSearchScope builtinsScope = BuiltinsVirtualFileProvider.Companion.getInstance().createBuiltinsScope(project);
        Object[] objectArray = new GlobalSearchScope[]{$this$withBuiltInsScope, builtinsScope};
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((Collection)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(...)");
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope excludeIgnoredModulesByKotlinProjectModel(ModuleSourceInfo moduleInfo, KaSourceModule module, boolean includeTests) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = ProjectModuleByModuleInfoKt.collectDependencies(moduleInfo, ModuleDependencyCollector.CollectionMode.COLLECT_IGNORED);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KaModule kaModule = (KaModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContentScope());
        }
        List ignored = (List)destination$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)KotlinProjectStructureUtils.getIdeaModule(module), (boolean)includeTests);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        if (ignored.isEmpty()) {
            return searchScope;
        }
        GlobalSearchScope globalSearchScope2 = KotlinScopeUtils.minus(searchScope, KotlinGlobalSearchScopeMerger.Companion.getInstance(this.project).union(ignored));
        Intrinsics.checkNotNull((Object)globalSearchScope2, (String)"null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
        return globalSearchScope2;
    }
}

