/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PackageOracle;
import org.jetbrains.kotlin.analyzer.PackageOracleFactory;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.caches.resolve.IdePackageOracleFactoryKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory;", "Lorg/jetbrains/kotlin/analyzer/PackageOracleFactory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createOracle", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "JavaPackagesOracle", "KotlinSourceFilesOracle", "JvmSourceOracle", "kotlin.base.fe10.analysis"})
public final class IdePackageOracleFactory
implements PackageOracleFactory {
    @NotNull
    private final Project project;

    public IdePackageOracleFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public PackageOracle createOracle(@NotNull ModuleInfo moduleInfo) {
        PackageOracle packageOracle;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
                if (!(moduleInfo instanceof IdeaModuleInfo)) {
                    return (PackageOracle)PackageOracle.Optimistic.INSTANCE;
                }
                if (!JvmPlatformKt.isJvm((TargetPlatform)moduleInfo.getPlatform())) break block6;
                switch (WhenMappings.$EnumSwitchMapping$0[((IdeaModuleInfo)moduleInfo).getModuleOrigin().ordinal()]) {
                    case 1: {
                        packageOracle = new JavaPackagesOracle((IdeaModuleInfo)moduleInfo, this.project);
                        break block7;
                    }
                    case 2: {
                        packageOracle = new JvmSourceOracle((IdeaModuleInfo)moduleInfo, this.project);
                        break block7;
                    }
                    case 3: {
                        packageOracle = (PackageOracle)PackageOracle.Optimistic.INSTANCE;
                        break block7;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            packageOracle = WhenMappings.$EnumSwitchMapping$0[((IdeaModuleInfo)moduleInfo).getModuleOrigin().ordinal()] == 2 ? (PackageOracle)new KotlinSourceFilesOracle((IdeaModuleInfo)moduleInfo, this.project) : (PackageOracle)PackageOracle.Optimistic.INSTANCE;
        }
        return packageOracle;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;Lcom/intellij/openapi/project/Project;)V", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "facade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.base.fe10.analysis"})
    @SourceDebugExtension(value={"SMAP\nIdePackageOracleFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePackageOracleFactory.kt\norg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,67:1\n31#2,2:68\n*S KotlinDebug\n*F\n+ 1 IdePackageOracleFactory.kt\norg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle\n*L\n42#1:68,2\n*E\n"})
    private static final class JavaPackagesOracle
    implements PackageOracle {
        @NotNull
        private final GlobalSearchScope scope;
        @NotNull
        private final KotlinJavaPsiFacade facade;

        public JavaPackagesOracle(@NotNull IdeaModuleInfo moduleInfo, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.scope = moduleInfo.getContentScope();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinJavaPsiFacade> serviceClass$iv = KotlinJavaPsiFacade.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            this.facade = (KotlinJavaPsiFacade)object;
        }

        public boolean packageExists(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            return this.facade.findPackage(fqName2.asString(), this.scope) != null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JvmSourceOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;Lcom/intellij/openapi/project/Project;)V", "javaPackagesOracle", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle;", "kotlinSourceOracle", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.base.fe10.analysis"})
    private static final class JvmSourceOracle
    implements PackageOracle {
        @NotNull
        private final JavaPackagesOracle javaPackagesOracle;
        @NotNull
        private final KotlinSourceFilesOracle kotlinSourceOracle;

        public JvmSourceOracle(@NotNull IdeaModuleInfo moduleInfo, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.javaPackagesOracle = new JavaPackagesOracle(moduleInfo, project);
            this.kotlinSourceOracle = new KotlinSourceFilesOracle(moduleInfo, project);
        }

        public boolean packageExists(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            return this.javaPackagesOracle.packageExists(fqName2) || this.kotlinSourceOracle.packageExists(fqName2) || FqNamesUtilKt.isSubpackageOf((FqName)fqName2, (FqName)IdePackageOracleFactoryKt.access$getANDROID_SYNTHETIC_PACKAGE_PREFIX$p());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;Lcom/intellij/openapi/project/Project;)V", "cacheService", "Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "sourceModules", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.base.fe10.analysis"})
    @SourceDebugExtension(value={"SMAP\nIdePackageOracleFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePackageOracleFactory.kt\norg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n31#2,2:68\n1755#3,3:70\n*S KotlinDebug\n*F\n+ 1 IdePackageOracleFactory.kt\norg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle\n*L\n48#1:68,2\n52#1:70,3\n*E\n"})
    private static final class KotlinSourceFilesOracle
    implements PackageOracle {
        @NotNull
        private final PerModulePackageCacheService cacheService;
        @NotNull
        private final List<ModuleSourceInfo> sourceModules;

        public KotlinSourceFilesOracle(@NotNull IdeaModuleInfo moduleInfo, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PerModulePackageCacheService> serviceClass$iv = PerModulePackageCacheService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            this.cacheService = (PerModulePackageCacheService)object;
            this.sourceModules = IdeaModuleInfoUtils.projectSourceModules(moduleInfo);
        }

        public boolean packageExists(@NotNull FqName fqName2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                Iterable $this$any$iv = this.sourceModules;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ModuleSourceInfo it = (ModuleSourceInfo)element$iv;
                        boolean bl2 = false;
                        if (!this.cacheService.packageExists(fqName2, it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModuleOrigin.values().length];
            try {
                nArray[ModuleOrigin.LIBRARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleOrigin.MODULE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModuleOrigin.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

