/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.RedundantLabeledReturnOnLastExpressionInLambdaInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0019\u0010\u0015\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantLabeledReturnOnLastExpressionInLambdaInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "", "<init>", "()V", "getProblemDescription", "", "element", "context", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lkotlin/Unit;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicableByPsi", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtReturnExpression;)V", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nRedundantLabeledReturnOnLastExpressionInLambdaInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantLabeledReturnOnLastExpressionInLambdaInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantLabeledReturnOnLastExpressionInLambdaInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n150#2:91\n1#3:92\n*S KotlinDebug\n*F\n+ 1 RedundantLabeledReturnOnLastExpressionInLambdaInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RedundantLabeledReturnOnLastExpressionInLambdaInspection\n*L\n42#1:91\n*E\n"})
public final class RedundantLabeledReturnOnLastExpressionInLambdaInspection
extends KotlinApplicableInspectionBase.Simple<KtReturnExpression, Unit> {
    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtReturnExpression element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"inspection.redundant.labeled.return.on.last.expression.in.lambda.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.returnExpressionVisitor(arg_0 -> RedundantLabeledReturnOnLastExpressionInLambdaInspection.buildVisitor$lambda$0(this, holder, isOnTheFly, arg_0));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtReturnExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getLabelName();
        if (string == null) {
            return false;
        }
        String labelName = string;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block = ktBlockExpression;
        List list2 = block.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)list2), (Object)element)) {
            return false;
        }
        String string2 = KotlinPsiUtils.getParentLambdaLabelName(block);
        if (string2 == null) {
            return false;
        }
        String callName = string2;
        return Intrinsics.areEqual((Object)labelName, (Object)callName);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtReturnExpression element) {
        TextRange textRange;
        TextRange textRange2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getLabeledExpression();
        if (psiElement != null && (textRange2 = psiElement.getTextRangeInParent()) != null) {
            TextRange it = textRange2;
            boolean bl = false;
            textRange = element.getReturnKeyword().getTextRangeInParent().union(it);
        } else {
            textRange = null;
        }
        TextRange labelRange = textRange;
        return CollectionsKt.listOfNotNull(labelRange);
    }

    @Override
    public void prepareContext(@NotNull KaSession $context_receiver_0, @NotNull KtReturnExpression element) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtReturnExpression> createQuickFix(@NotNull KtReturnExpression element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SmartPsiElementPointer smartPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)element));
        return new KotlinModCommandQuickFix<KtReturnExpression>((SmartPsiElementPointer<KtReturnExpression>)smartPointer){
            final /* synthetic */ SmartPsiElementPointer<KtReturnExpression> $smartPointer;
            {
                this.$smartPointer = $smartPointer;
            }

            public String getFamilyName() {
                return KotlinBundle.message((String)"remove.labeled.return.from.last.expression.in.a.lambda", (Object[])new Object[0]);
            }

            public String getName() {
                return this.getName(this.$smartPointer, createQuickFix.1::getName$lambda$0);
            }

            protected void applyFix(Project project, KtReturnExpression element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtExpression returnedExpression = element.getReturnedExpression();
                if (returnedExpression == null) {
                    element.delete();
                } else {
                    element.replace((PsiElement)returnedExpression);
                }
            }

            private static final String getName$lambda$0(KtReturnExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = new Object[1];
                String string = it.getLabelName();
                if (string == null) {
                    string = "";
                }
                objectArray[0] = string;
                return KotlinBundle.message((String)"remove.return.0", (Object[])objectArray);
            }
        };
    }

    private static final Unit buildVisitor$lambda$0(RedundantLabeledReturnOnLastExpressionInLambdaInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtReturnExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }
}

