/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@IntellijInternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u0002H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0002H\u0002R\u0014\u0010\r\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SortModifiersInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "isApplicable", "", "element", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "modifierKeywordTokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "modifiersBeforeAnnotations", "kotlin.code-insight.inspections.shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSortModifiersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortModifiersInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SortModifiersInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n295#2,2:78\n543#2,6:80\n774#2:86\n865#2,2:87\n1863#2,2:89\n3193#2,10:91\n1863#2,2:102\n1#3:101\n*S KotlinDebug\n*F\n+ 1 SortModifiersInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SortModifiersInspection\n*L\n37#1:78,2\n38#1:80,6\n50#1:86\n50#1:87,2\n51#1:89,2\n55#1:91,10\n57#1:102,2\n*E\n"})
public final class SortModifiersInspection
extends AbstractApplicabilityBasedInspection<KtModifierList>
implements CleanupLocalInspectionTool {
    public SortModifiersInspection() {
        super(KtModifierList.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtModifierList element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<KtModifierKeywordToken> modifiers = this.modifierKeywordTokens(element);
        if (modifiers.isEmpty()) {
            return false;
        }
        List sortedModifiers = AddRemoveModifierKt.sortModifiers(modifiers);
        return !Intrinsics.areEqual(modifiers, (Object)sortedModifiers) || this.modifiersBeforeAnnotations(element);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtModifierList element) {
        Object v2;
        PsiElement startElement;
        block5: {
            Object v0;
            List modifierElements;
            block4: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                modifierElements = SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)element))));
                Iterable $this$firstOrNull$iv = modifierElements;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it.getNode().getElementType() instanceof KtModifierKeywordToken)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            PsiElement psiElement = v0;
            if (psiElement == null) {
                return null;
            }
            startElement = psiElement;
            List $this$lastOrNull$iv = modifierElements;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it.getNode().getElementType() instanceof KtModifierKeywordToken)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        PsiElement psiElement = v2;
        if (psiElement == null) {
            return null;
        }
        PsiElement endElement = psiElement;
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)startElement), PsiUtilsKt.getEndOffset((PsiElement)endElement)).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)));
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtModifierList element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.modifiersBeforeAnnotations(element) ? KotlinBundle.message((String)"modifiers.should.follow.annotations", (Object[])new Object[0]) : KotlinBundle.message((String)"non.canonical.modifiers.order", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"sort.modifiers", (Object[])new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtModifierList element, @NotNull Project project, @Nullable Editor editor) {
        Iterable $this$partition$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement psiElement = element.getParent();
        KtModifierListOwner ktModifierListOwner = psiElement instanceof KtModifierListOwner ? (KtModifierListOwner)psiElement : null;
        if (ktModifierListOwner == null) {
            return;
        }
        KtModifierListOwner owner = ktModifierListOwner;
        List sortedModifiers = AddRemoveModifierKt.sortModifiers(this.modifierKeywordTokens(element));
        Iterable $this$filter$iv = sortedModifiers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
            boolean bl = false;
            if (!owner.hasModifier(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingModifiers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = existingModifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModifierKeywordToken it2 = (KtModifierKeywordToken)element$iv;
            boolean bl = false;
            owner.removeModifier(it2);
        }
        $this$forEach$iv = existingModifiers;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv;
            boolean bl = false;
            if (KtTokens.VISIBILITY_MODIFIERS.contains((IElementType)it) || KtTokens.MODALITY_MODIFIERS.contains((IElementType)it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair it = new Pair(first$iv, second$iv);
        boolean bl = false;
        $this$partition$iv = CollectionsKt.plus((Collection)((Collection)it.getSecond()), (Iterable)((Iterable)it.getFirst()));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModifierKeywordToken it2 = (KtModifierKeywordToken)element$iv;
            boolean bl2 = false;
            owner.addModifier(it2);
        }
    }

    private final List<KtModifierKeywordToken> modifierKeywordTokens(KtModifierList $this$modifierKeywordTokens) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$modifierKeywordTokens))), SortModifiersInspection::modifierKeywordTokens$lambda$7));
    }

    private final boolean modifiersBeforeAnnotations(KtModifierList $this$modifiersBeforeAnnotations) {
        List modifierElements = SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$modifiersBeforeAnnotations))));
        boolean modifiersBeforeAnnotations = false;
        boolean seenModifiers = false;
        for (PsiElement modifierElement : modifierElements) {
            if (modifierElement.getNode().getElementType() instanceof KtModifierKeywordToken) {
                seenModifiers = true;
                continue;
            }
            if (!seenModifiers || !(modifierElement instanceof KtAnnotationEntry) && !(modifierElement instanceof KtAnnotation)) continue;
            modifiersBeforeAnnotations = true;
        }
        return modifiersBeforeAnnotations;
    }

    private static final KtModifierKeywordToken modifierKeywordTokens$lambda$7(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType iElementType = it.getNode().getElementType();
        return iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
    }
}

