/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.testIntegration.AbstractKotlinTestFinder$findSourceElement$;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeShortNameIndex;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinPsiBasedTestFramework;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\f\u001a\u00020\tH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\f\u001a\u00020\tH\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/testIntegration/AbstractKotlinTestFinder;", "Lcom/intellij/testIntegration/TestFinder;", "<init>", "()V", "isResolvable", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "findSourceElement", "Lcom/intellij/psi/PsiElement;", "from", "isTest", "element", "getModule", "Lcom/intellij/openapi/module/Module;", "getSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "dependencies", "findClassesForTest", "", "findTestsForClass", "findClassName", "", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinTestFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinTestFinder.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/testIntegration/AbstractKotlinTestFinder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n477#2:176\n183#2,2:177\n1#3:179\n67#4:180\n1628#5,3:181\n2632#5,3:184\n1755#5,3:187\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinTestFinder.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/testIntegration/AbstractKotlinTestFinder\n*L\n40#1:176\n40#1:177,2\n50#1:180\n82#1:181,3\n91#1:184,3\n147#1:187,3\n*E\n"})
public abstract class AbstractKotlinTestFinder
implements TestFinder {
    protected abstract boolean isResolvable(@NotNull KtClassOrObject var1);

    @Nullable
    public PsiElement findSourceElement(@NotNull PsiElement from) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)from);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findSourceElement$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$firstOrNull$iv = sequence;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl = false;
                if (!(!it.isLocal())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        KtClassOrObject ktClassOrObject = v1;
        if (ktClassOrObject != null) {
            KtClassOrObject it = ktClassOrObject;
            boolean bl = false;
            return !this.isResolvable(it) ? null : (PsiElement)it;
        }
        PsiFile psiFile = from.getContainingFile();
        KtFile ktFile2 = ktClassOrObject = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktClassOrObject != null) {
            KtClassOrObject it = ktClassOrObject;
            boolean bl = false;
            return (PsiElement)it;
        }
        return (PsiElement)TestIntegrationUtils.findOuterClass((PsiElement)from);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isTest(@NotNull PsiElement element) {
        TestFramework testFramework2;
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject != null) {
            KtClassOrObject it = ktClassOrObject;
            boolean bl = false;
            testFramework2 = KotlinPsiBasedTestFramework.Companion.findTestFramework$default(KotlinPsiBasedTestFramework.Companion, (KtNamedDeclaration)it, false, 2, null);
        } else {
            testFramework2 = null;
        }
        return testFramework2 != null;
    }

    private final Module getModule(PsiElement element) {
        Module module;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex index2 = projectFileIndex;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile != null) {
            VirtualFile p0 = virtualFile;
            boolean $i$f$getModule$stub_for_inlining = false;
            boolean bl = false;
            module = index2.getModuleForFile(p0);
        } else {
            module = null;
        }
        return module;
    }

    private final GlobalSearchScope getSearchScope(PsiElement element, boolean dependencies) {
        Module module;
        block4: {
            block3: {
                module = this.getModule(element);
                if (module == null) break block3;
                Module it = module;
                boolean bl = false;
                GlobalSearchScope globalSearchScope = dependencies ? GlobalSearchScope.moduleWithDependenciesScope((Module)it) : GlobalSearchScope.moduleWithDependentsScope((Module)it);
                module = globalSearchScope;
                if (globalSearchScope != null) break block4;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)element.getProject());
            module = globalSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        }
        return module;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.findSourceElement(element);
        if (psiElement == null) {
            return SetsKt.emptySet();
        }
        PsiElement klass = psiElement;
        String klassName = this.findClassName(klass);
        GlobalSearchScope scope = this.getSearchScope(element, true);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Language[] languageArray = new Language[]{KotlinLanguage.INSTANCE};
        PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)project2).withoutLanguages(languageArray);
        Intrinsics.checkNotNullExpressionValue((Object)psiShortNamesCache, (String)"withoutLanguages(...)");
        PsiShortNamesCache cache2 = psiShortNamesCache;
        TestFrameworks frameworks = TestFrameworks.getInstance();
        ArrayList<Pair> classesWithWeights = new ArrayList<Pair>();
        for (Pair candidateNameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights((String)klassName)) {
            String name2 = (String)candidateNameWithWeight.first;
            for (PsiClass psiClass : cache2.getClassesByName(name2, scope)) {
                Intrinsics.checkNotNull((Object)psiClass);
                PsiClass eachClass = psiClass;
                if (eachClass.isAnnotationType() || frameworks.isTestClass(eachClass)) continue;
                if (eachClass instanceof KtLightClassForFacade) {
                    Iterable $this$mapTo$iv = ((KtLightClassForFacade)eachClass).getFiles();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        KtFile ktFile2 = (KtFile)item$iv;
                        Collection collection = classesWithWeights;
                        boolean bl = false;
                        collection.add(Pair.create((Object)it, (Object)candidateNameWithWeight.second));
                    }
                    continue;
                }
                if (!eachClass.isPhysical() && !(eachClass instanceof KtLightClass)) continue;
                classesWithWeights.add(Pair.create((Object)eachClass, (Object)candidateNameWithWeight.second));
            }
            Intrinsics.checkNotNull((Object)name2);
            KotlinClassShortNameIndex.Helper.processElements(name2, project2, scope, null, arg_0 -> AbstractKotlinTestFinder.findClassesForTest$lambda$8(arg_0 -> AbstractKotlinTestFinder.findClassesForTest$lambda$7(project2, classesWithWeights, candidateNameWithWeight, arg_0), arg_0));
            KotlinFileFacadeShortNameIndex.Helper.processElements(name2, project2, scope, null, arg_0 -> AbstractKotlinTestFinder.findClassesForTest$lambda$10(arg_0 -> AbstractKotlinTestFinder.findClassesForTest$lambda$9(classesWithWeights, candidateNameWithWeight, arg_0), arg_0));
        }
        List list2 = TestFinderHelper.getSortedElements((List)classesWithWeights, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSortedElements(...)");
        return list2;
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.findSourceElement(element);
        if (psiElement == null) {
            return SetsKt.emptySet();
        }
        PsiElement klass = psiElement;
        ArrayList classesWithProximities = new ArrayList();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor((Collection)classesWithProximities);
        String klassName = this.findClassName(klass);
        Pattern pattern2 = Pattern.compile(".*" + StringUtil.escapeToRegexp((String)klassName) + ".*", 2);
        GlobalSearchScope scope = this.getSearchScope(klass, false);
        TestFrameworks frameworks = TestFrameworks.getInstance();
        CommonProcessors.CollectProcessor<String> classNamesProcessor2 = new CommonProcessors.CollectProcessor<String>(pattern2){
            final /* synthetic */ Pattern $pattern;
            {
                this.$pattern = $pattern;
            }

            protected boolean accept(String t) {
                boolean bl;
                String string = t;
                if (string != null) {
                    String string2 = string;
                    Pattern pattern2 = this.$pattern;
                    String it = string2;
                    boolean bl2 = false;
                    bl = pattern2.matcher(it).matches();
                } else {
                    bl = false;
                }
                return bl;
            }
        };
        Project project = klass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project2);
        cache2.processAllClassNames((Processor)classNamesProcessor2);
        Language[] languageArray = new Language[]{KotlinLanguage.INSTANCE};
        cache2 = cache2.withoutLanguages(languageArray);
        for (String candidateName : classNamesProcessor2.getResults()) {
            for (PsiClass psiClass : cache2.getClassesByName(candidateName, scope)) {
                Intrinsics.checkNotNull((Object)psiClass);
                PsiClass candidateClass = psiClass;
                if (!candidateClass.isPhysical() && !(candidateClass instanceof KtLightClass) || !frameworks.isTestClass(candidateClass) && !frameworks.isPotentialTestClass(candidateClass)) continue;
                processor2.process((Object)Pair.create((Object)candidateClass, (Object)TestFinderHelper.calcTestNameProximity((String)klassName, (String)candidateName)));
            }
            Intrinsics.checkNotNull((Object)candidateName);
            KotlinClassShortNameIndex.Helper.processElements(candidateName, project2, scope, null, arg_0 -> AbstractKotlinTestFinder.findTestsForClass$lambda$13(arg_0 -> AbstractKotlinTestFinder.findTestsForClass$lambda$12(project2, processor2, klassName, candidateName, arg_0), arg_0));
        }
        List list2 = TestFinderHelper.getSortedElements((List)classesWithProximities, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSortedElements(...)");
        return list2;
    }

    private final String findClassName(PsiElement $this$findClassName) {
        PsiElement psiElement = $this$findClassName;
        String string = psiElement instanceof KtClassOrObject ? ((KtClassOrObject)$this$findClassName).getName() : (psiElement instanceof PsiClass ? ((PsiClass)$this$findClassName).getName() : (psiElement instanceof KtFile ? JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)((KtFile)$this$findClassName)).shortName().asString() : null));
        if (string == null) {
            throw new KotlinExceptionWithAttachments("non-anonymous psiElement " + $this$findClassName.getClass().getName() + " is expected").withPsiAttachment("element", $this$findClassName);
        }
        return string;
    }

    private static final boolean findClassesForTest$lambda$7(Project $project, ArrayList $classesWithWeights, Pair $candidateNameWithWeight, KtClassOrObject ktClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)ktClassOrObject, (String)"ktClassOrObject");
        if (!ktClassOrObject.isAnnotation()) {
            boolean notATest;
            block5: {
                ExtensionPointName extensionPointName = TestFramework.EXTENSION_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"EXTENSION_NAME");
                Iterable $this$none$iv = DumbService.Companion.getDumbAwareExtensions($project, extensionPointName);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    v1 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        TestFramework framework = (TestFramework)element$iv;
                        boolean bl = false;
                        if (!framework.isTestClass((PsiElement)ktClassOrObject)) continue;
                        v1 = false;
                        break block5;
                    }
                    v1 = notATest = true;
                }
            }
            if (notATest) {
                $classesWithWeights.add(Pair.create((Object)ktClassOrObject, (Object)$candidateNameWithWeight.second));
            }
        }
        return true;
    }

    private static final boolean findClassesForTest$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findClassesForTest$lambda$9(ArrayList $classesWithWeights, Pair $candidateNameWithWeight, KtFile ktFile2) {
        return $classesWithWeights.add(Pair.create((Object)ktFile2, (Object)$candidateNameWithWeight.second));
    }

    private static final boolean findClassesForTest$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findTestsForClass$lambda$12(Project $project, CommonProcessors.CollectProcessor $processor, String $klassName, String $candidateName, KtClassOrObject ktClassOrObject) {
        boolean isPotentialTest;
        block4: {
            Intrinsics.checkNotNullParameter((Object)ktClassOrObject, (String)"ktClassOrObject");
            ExtensionPointName extensionPointName = TestFramework.EXTENSION_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"EXTENSION_NAME");
            Iterable $this$any$iv = DumbService.Companion.getDumbAwareExtensions($project, extensionPointName);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestFramework framework = (TestFramework)element$iv;
                    boolean bl = false;
                    if (!(framework.isTestClass((PsiElement)ktClassOrObject) || framework.isPotentialTestClass((PsiElement)ktClassOrObject))) continue;
                    v1 = true;
                    break block4;
                }
                v1 = isPotentialTest = false;
            }
        }
        if (isPotentialTest) {
            $processor.process((Object)Pair.create((Object)ktClassOrObject, (Object)TestFinderHelper.calcTestNameProximity((String)$klassName, (String)$candidateName)));
        }
        return true;
    }

    private static final boolean findTestsForClass$lambda$13(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

