/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/util/InlineFunctionAnalyzer;", "", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "analyzeOnlyReifiedInlineFunctions", "", "<init>", "(Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Z)V", "analyzedElements", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlineFunctionsWithBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "analyze", "", "element", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "allFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "inlineObjectDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\ninlineAnalysisUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inlineAnalysisUtils.kt\norg/jetbrains/kotlin/idea/core/util/InlineFunctionAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1755#2,3:142\n1628#2,3:145\n1863#2,2:148\n*S KotlinDebug\n*F\n+ 1 inlineAnalysisUtils.kt\norg/jetbrains/kotlin/idea/core/util/InlineFunctionAnalyzer\n*L\n115#1:142,3\n121#1:145,3\n129#1:148,2\n*E\n"})
public final class InlineFunctionAnalyzer {
    @NotNull
    private final ResolutionFacade resolutionFacade;
    private final boolean analyzeOnlyReifiedInlineFunctions;
    @NotNull
    private final Set<KtElement> analyzedElements;
    @NotNull
    private final Set<KtDeclarationWithBody> inlineFunctionsWithBody;

    public InlineFunctionAnalyzer(@NotNull ResolutionFacade resolutionFacade, boolean analyzeOnlyReifiedInlineFunctions) {
        Intrinsics.checkNotNullParameter((Object)resolutionFacade, (String)"resolutionFacade");
        this.resolutionFacade = resolutionFacade;
        this.analyzeOnlyReifiedInlineFunctions = analyzeOnlyReifiedInlineFunctions;
        this.analyzedElements = new LinkedHashSet();
        this.inlineFunctionsWithBody = new LinkedHashSet();
    }

    public final void analyze(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        HashSet<KtDeclarationWithBody> nextInlineFunctions = new HashSet<KtDeclarationWithBody>();
        element.accept((PsiElementVisitor)new KtTreeVisitorVoid(this, project2, nextInlineFunctions){
            final /* synthetic */ InlineFunctionAnalyzer this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashSet<KtDeclarationWithBody> $nextInlineFunctions;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$nextInlineFunctions = $nextInlineFunctions;
            }

            public void visitExpression(KtExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitExpression(expression);
                BindingContext bindingContext = ResolutionFacade.analyze$default(InlineFunctionAnalyzer.access$getResolutionFacade$p(this.this$0), (KtElement)expression, null, 2, null);
                Call call2 = (Call)bindingContext.get((ReadOnlySlice)BindingContext.CALL, (Object)expression);
                if (call2 == null) {
                    return;
                }
                Call call3 = call2;
                ResolvedCall resolvedCall = (ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call3);
                this.checkResolveCall(resolvedCall);
            }

            public void visitDestructuringDeclaration(KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                BindingContext bindingContext = ResolutionFacade.analyze$default(InlineFunctionAnalyzer.access$getResolutionFacade$p(this.this$0), (KtElement)destructuringDeclaration, null, 2, null);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall = (ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
                    this.checkResolveCall(resolvedCall);
                }
            }

            public void visitForExpression(KtForExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitForExpression(expression);
                BindingContext bindingContext = ResolutionFacade.analyze$default(InlineFunctionAnalyzer.access$getResolutionFacade$p(this.this$0), (KtElement)expression, null, 2, null);
                this.checkResolveCall((ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall) {
                if (resolvedCall == null) {
                    return;
                }
                CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
                CallableDescriptor descriptor2 = callableDescriptor;
                if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                    return;
                }
                this.analyzeNextIfInline(descriptor2);
                if (descriptor2 instanceof PropertyDescriptor) {
                    for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor2).getAccessors()) {
                        Intrinsics.checkNotNull((Object)accessor);
                        this.analyzeNextIfInline((CallableDescriptor)accessor);
                    }
                }
            }

            private final void analyzeNextIfInline(CallableDescriptor descriptor2) {
                if (!InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)) || InlineFunctionAnalyzer.access$getAnalyzeOnlyReifiedInlineFunctions$p(this.this$0) && !InlineFunctionAnalyzer.access$hasReifiedTypeParameters(this.this$0, descriptor2)) {
                    return;
                }
                PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor2);
                if (declaration != null && declaration instanceof KtDeclarationWithBody && !InlineFunctionAnalyzer.access$getAnalyzedElements$p(this.this$0).contains(declaration)) {
                    this.$nextInlineFunctions.add((KtDeclarationWithBody)declaration);
                    return;
                }
            }
        });
        this.analyzedElements.add(element);
        if (!((Collection)nextInlineFunctions).isEmpty()) {
            Iterator<KtDeclarationWithBody> iterator2 = nextInlineFunctions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<KtDeclarationWithBody> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                KtDeclarationWithBody inlineFunction;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                if (inlineFunction.getBodyExpression() == null) continue;
                this.inlineFunctionsWithBody.add(inlineFunction);
                this.analyze((KtElement)inlineFunction);
            }
            this.analyzedElements.addAll((Collection<KtElement>)nextInlineFunctions);
        }
    }

    private final boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        boolean bl;
        block3: {
            List list2 = descriptor2.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!it.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtFile> allFiles() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.analyzedElements;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtElement ktElement = (KtElement)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getContainingKtFile());
        }
        return CollectionsKt.toList((Iterable)((Iterable)var2_2));
    }

    @NotNull
    public final Set<KtObjectDeclaration> inlineObjectDeclarations() {
        Set results2 = new LinkedHashSet();
        Iterable $this$forEach$iv = this.inlineFunctionsWithBody;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression body2;
            KtDeclarationWithBody inlineFunction = (KtDeclarationWithBody)element$iv;
            boolean bl = false;
            if (inlineFunction.getBodyExpression() == null) continue;
            body2.accept((PsiElementVisitor)new KtTreeVisitorVoid(results2){
                final /* synthetic */ Set<KtObjectDeclaration> $results;
                {
                    this.$results = $results;
                }

                public void visitObjectLiteralExpression(KtObjectLiteralExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    super.visitObjectLiteralExpression(expression);
                    KtObjectDeclaration ktObjectDeclaration = expression.getObjectDeclaration();
                    Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"getObjectDeclaration(...)");
                    this.$results.add(ktObjectDeclaration);
                }
            });
        }
        return results2;
    }

    public static final /* synthetic */ ResolutionFacade access$getResolutionFacade$p(InlineFunctionAnalyzer $this) {
        return $this.resolutionFacade;
    }

    public static final /* synthetic */ boolean access$getAnalyzeOnlyReifiedInlineFunctions$p(InlineFunctionAnalyzer $this) {
        return $this.analyzeOnlyReifiedInlineFunctions;
    }

    public static final /* synthetic */ boolean access$hasReifiedTypeParameters(InlineFunctionAnalyzer $this, CallableDescriptor descriptor2) {
        return $this.hasReifiedTypeParameters(descriptor2);
    }

    public static final /* synthetic */ Set access$getAnalyzedElements$p(InlineFunctionAnalyzer $this) {
        return $this.analyzedElements;
    }
}

