/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.CommonVariableAsmNameManglingUtils;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.platforms.StableModuleNameProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator;", "", "<init>", "()V", "getFunctionName", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getAccessorName", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isSetter", "", "getParameterName", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getInternalPostfix", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isPublishedApi", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "CallableName", "kotlin.jvm-debugger.base.util"})
public final class CallableNameCalculator {
    @NotNull
    public static final CallableNameCalculator INSTANCE = new CallableNameCalculator();

    private CallableNameCalculator() {
    }

    @Nullable
    public final CallableName getFunctionName(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        String jvmName = KotlinPsiHeuristics.findJvmName$default((KtAnnotated)function, null, 2, null);
        if (jvmName != null) {
            return new CallableName.Exact(jvmName);
        }
        String string = function.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        String prefix2 = CommonVariableAsmNameManglingUtils.sanitizeNameIfNeeded((String)name2, (LanguageVersionSettings)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function));
        if (function.hasModifier(KtTokens.INTERNAL_KEYWORD) && !function.isTopLevel() && !this.isPublishedApi((KtAnnotated)function)) {
            return new CallableName.Mangled(prefix2, this.getInternalPostfix((KtDeclaration)function));
        }
        return new CallableName.Mangled(prefix2, null);
    }

    @Nullable
    public final CallableName getAccessorName(@NotNull KtProperty property, boolean isSetter) {
        String prefix2;
        String jvmName;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string = jvmName = isSetter ? KotlinPsiHeuristics.findJvmSetterName((KtValVarKeywordOwner)property) : KotlinPsiHeuristics.findJvmGetterName((KtValVarKeywordOwner)property);
        if (jvmName != null) {
            return new CallableName.Exact(jvmName);
        }
        String string2 = property.getName();
        if (string2 == null) {
            return null;
        }
        String propertyName = string2;
        String string3 = prefix2 = isSetter ? JvmAbi.setterName((String)propertyName) : JvmAbi.getterName((String)propertyName);
        if (property.hasModifier(KtTokens.INTERNAL_KEYWORD) && !property.isTopLevel() && !this.isPublishedApi((KtAnnotated)property)) {
            return new CallableName.Mangled(prefix2, this.getInternalPostfix((KtDeclaration)property));
        }
        return new CallableName.Mangled(prefix2, null);
    }

    @Nullable
    public final String getParameterName(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        String string = parameter.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        if (Intrinsics.areEqual((Object)name2, (Object)"_")) {
            PsiElement parent = parameter.getParent();
            int index2 = parent instanceof KtParameterList ? ((KtParameterList)parent).getParameters().indexOf(parameter) : 0;
            return "$noName_" + index2;
        }
        return name2;
    }

    private final String getInternalPostfix(KtDeclaration declaration) {
        Module module = GenericPsiUtils.getModule((PsiElement)declaration);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String moduleName = StableModuleNameProvider.Companion.getInstance(project).getStableModuleName(module2);
        return "$" + NameUtils.sanitizeAsJavaIdentifier((String)moduleName);
    }

    private final boolean isPublishedApi(KtAnnotated declaration) {
        return KotlinPsiHeuristics.hasPublishedApiAnnotation(declaration);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "", "<init>", "()V", "matches", "", "name", "", "Exact", "Mangled", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Exact;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Mangled;", "kotlin.jvm-debugger.base.util"})
    public static abstract class CallableName {
        private CallableName() {
        }

        public abstract boolean matches(@NotNull String var1);

        public /* synthetic */ CallableName(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Exact;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "matches", "", "kotlin.jvm-debugger.base.util"})
        public static final class Exact
        extends CallableName {
            @NotNull
            private final String name;

            public Exact(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                super(null);
                this.name = name2;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            public boolean matches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)this.name);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName$Mangled;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/CallableNameCalculator$CallableName;", "prefix", "", "postfix", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "matches", "", "name", "kotlin.jvm-debugger.base.util"})
        public static final class Mangled
        extends CallableName {
            @NotNull
            private final String prefix;
            @Nullable
            private final String postfix;

            public Mangled(@NotNull String prefix2, @Nullable String postfix) {
                Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
                super(null);
                this.prefix = prefix2;
                this.postfix = postfix;
            }

            @NotNull
            public final String getPrefix() {
                return this.prefix;
            }

            @Override
            public boolean matches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return StringsKt.startsWith$default((String)name2, (String)this.prefix, (boolean)false, (int)2, null) && (this.postfix == null || StringsKt.endsWith$default((String)name2, (String)this.postfix, (boolean)false, (int)2, null));
            }
        }
    }
}

