/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaKotlinPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 >2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002>?B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J:\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\n\b\u0000\u0010\u001b\u0018\u0001*\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0082\b\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020*J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\fH\u0007J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\fH\u0007J\u0010\u00101\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\fH\u0007J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\fH\u0014J\u0010\u00105\u001a\u0002032\u0006\u00104\u001a\u00020\fH\u0014J\u0010\u00106\u001a\u0002032\u0006\u00104\u001a\u00020\fH\u0014J\u0010\u00107\u001a\u0002032\u0006\u00104\u001a\u00020\fH\u0014J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0016J\b\u0010;\u001a\u00020*H\u0016J\b\u0010<\u001a\u00020*H\u0002J\n\u0010=\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFieldBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinPropertyBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "breakpointType", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFieldBreakpoint$BreakpointType;", "isValid", "", "reload", "", "createRequestForPreparedClass", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "refType", "Lcom/sun/jdi/ReferenceType;", "computeBreakpointType", "property", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "createMethodBreakpoint", "accessor", "Lcom/sun/jdi/Method;", "findRequest", "T", "Lcom/sun/jdi/request/EventRequest;", "requestClass", "Ljava/lang/Class;", "requestor", "Lcom/intellij/debugger/requests/Requestor;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Ljava/lang/Class;Lcom/intellij/debugger/requests/Requestor;)Lcom/sun/jdi/request/EventRequest;", "evaluateCondition", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "matchesEvent", "getMethodsName", "", "", "getEventMessage", "setFieldName", "fieldName", "setWatchAccess", "value", "setWatchModification", "setWatchInitialization", "getDisabledIcon", "Ljavax/swing/Icon;", "isMuted", "getSetIcon", "getVerifiedIcon", "getVerifiedWarningsIcon", "getCategory", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/ui/breakpoints/FieldBreakpoint;", "getDisplayName", "getFieldName", "getEvaluationElement", "Companion", "BreakpointType", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinFieldBreakpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFieldBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFieldBreakpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,349:1\n188#1,7:356\n1#2:350\n774#3:351\n865#3,2:352\n1863#3,2:354\n*S KotlinDebug\n*F\n+ 1 KotlinFieldBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFieldBreakpoint\n*L\n169#1:356,7\n92#1:351\n92#1:352,2\n93#1:354,2\n*E\n"})
public final class KotlinFieldBreakpoint
extends BreakpointWithHighlighter<KotlinPropertyBreakpointProperties> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BreakpointType breakpointType;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<FieldBreakpoint> CATEGORY;

    public KotlinFieldBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        super(project, breakpoint2);
        this.breakpointType = BreakpointType.FIELD;
    }

    public boolean isValid() {
        return super.isValid() && this.getEvaluationElement() != null;
    }

    @RequiresBackgroundThread
    public void reload() {
        super.reload();
        KtCallableDeclaration ktCallableDeclaration = this.getEvaluationElement();
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration callable = ktCallableDeclaration;
        String string = callable.getName();
        if (string == null) {
            return;
        }
        String callableName = string;
        this.setFieldName(callableName);
        if (callable instanceof KtProperty && ((KtProperty)callable).isTopLevel()) {
            KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)this.getProperties();
            KtFile ktFile2 = ((KtProperty)callable).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            kotlinPropertyBreakpointProperties.setMyClassName(JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)ktFile2).getFileClassFqName().asString());
        } else {
            FqName fqName2;
            KtClassOrObject ktClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)callable), KtClassOrObject.class);
            if (ktClass != null && (fqName2 = ktClass.getFqName()) != null) {
                ((KotlinPropertyBreakpointProperties)this.getProperties()).setMyClassName(fqName2.asString());
            }
        }
        this.setInstanceFiltersEnabled(false);
    }

    /*
     * WARNING - void declaration
     */
    protected void createRequestForPreparedClass(@Nullable DebugProcessImpl debugProcess, @Nullable ReferenceType refType) {
        Object object;
        block27: {
            block26: {
                void p0;
                if (debugProcess == null || refType == null) {
                    return;
                }
                KotlinFieldBreakpoint kotlinFieldBreakpoint = this;
                object = this.getEvaluationElement();
                if (object == null) break block26;
                KtCallableDeclaration ktCallableDeclaration = object;
                KotlinFieldBreakpoint kotlinFieldBreakpoint2 = kotlinFieldBreakpoint;
                boolean $i$f$createRequestForPreparedClass$stub_for_inlining = false;
                boolean bl = false;
                BreakpointType breakpointType = this.computeBreakpointType((KtCallableDeclaration)p0);
                kotlinFieldBreakpoint = kotlinFieldBreakpoint2;
                object = breakpointType;
                if (breakpointType != null) break block27;
            }
            return;
        }
        kotlinFieldBreakpoint.breakpointType = object;
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"getVirtualMachineProxy(...)");
        VirtualMachineProxyImpl vm = virtualMachineProxyImpl;
        try {
            SourcePosition sourcePosition;
            if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchInitialization() && (sourcePosition = this.getSourcePosition()) != null) {
                void $this$forEach$iv;
                Iterator $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                List list2 = debugProcess.getPositionManager().locationsOfLine(refType, sourcePosition);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"locationsOfLine(...)");
                Iterable iterable = list2;
                boolean $i$f$filter = false;
                void $i$f$createRequestForPreparedClass$stub_for_inlining = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    Location it = (Location)element$iv$iv;
                    boolean bl = false;
                    if (!(it.method().isConstructor() || it.method().isStaticInitializer())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Location it = (Location)element$iv;
                    boolean bl = false;
                    BreakpointRequest request = debugProcess.getRequestsManager().createBreakpointRequest((FilteredRequestor)this, it);
                    debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Breakpoint request added");
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.breakpointType.ordinal()]) {
                case 1: {
                    Field field2 = refType.fieldByName(this.getFieldName());
                    if (field2 != null) {
                        RequestManagerImpl manager = debugProcess.getRequestsManager();
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchModification() && vm.canWatchFieldModification()) {
                            ModificationWatchpointRequest request = manager.createModificationWatchpointRequest((FilteredRequestor)this, field2);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Modification request added");
                            }
                        }
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchAccess() && vm.canWatchFieldAccess()) {
                            AccessWatchpointRequest request = manager.createAccessWatchpointRequest((FilteredRequestor)this, field2);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Field access request added (field = " + field2.name() + "; refType = " + refType.name() + ")");
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    String fieldName = this.getFieldName();
                    if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchAccess()) {
                        List<Method> list3 = refType.methodsByName(JvmAbi.getterName((String)fieldName));
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"methodsByName(...)");
                        Method getter = (Method)CollectionsKt.firstOrNull(list3);
                        if (getter != null) {
                            this.createMethodBreakpoint(debugProcess, refType, getter);
                        }
                    }
                    if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchModification()) {
                        List<Method> list4 = refType.methodsByName(JvmAbi.setterName((String)fieldName));
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"methodsByName(...)");
                        Method setter = (Method)CollectionsKt.firstOrNull(list4);
                        if (setter != null) {
                            this.createMethodBreakpoint(debugProcess, refType, setter);
                        }
                    }
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Exception ex) {
            LOG.debug((Throwable)ex);
        }
    }

    private final BreakpointType computeBreakpointType(KtCallableDeclaration property) {
        return (BreakpointType)((Object)AnalyseUtilsKt.runSmartAnalyze((KtElement)property, arg_0 -> KotlinFieldBreakpoint.computeBreakpointType$lambda$2(property, arg_0)));
    }

    private final void createMethodBreakpoint(DebugProcessImpl debugProcess, ReferenceType refType, Method accessor) {
        RequestManagerImpl manager = debugProcess.getRequestsManager();
        Location line = (Location)CollectionsKt.firstOrNull(SafeUtilKt.safeAllLineLocations(accessor));
        if (line != null) {
            BreakpointRequest request = manager.createBreakpointRequest((FilteredRequestor)this, line);
            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Breakpoint request added");
            }
        } else {
            EventRequest eventRequest;
            block8: {
                KotlinFieldBreakpoint kotlinFieldBreakpoint = this;
                Class<MethodEntryRequest> requestClass$iv = MethodEntryRequest.class;
                boolean $i$f$findRequest = false;
                Set requests$iv = debugProcess.getRequestsManager().findRequests((Requestor)this);
                for (EventRequest eventRequest$iv : requests$iv) {
                    if (!Intrinsics.areEqual(eventRequest$iv.getClass(), requestClass$iv)) continue;
                    EventRequest eventRequest2 = eventRequest$iv;
                    if (eventRequest2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.request.MethodEntryRequest");
                    }
                    eventRequest = (MethodEntryRequest)eventRequest2;
                    break block8;
                }
                eventRequest = null;
            }
            MethodEntryRequest entryRequest = (MethodEntryRequest)eventRequest;
            if (entryRequest == null) {
                MethodEntryRequest methodEntryRequest = manager.createMethodEntryRequest((FilteredRequestor)this);
                Intrinsics.checkNotNull((Object)methodEntryRequest);
                entryRequest = methodEntryRequest;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Method entry request added (method = " + accessor.name() + "; refType = " + refType.name() + ")");
                }
            } else {
                entryRequest.disable();
            }
            entryRequest.addClassFilter(refType);
            manager.enableRequest((EventRequest)entryRequest);
        }
    }

    private final /* synthetic */ <T extends EventRequest> T findRequest(DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        boolean $i$f$findRequest = false;
        Set requests = debugProcess.getRequestsManager().findRequests(requestor);
        for (EventRequest eventRequest : requests) {
            if (!Intrinsics.areEqual(eventRequest.getClass(), requestClass)) continue;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)eventRequest;
        }
        return null;
    }

    public boolean evaluateCondition(@NotNull EvaluationContextImpl context2, @NotNull LocatableEvent event) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.breakpointType == BreakpointType.METHOD && !this.matchesEvent(event)) {
            return false;
        }
        return super.evaluateCondition(context2, event);
    }

    private final boolean matchesEvent(LocatableEvent event) {
        Location location = event.location();
        Method method = location != null ? location.method() : null;
        return method != null && this.getMethodsName().contains(method.name());
    }

    private final List<String> getMethodsName() {
        String fieldName = this.getFieldName();
        Object[] objectArray = new String[]{JvmAbi.getterName((String)fieldName), JvmAbi.setterName((String)fieldName)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getEventMessage(@NotNull LocatableEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Location location = event.location();
        Intrinsics.checkNotNull((Object)location);
        Location location2 = location;
        String locationQName = location2.declaringType().name() + "." + location2.method().name();
        try {
            string = location2.sourceName();
        }
        catch (AbsentInformationException e) {
            string = this.getFileName();
        }
        catch (InternalError e) {
            string = this.getFileName();
        }
        String locationFileName = string;
        int locationLine = location2.lineNumber();
        LocatableEvent locatableEvent = event;
        if (locatableEvent instanceof ModificationWatchpointEvent) {
            Field field2 = ((ModificationWatchpointEvent)event).field();
            Object[] objectArray = new Object[]{field2.declaringType().name(), field2.name(), locationQName, locationFileName, locationLine};
            String string2 = JavaDebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        if (locatableEvent instanceof AccessWatchpointEvent) {
            Field field3 = ((AccessWatchpointEvent)event).field();
            Object[] objectArray = new Object[]{field3.declaringType().name(), field3.name(), locationQName, locationFileName, locationLine};
            String string3 = JavaDebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            return string3;
        }
        if (locatableEvent instanceof MethodEntryEvent) {
            Method method = ((MethodEntryEvent)event).method();
            Object[] objectArray = new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine};
            String string4 = JavaDebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            return string4;
        }
        if (locatableEvent instanceof MethodExitEvent) {
            Method method = ((MethodExitEvent)event).method();
            Object[] objectArray = new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine};
            String string5 = JavaDebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            return string5;
        }
        Object[] objectArray = new Object[]{locationQName, locationFileName, locationLine};
        String string6 = JavaDebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        return string6;
    }

    public final void setFieldName(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setMyFieldName(fieldName);
    }

    @TestOnly
    public final void setWatchAccess(boolean value) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWatchAccess(value);
    }

    @TestOnly
    public final void setWatchModification(boolean value) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWatchModification(value);
    }

    @TestOnly
    public final void setWatchInitialization(boolean value) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWatchInitialization(value);
    }

    @NotNull
    protected Icon getDisabledIcon(boolean isMuted) {
        Icon icon2;
        Breakpoint master = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager().findMasterBreakpoint((Breakpoint)this);
        if (isMuted && master == null) {
            Icon icon3 = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Db_muted_disabled_field_breakpoint");
        } else if (isMuted && master != null) {
            Icon icon4 = AllIcons.Debugger.Db_muted_dep_field_breakpoint;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Db_muted_dep_field_breakpoint");
        } else if (master != null) {
            Icon icon5 = AllIcons.Debugger.Db_dep_field_breakpoint;
            icon2 = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Db_dep_field_breakpoint");
        } else {
            Icon icon6 = AllIcons.Debugger.Db_disabled_field_breakpoint;
            icon2 = icon6;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Db_disabled_field_breakpoint");
        }
        return icon2;
    }

    @NotNull
    protected Icon getSetIcon(boolean isMuted) {
        Icon icon2;
        if (isMuted) {
            Icon icon3 = AllIcons.Debugger.Db_muted_field_breakpoint;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Db_muted_field_breakpoint");
        } else {
            Icon icon4 = AllIcons.Debugger.Db_field_breakpoint;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Db_field_breakpoint");
        }
        return icon2;
    }

    @NotNull
    protected Icon getVerifiedIcon(boolean isMuted) {
        Icon icon2;
        if (isMuted) {
            Icon icon3 = AllIcons.Debugger.Db_muted_field_breakpoint;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Db_muted_field_breakpoint");
        } else {
            Icon icon4 = AllIcons.Debugger.Db_verified_field_breakpoint;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Db_verified_field_breakpoint");
        }
        return icon2;
    }

    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        Icon icon2 = AllIcons.Debugger.Db_exception_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_exception_breakpoint");
        return icon2;
    }

    @NotNull
    public Key<FieldBreakpoint> getCategory() {
        return CATEGORY;
    }

    @NotNull
    public String getDisplayName() {
        if (!this.isValid()) {
            String string = JavaDebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String className = this.getClassName();
        CharSequence charSequence = className;
        return !(charSequence == null || charSequence.length() == 0) ? className + "." + this.getFieldName() : this.getFieldName();
    }

    private final String getFieldName() {
        return (String)ActionsKt.runReadAction(() -> KotlinFieldBreakpoint.getFieldName$lambda$3(this));
    }

    @Nullable
    public KtCallableDeclaration getEvaluationElement() {
        KtValVarKeywordOwner callable = (KtValVarKeywordOwner)PositionUtil.getPsiElementAt((Project)this.getProject(), KtValVarKeywordOwner.class, (SourcePosition)this.getSourcePosition());
        return callable instanceof KtProperty ? (KtCallableDeclaration)callable : (callable instanceof KtParameter ? (KtCallableDeclaration)callable : null);
    }

    private static final BreakpointType computeBreakpointType$lambda$2(KtCallableDeclaration $property, KaSession $this$runSmartAnalyze) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$runSmartAnalyze, (String)"$this$runSmartAnalyze");
        KaDeclarationSymbol symbol = $this$runSmartAnalyze.getSymbol((KtDeclaration)$property);
        if (symbol instanceof KaValueParameterSymbol) {
            KaKotlinPropertySymbol kaKotlinPropertySymbol = ((KaValueParameterSymbol)symbol).getGeneratedPrimaryConstructorProperty();
            bl = kaKotlinPropertySymbol != null ? kaKotlinPropertySymbol.getHasBackingField() : false;
        } else {
            bl = symbol instanceof KaKotlinPropertySymbol ? ((KaKotlinPropertySymbol)symbol).getHasBackingField() : false;
        }
        boolean hasBackingField = bl;
        return hasBackingField ? BreakpointType.FIELD : BreakpointType.METHOD;
    }

    private static final String getFieldName$lambda$3(KotlinFieldBreakpoint this$0) {
        Object object = this$0.getEvaluationElement();
        if (object == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        return object;
    }

    static {
        Logger logger = Logger.getInstance(KotlinFieldBreakpoint.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = BreakpointCategory.lookup((String)"field_breakpoints");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"lookup(...)");
        CATEGORY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFieldBreakpoint$BreakpointType;", "", "<init>", "(Ljava/lang/String;I)V", "FIELD", "METHOD", "kotlin.jvm-debugger.core"})
    private static final class BreakpointType
    extends Enum<BreakpointType> {
        public static final /* enum */ BreakpointType FIELD = new BreakpointType();
        public static final /* enum */ BreakpointType METHOD = new BreakpointType();
        private static final /* synthetic */ BreakpointType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BreakpointType[] values() {
            return (BreakpointType[])$VALUES.clone();
        }

        public static BreakpointType valueOf(String value) {
            return Enum.valueOf(BreakpointType.class, value);
        }

        @NotNull
        public static EnumEntries<BreakpointType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = breakpointTypeArray = new BreakpointType[]{BreakpointType.FIELD, BreakpointType.METHOD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFieldBreakpoint$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CATEGORY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/ui/breakpoints/FieldBreakpoint;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BreakpointType.values().length];
            try {
                nArray[BreakpointType.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointType.METHOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

