/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StepIntoMethodBreakpoint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacility;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacilityKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility;", "", "<init>", "()V", "installResumeBreakpointInCurrentMethod", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "installResumeBreakpointInCallerMethod", "installCoroutineResumedBreakpoint", "context", "resumedLocation", "Lcom/sun/jdi/Location;", "nextLocationAfterResume", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nCoroutineBreakpointFacility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n24#2:103\n24#2:104\n24#2:105\n24#2:106\n*S KotlinDebug\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n*L\n29#1:103\n36#1:104\n49#1:105\n86#1:106\n*E\n"})
public final class CoroutineBreakpointFacility {
    @NotNull
    public static final CoroutineBreakpointFacility INSTANCE = new CoroutineBreakpointFacility();

    private CoroutineBreakpointFacility() {
    }

    public final boolean installResumeBreakpointInCurrentMethod(@NotNull SuspendContextImpl suspendContext) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Location location2 = suspendContext.getLocation();
        if (location2 == null) {
            return false;
        }
        Location currentLocation = location2;
        List<Location> methodLineLocations = currentLocation.method().allLineLocations();
        if (methodLineLocations.size() > 2 && Intrinsics.areEqual((Object)methodLineLocations.get(methodLineLocations.size() - 2), (Object)currentLocation)) {
            StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
            location = stackFrameInterceptor != null ? stackFrameInterceptor.callerLocation(suspendContext) : null;
        } else {
            location = currentLocation;
        }
        if (location == null) {
            return false;
        }
        Location resumeLocation = location;
        Location nextLocationAfterResume = DebuggerUtil.getLocationOfNextInstructionAfterResume(resumeLocation);
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Trying to set a resume breakpoint in the current method: resumeLocation: " + resumeLocation + ", method: " + SafeUtilKt.safeMethod(resumeLocation) + ", nextLocationAfterResumeIndex = " + nextLocationAfterResume);
        return this.installCoroutineResumedBreakpoint(suspendContext, resumeLocation, nextLocationAfterResume);
    }

    public final boolean installResumeBreakpointInCallerMethod(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Object object = StackFrameInterceptor.Companion.getInstance();
        if (object == null || (object = object.callerLocation(suspendContext)) == null) {
            return false;
        }
        Object resumeLocation = object;
        Location nextLocationAfterResume = DebuggerUtil.getLocationOfNextInstructionAfterResume((Location)resumeLocation);
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Trying to set a resume breakpoint in the caller method: resumeLocation: " + (Location)resumeLocation + ", method: " + SafeUtilKt.safeMethod((Location)resumeLocation) + ", nextLocationAfterResumeIndex = " + nextLocationAfterResume);
        return this.installCoroutineResumedBreakpoint(suspendContext, (Location)resumeLocation, nextLocationAfterResume);
    }

    private final boolean installCoroutineResumedBreakpoint(SuspendContextImpl context2, Location resumedLocation, Location nextLocationAfterResume) {
        DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        DebugProcessImpl debugProcess = debugProcessImpl;
        debugProcess.cancelRunToCursorBreakpoint();
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        boolean useCoroutineIdFiltering = Registry.Companion.is("debugger.filter.breakpoints.by.coroutine.id");
        Method method = SafeUtilKt.safeMethod(resumedLocation);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        if (debugProcess.getRequestsManager().getFilterThread() == null) {
            CoroutineBreakpointFacility $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Coroutine filter should be calculated and set before breakpoint request created. In other case, this breakpoint may be hit while intermediate evaluations on other threads before the filter will be set.");
        }
        String $i$f$thisLogger = method2.declaringType().name();
        String string = method2.name();
        String string2 = method2.signature();
        StepIntoMethodBreakpoint breakpoint2 = new StepIntoMethodBreakpoint(project2, context2, debugProcess, nextLocationAfterResume, $i$f$thisLogger, string, string2){
            final /* synthetic */ SuspendContextImpl $context;
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ Location $nextLocationAfterResume;
            {
                this.$context = $context;
                this.$debugProcess = $debugProcess;
                this.$nextLocationAfterResume = $nextLocationAfterResume;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $project);
            }

            public boolean isRestoreBreakpoints() {
                return false;
            }

            protected boolean stopOnlyInBaseClass() {
                return true;
            }

            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                installCoroutineResumedBreakpoint.breakpoint.1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(installCoroutineResumedBreakpoint.breakpoint.1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Hit the resume breakpoint at " + this.$context.getLocation());
                boolean result2 = super.processLocatableEvent(action, event);
                if (result2) {
                    this.$debugProcess.getRequestsManager().deleteRequest((Requestor)this);
                }
                if (!result2) {
                    return false;
                }
                SuspendContextImpl suspendContextImpl = action.getSuspendContext();
                if (suspendContextImpl == null) {
                    return true;
                }
                SuspendContextImpl suspendContextImpl2 = suspendContextImpl;
                return this.scheduleStepOverCommandForSuspendSwitch(suspendContextImpl2, this.$nextLocationAfterResume);
            }

            private final boolean scheduleStepOverCommandForSuspendSwitch(SuspendContextImpl it, Location nextLocationAfterResume) {
                DebuggerSteppingHelper.INSTANCE.createStepOverCommandForSuspendSwitch(it, nextLocationAfterResume).prepareSteppingRequestsAndHints(it);
                return false;
            }
        };
        breakpoint2.setSuspendPolicy(context2.getSuspendPolicyFromRequestors());
        if (!useCoroutineIdFiltering) {
            CoroutineBreakpointFacilityKt.access$applyEmptyThreadFilter(debugProcess);
        }
        breakpoint2.createRequest(debugProcess);
        debugProcess.setSteppingBreakpoint((SteppingBreakpoint)breakpoint2);
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Resume breakpoint for " + method2 + " in context " + context2);
        return true;
    }
}

