/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.SkipCoroutineStackFrameProxyImpl;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a&\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"safeSkipCoroutineStackFrameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "frameProxy", "safeCoroutineStackFrameProxy", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineStackFrameProxysKt {
    @NotNull
    public static final StackFrameProxyImpl safeSkipCoroutineStackFrameProxy(@NotNull StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        ThreadReferenceProxyImpl threadReferenceProxyImpl = SafeUtilKt.safeThreadProxy(frameProxy);
        if (threadReferenceProxyImpl == null) {
            return frameProxy;
        }
        ThreadReferenceProxyImpl threadProxy = threadReferenceProxyImpl;
        StackFrame stackFrame = SafeUtilKt.safeStackFrame((StackFrameProxy)frameProxy);
        if (stackFrame == null) {
            return frameProxy;
        }
        StackFrame stackFrame2 = stackFrame;
        return new SkipCoroutineStackFrameProxyImpl(threadProxy, stackFrame2, frameProxy.getIndexFromBottom());
    }

    @NotNull
    public static final StackFrameProxyImpl safeCoroutineStackFrameProxy(@Nullable Location location, @NotNull List<? extends JavaValue> spilledVariables, @NotNull StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter(spilledVariables, (String)"spilledVariables");
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        ThreadReferenceProxyImpl threadReferenceProxyImpl = SafeUtilKt.safeThreadProxy(frameProxy);
        if (threadReferenceProxyImpl == null) {
            return frameProxy;
        }
        ThreadReferenceProxyImpl threadProxy = threadReferenceProxyImpl;
        StackFrame stackFrame = SafeUtilKt.safeStackFrame((StackFrameProxy)frameProxy);
        if (stackFrame == null) {
            return frameProxy;
        }
        StackFrame stackFrame2 = stackFrame;
        return new CoroutineStackFrameProxyImpl(location, spilledVariables, threadProxy, stackFrame2, frameProxy.getIndexFromBottom());
    }
}

