/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.StreamCallChecker;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/PackageBasedCallChecker;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/StreamCallChecker;", "supportedPackage", "", "<init>", "(Ljava/lang/String;)V", "isIntermediateCall", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isTerminationCall", "checkResultSupported", "shouldSupportResult", "checkReceiverSupported", "isSupportedType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.jvm-debugger.sequence.k1"})
public final class PackageBasedCallChecker
implements StreamCallChecker {
    @NotNull
    private final String supportedPackage;

    public PackageBasedCallChecker(@NotNull String supportedPackage) {
        Intrinsics.checkNotNullParameter((Object)supportedPackage, (String)"supportedPackage");
        this.supportedPackage = supportedPackage;
    }

    @Override
    public boolean isIntermediateCall(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.checkReceiverSupported(expression) && this.checkResultSupported(expression, true);
    }

    @Override
    public boolean isTerminationCall(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.checkReceiverSupported(expression) && this.checkResultSupported(expression, false);
    }

    private final boolean checkResultSupported(KtCallExpression expression, boolean shouldSupportResult) {
        KotlinType resultType = UtilsKt.resolveType$default((KtExpression)expression, null, 1, null);
        return resultType != null && shouldSupportResult == this.isSupportedType(resultType);
    }

    private final boolean checkReceiverSupported(KtCallExpression expression) {
        KotlinType receiverType = UtilsKt.receiverType(expression);
        return receiverType != null && this.isSupportedType(receiverType);
    }

    private final boolean isSupportedType(KotlinType type2) {
        String typeName = KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type2);
        String string = StringUtil.getPackageName((String)typeName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        return StringsKt.startsWith$default((String)string, (String)this.supportedPackage, (boolean)false, (int)2, null);
    }
}

