/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.ConvertObjectToDataObjectInspectionKt;
import org.jetbrains.kotlin.idea.inspections.VirtualFunction;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeaturesFUSCollector;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertToDataObjectQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/idea/inspections/VirtualFunction;", "getFunction", "(Lorg/jetbrains/kotlin/idea/inspections/VirtualFunction;)Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertObjectToDataObjectInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertObjectToDataObjectInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConvertToDataObjectQuickFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n19#2:235\n1863#3,2:236\n*S KotlinDebug\n*F\n+ 1 ConvertObjectToDataObjectInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConvertToDataObjectQuickFix\n*L\n139#1:235\n149#1:236,2\n*E\n"})
final class ConvertToDataObjectQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.to.data.object", (Object[])new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement $this$asSafely$iv = descriptor2.getPsiElement().getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof KtObjectDeclaration)) {
            psiElement = null;
        }
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)psiElement;
        if (ktObjectDeclaration == null) {
            return;
        }
        KtObjectDeclaration ktObject = ktObjectDeclaration;
        List functions = (List)ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"analyzing.members", (Object[])new Object[0]), () -> ConvertToDataObjectQuickFix.applyFix$lambda$0(this, ktObject));
        KotlinLanguageFeaturesFUSCollector.INSTANCE.getDataObjectCollector().logQuickFixApplied(ktObject.getContainingFile());
        ActionsKt.runWriteAction(() -> ConvertToDataObjectQuickFix.applyFix$lambda$2(functions, ktObject));
    }

    private final KtNamedFunction getFunction(VirtualFunction $this$function) {
        KtNamedFunction ktNamedFunction;
        VirtualFunction virtualFunction = $this$function;
        if (virtualFunction instanceof VirtualFunction.Function) {
            ktNamedFunction = ((VirtualFunction.Function)$this$function).getFunction();
        } else if (virtualFunction instanceof VirtualFunction.NonTrivialSuper) {
            ktNamedFunction = null;
        } else if (virtualFunction instanceof VirtualFunction.TrivialSuper) {
            ktNamedFunction = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ktNamedFunction;
    }

    private static final List applyFix$lambda$0(ConvertToDataObjectQuickFix this$0, KtObjectDeclaration $ktObject) {
        Object[] objectArray = new KtNamedFunction[]{this$0.getFunction(ConvertObjectToDataObjectInspectionKt.access$findToString($ktObject)), this$0.getFunction(ConvertObjectToDataObjectInspectionKt.access$findEquals($ktObject)), this$0.getFunction(ConvertObjectToDataObjectInspectionKt.access$findHashCode($ktObject))};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final Unit applyFix$lambda$2(List $functions, KtObjectDeclaration $ktObject) {
        Intrinsics.checkNotNull((Object)$functions);
        Iterable $this$forEach$iv = $functions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNamedFunction it = (KtNamedFunction)element$iv;
            boolean bl = false;
            it.delete();
        }
        Object object = $ktObject.getBody();
        boolean bl = object != null && (object = object.getDeclarations()) != null ? object.isEmpty() : false;
        if (bl) {
            KtClassBody ktClassBody = $ktObject.getBody();
            if (ktClassBody != null) {
                ktClassBody.delete();
            }
        }
        $ktObject.addModifier(KtTokens.DATA_KEYWORD);
        return Unit.INSTANCE;
    }
}

