/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AssociateFunction;
import org.jetbrains.kotlin.idea.inspections.ReplaceAssociateFunctionInspectionKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u0018\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceAssociateFunctionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "function", "Lorg/jetbrains/kotlin/idea/inspections/AssociateFunction;", "hasDestination", "", "<init>", "(Lorg/jetbrains/kotlin/idea/inspections/AssociateFunction;Z)V", "functionName", "", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "appendLambda", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "body", "appendValueArgumentList", "valueArgumentList", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReplaceAssociateFunctionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceAssociateFunctionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplaceAssociateFunctionFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n150#2:221\n1#3:222\n1872#4,3:223\n*S KotlinDebug\n*F\n+ 1 ReplaceAssociateFunctionInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplaceAssociateFunctionFix\n*L\n105#1:221\n170#1:223,3\n*E\n"})
public final class ReplaceAssociateFunctionFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssociateFunction function;
    private final boolean hasDestination;
    @NotNull
    private final String functionName;

    public ReplaceAssociateFunctionFix(@NotNull AssociateFunction function, boolean hasDestination) {
        Intrinsics.checkNotNullParameter((Object)((Object)function), (String)"function");
        this.function = function;
        this.hasDestination = hasDestination;
        this.functionName = this.function.name(this.hasDestination);
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.functionName};
        return KotlinBundle.message((String)"replace.with.0", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiElement $this$getStrictParentOfType$iv = psiElement;
        boolean $i$f$getStrictParentOfType = false;
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDotQualifiedExpression.class, (boolean)true);
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression dotQualifiedExpression = ktDotQualifiedExpression;
        KtExpression receiverExpression = dotQualifiedExpression.getReceiverExpression();
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)dotQualifiedExpression);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtLambdaExpression ktLambdaExpression = ReplaceAssociateFunctionInspectionKt.access$lambda(callExpression);
        if (ktLambdaExpression == null) {
            return;
        }
        KtLambdaExpression lambda2 = ktLambdaExpression;
        KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
        KtExpression ktExpression = ReplaceAssociateFunctionInspectionKt.access$lastStatement(ktFunctionLiteral);
        if (ktExpression == null) {
            return;
        }
        KtExpression lastStatement = ktExpression;
        Pair pair = ReplaceAssociateFunctionInspectionKt.pair$default(lastStatement, null, 1, null);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        KtExpression keySelector = (KtExpression)pair2.component1();
        KtExpression valueTransform = (KtExpression)pair2.component2();
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        if (this.function == AssociateFunction.ASSOCIATE_BY_KEY_AND_VALUE) {
            KtValueArgument ktValueArgument;
            if (this.hasDestination) {
                List list2 = callExpression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
                ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list2);
                if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                    return;
                }
            } else {
                ktValueArgument = null;
            }
            KtValueArgument destination = ktValueArgument;
            KtExpression newExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> ReplaceAssociateFunctionFix.applyFix$lambda$0(receiverExpression, this, (KtExpression)destination, lambda2, keySelector, valueTransform, arg_0), (int)1, null);
            v9 = dotQualifiedExpression.replace((PsiElement)newExpression);
        } else {
            lastStatement.replace((PsiElement)(this.function == AssociateFunction.ASSOCIATE_WITH ? valueTransform : keySelector));
            KtExpression newExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> ReplaceAssociateFunctionFix.applyFix$lambda$1(receiverExpression, this, callExpression, lambda2, arg_0), (int)1, null);
            v9 = dotQualifiedExpression.replace((PsiElement)newExpression);
        }
    }

    private final void appendLambda(BuilderByPattern<KtExpression> $this$appendLambda, KtLambdaExpression lambda2, KtExpression body2) {
        $this$appendLambda.appendFixedText("{");
        List list2 = lambda2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull((List)list2);
        if (ktParameter != null && (ktParameter = ktParameter.getNameAsName()) != null) {
            KtParameter ktParameter2;
            KtParameter it = ktParameter2 = ktParameter;
            boolean bl = false;
            $this$appendLambda.appendName((Name)it);
            $this$appendLambda.appendFixedText("->");
        }
        if (body2 != null) {
            v2 = $this$appendLambda.appendExpression(body2);
        } else {
            KtBlockExpression ktBlockExpression = lambda2.getBodyExpression();
            if (ktBlockExpression != null && (ktBlockExpression = PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)ktBlockExpression))) != null) {
                KtBlockExpression p0 = ktBlockExpression;
                boolean $i$f$appendLambda$stub_for_inlining = false;
                boolean bl = false;
                v2 = $this$appendLambda.appendChildRange((PsiChildRange)p0);
            } else {
                v2 = null;
            }
        }
        $this$appendLambda.appendFixedText("}");
    }

    static /* synthetic */ void appendLambda$default(ReplaceAssociateFunctionFix replaceAssociateFunctionFix, BuilderByPattern builderByPattern, KtLambdaExpression ktLambdaExpression, KtExpression ktExpression, int n, Object object) {
        if ((n & 2) != 0) {
            ktExpression = null;
        }
        replaceAssociateFunctionFix.appendLambda((BuilderByPattern<KtExpression>)builderByPattern, ktLambdaExpression, ktExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendValueArgumentList(BuilderByPattern<KtExpression> $this$appendValueArgumentList, KtValueArgumentList valueArgumentList) {
        $this$appendValueArgumentList.appendFixedText("(");
        List list2 = valueArgumentList.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getArguments(...)");
        Iterable $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void argument2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtValueArgument ktValueArgument = (KtValueArgument)item$iv;
            int index2 = n;
            boolean bl = false;
            if (index2 > 0) {
                $this$appendValueArgumentList.appendFixedText(",");
            }
            $this$appendValueArgumentList.appendExpression(argument2.getArgumentExpression());
        }
        $this$appendValueArgumentList.appendFixedText(")");
    }

    private static final Unit applyFix$lambda$0(KtExpression $receiverExpression, ReplaceAssociateFunctionFix this$0, KtExpression $destination, KtLambdaExpression $lambda, KtExpression $keySelector, KtExpression $valueTransform, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        $this$buildExpression.appendExpression($receiverExpression);
        $this$buildExpression.appendFixedText(".");
        $this$buildExpression.appendFixedText(this$0.functionName);
        $this$buildExpression.appendFixedText("(");
        if ($destination != null) {
            $this$buildExpression.appendExpression($destination);
            $this$buildExpression.appendFixedText(",");
        }
        this$0.appendLambda((BuilderByPattern<KtExpression>)$this$buildExpression, $lambda, $keySelector);
        $this$buildExpression.appendFixedText(",");
        this$0.appendLambda((BuilderByPattern<KtExpression>)$this$buildExpression, $lambda, $valueTransform);
        $this$buildExpression.appendFixedText(")");
        return Unit.INSTANCE;
    }

    private static final Unit applyFix$lambda$1(KtExpression $receiverExpression, ReplaceAssociateFunctionFix this$0, KtCallExpression $callExpression, KtLambdaExpression $lambda, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        $this$buildExpression.appendExpression($receiverExpression);
        $this$buildExpression.appendFixedText(".");
        $this$buildExpression.appendFixedText(this$0.functionName);
        KtValueArgumentList valueArgumentList = $callExpression.getValueArgumentList();
        if (valueArgumentList != null) {
            this$0.appendValueArgumentList((BuilderByPattern<KtExpression>)$this$buildExpression, valueArgumentList);
        }
        List list2 = $callExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        if (!((Collection)list2).isEmpty()) {
            ReplaceAssociateFunctionFix.appendLambda$default(this$0, $this$buildExpression, $lambda, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceAssociateFunctionFix$Companion;", "", "<init>", "()V", "replaceLastStatementForAssociateFunction", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "function", "Lorg/jetbrains/kotlin/idea/inspections/AssociateFunction;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public final void replaceLastStatementForAssociateFunction(@NotNull KtCallExpression callExpression, @NotNull AssociateFunction function) {
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            Intrinsics.checkNotNullParameter((Object)((Object)function), (String)"function");
            KtLambdaExpression ktLambdaExpression = ReplaceAssociateFunctionInspectionKt.access$lambda(callExpression);
            if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null || (ktLambdaExpression = ReplaceAssociateFunctionInspectionKt.access$lastStatement((KtFunctionLiteral)ktLambdaExpression)) == null) {
                return;
            }
            KtLambdaExpression lastStatement = ktLambdaExpression;
            Pair pair = ReplaceAssociateFunctionInspectionKt.pair$default((KtExpression)lastStatement, null, 1, null);
            if (pair == null) {
                return;
            }
            Pair pair2 = pair;
            KtExpression keySelector = (KtExpression)pair2.component1();
            KtExpression valueTransform = (KtExpression)pair2.component2();
            lastStatement.replace((PsiElement)(function == AssociateFunction.ASSOCIATE_WITH ? valueTransform : keySelector));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

