/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithStdLibFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "methodName", "", "receiver", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
final class ReplaceWithStdLibFix
implements LocalQuickFix {
    @NotNull
    private final String methodName;
    @NotNull
    private final String receiver;

    public ReplaceWithStdLibFix(@NotNull String methodName, @NotNull String receiver2) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)receiver2, (String)"receiver");
        this.methodName = methodName;
        this.receiver = receiver2;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.receiver, this.methodName};
        return KotlinBundle.message((String)"replace.with.std.lib.fix.text", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression expression = ktDotQualifiedExpression;
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)expression);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        List list2 = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        List valueArguments = list2;
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)valueArguments, (int)0);
        if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
            return;
        }
        KtValueArgument firstArg = ktValueArgument;
        KtValueArgument ktValueArgument2 = (KtValueArgument)CollectionsKt.getOrNull((List)valueArguments, (int)1);
        KtExpression secondArg = ktValueArgument2 != null ? ktValueArgument2.getArgumentExpression() : null;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        if (secondArg != null) {
            if (Intrinsics.areEqual((Object)this.methodName, (Object)"sort")) {
                var10_9 = new Object[]{firstArg, secondArg.getText()};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0.sortWith(Comparator $1)", (Object[])var10_9, (boolean)false, (int)4, null);
            } else {
                var10_9 = new Object[]{firstArg, secondArg};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0." + this.methodName + "($1)"), (Object[])var10_9, (boolean)false, (int)4, null);
            }
        } else {
            var10_9 = new Object[]{firstArg};
            ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)("$0." + this.methodName + "()"), (Object[])var10_9, (boolean)false, (int)4, null);
        }
        KtExpression newExpression = ktExpression;
        expression.replace((PsiElement)newExpression);
    }
}

