/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain.result;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.AssignToVariableResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.MatchingState;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.SequenceTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatch;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.TransformationMatcher;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.VariableInitialization;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.sequence.FilterTransformationBase;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/CountTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/AssignToVariableResultTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "inputVariable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "initialization", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;", "filter", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "mergeWithPrevious", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ResultTransformation;", "previousTransformation", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/SequenceTransformation;", "reformat", "", "presentation", "", "getPresentation", "()Ljava/lang/String;", "generateCode", "chainedCallGenerator", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ChainedCallGenerator;", "Matcher", "kotlin.idea"})
public final class CountTransformation
extends AssignToVariableResultTransformation {
    @NotNull
    private final KtCallableDeclaration inputVariable;
    @Nullable
    private final KtExpression filter;

    public CountTransformation(@NotNull KtForExpression loop, @NotNull KtCallableDeclaration inputVariable, @NotNull VariableInitialization initialization, @Nullable KtExpression filter2) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)inputVariable, (String)"inputVariable");
        Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
        super(loop, initialization);
        this.inputVariable = inputVariable;
        this.filter = filter2;
    }

    @Override
    @Nullable
    public ResultTransformation mergeWithPrevious(@NotNull SequenceTransformation previousTransformation, boolean reformat) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)previousTransformation, (String)"previousTransformation");
        if (!(previousTransformation instanceof FilterTransformationBase)) {
            return null;
        }
        if (((FilterTransformationBase)previousTransformation).getIndexVariable() != null) {
            return null;
        }
        if (this.filter == null) {
            ktExpression = ((FilterTransformationBase)previousTransformation).getEffectiveCondition().asExpression(reformat);
        } else {
            Project project = this.filter.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{((FilterTransformationBase)previousTransformation).getEffectiveCondition().asExpression(reformat), this.filter};
            ktExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0 && $1", (Object[])objectArray, (boolean)reformat);
        }
        KtExpression newFilter = ktExpression;
        return new CountTransformation(this.getLoop(), ((FilterTransformationBase)previousTransformation).getInputVariable(), this.getInitialization(), newFilter);
    }

    @Override
    @NotNull
    public String getPresentation() {
        return "count" + (this.filter != null ? "{}" : "()");
    }

    @Override
    @NotNull
    public KtExpression generateCode(@NotNull ChainedCallGenerator chainedCallGenerator2) {
        KtExpression ktExpression;
        KtExpression call2;
        Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
        boolean reformat = chainedCallGenerator2.getReformat();
        if (this.filter != null) {
            KtLambdaExpression lambda2 = UtilsKt.generateLambda(this.inputVariable, this.filter, reformat);
            Object[] objectArray = new Object[]{lambda2};
            v0 = ChainedCallGenerator.generate$default(chainedCallGenerator2, "count $0:'{}'", objectArray, null, false, 12, null);
        } else {
            v0 = call2 = ChainedCallGenerator.generate$default(chainedCallGenerator2, "count()", new Object[0], null, false, 12, null);
        }
        if (CommonUtilsKt.isZeroConstant(this.getInitialization().getInitializer())) {
            ktExpression = call2;
        } else {
            Project project = call2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{this.getInitialization().getInitializer(), call2};
            ktExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0 + $1", (Object[])objectArray, (boolean)reformat);
        }
        return ktExpression;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/result/CountTransformation$Matcher;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatcher;", "<init>", "()V", "indexVariableAllowed", "", "getIndexVariableAllowed", "()Z", "shouldUseInputVariables", "getShouldUseInputVariables", "match", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/TransformationMatch$Result;", "state", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/MatchingState;", "kotlin.idea"})
    public static final class Matcher
    implements TransformationMatcher {
        @NotNull
        public static final Matcher INSTANCE = new Matcher();

        private Matcher() {
        }

        @Override
        public boolean getIndexVariableAllowed() {
            return false;
        }

        @Override
        public boolean getShouldUseInputVariables() {
            return false;
        }

        @Override
        @Nullable
        public TransformationMatch.Result match(@NotNull MatchingState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(state.getStatements());
            if (ktExpression == null || (ktExpression = CommonUtilsKt.isPlusPlusOf(ktExpression)) == null) {
                return null;
            }
            KtExpression operand = ktExpression;
            VariableInitialization variableInitialization = UtilsKt.findVariableInitializationBeforeLoop(operand, state.getOuterLoop(), true);
            if (variableInitialization == null) {
                return null;
            }
            VariableInitialization initialization = variableInitialization;
            if (CommonUtilsKt.countUsages((KtCallableDeclaration)initialization.getVariable(), (KtElement)state.getOuterLoop()) != 1) {
                return null;
            }
            VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(initialization.getVariable(), null, 1, null);
            if (variableDescriptor == null || (variableDescriptor = variableDescriptor.getType()) == null) {
                return null;
            }
            VariableDescriptor variableType = variableDescriptor;
            if (!KotlinBuiltIns.isInt((KotlinType)variableType)) {
                return null;
            }
            CountTransformation transformation = new CountTransformation(state.getOuterLoop(), state.getInputVariable(), initialization, null);
            return new TransformationMatch.Result((ResultTransformation)transformation, new SequenceTransformation[0]);
        }
    }
}

