/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k.post.processing.inference.nullability;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.DefaultStateProvider;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.FunctionParameter;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.FunctionReturnType;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.OtherTarget;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.Property;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.State;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeArgument;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeElementBasedTypeVariable;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariable;
import org.jetbrains.kotlin.idea.j2k.post.processing.inference.common.TypeVariableOwner;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/nullability/NullabilityDefaultStateProvider;", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/DefaultStateProvider;", "<init>", "()V", "defaultStateFor", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/State;", "typeVariable", "Lorg/jetbrains/kotlin/idea/j2k/post/processing/inference/common/TypeVariable;", "kotlin.j2k.k1.new.post-processing"})
public final class NullabilityDefaultStateProvider
extends DefaultStateProvider {
    @Override
    @NotNull
    public State defaultStateFor(@NotNull TypeVariable typeVariable) {
        State state;
        Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
        if (typeVariable instanceof TypeElementBasedTypeVariable && ((TypeElementBasedTypeVariable)typeVariable).getTypeElement().getType().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return State.LOWER;
        }
        TypeVariableOwner owner = typeVariable.getOwner();
        if (owner instanceof FunctionParameter) {
            state = KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)((FunctionParameter)owner).getOwner())) ? State.LOWER : State.UPPER;
        } else if (owner instanceof FunctionReturnType) {
            state = KotlinRefactoringUtilKt.isAbstract((KtNamedDeclaration)((FunctionReturnType)owner).getFunction()) || ((FunctionReturnType)owner).getFunction().hasModifier(KtTokens.OPEN_KEYWORD) || ((FunctionReturnType)owner).getFunction().getBodyExpression() == null ? State.UPPER : State.LOWER;
        } else if (owner instanceof Property) {
            state = KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)((Property)owner).getProperty())) || !((Property)owner).getProperty().isVar() || !((Property)owner).getProperty().isLocal() ? State.LOWER : State.UPPER;
        } else if (owner instanceof TypeArgument) {
            state = State.LOWER;
        } else if (Intrinsics.areEqual((Object)owner, (Object)OtherTarget.INSTANCE)) {
            state = State.UPPER;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return state;
    }
}

