/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspection;
import org.jetbrains.kotlin.idea.intentions.SimplifyBooleanWithConstantsIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0094\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SimplifyComparisonFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "value", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getValue", "()Z", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSimplifyComparisonFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyComparisonFix.kt\norg/jetbrains/kotlin/idea/quickfix/SimplifyComparisonFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n26#2,7:51\n154#3:58\n150#3:59\n1#4:60\n*S KotlinDebug\n*F\n+ 1 SimplifyComparisonFix.kt\norg/jetbrains/kotlin/idea/quickfix/SimplifyComparisonFix\n*L\n29#1:51,7\n31#1:58\n39#1:59\n*E\n"})
public final class SimplifyComparisonFix
extends KotlinQuickFixAction<KtExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean value;

    public SimplifyComparisonFix(@NotNull KtExpression element, boolean value) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.value = value;
    }

    public final boolean getValue() {
        return this.value;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"simplify.comparison", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"simplify.comparison", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        KtIfExpression ifExpression2;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression element = ktExpression;
        KtExpression replacement = new KtPsiFactory(project, false, 2, null).createExpression(String.valueOf(this.value));
        PsiElement $this$replaced$iv = (PsiElement)element;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)replacement))) {
            psiElement = (PsiElement)replacement;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)replacement);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression2;
            }
        }
        KtExpression result2 = (KtExpression)psiElement;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)result2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtBinaryExpression booleanExpression = (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtBinaryExpression.class, (boolean)false);
        SimplifyBooleanWithConstantsIntention simplifyIntention = new SimplifyBooleanWithConstantsIntention();
        if (booleanExpression != null && simplifyIntention.isApplicableTo(booleanExpression)) {
            simplifyIntention.applyTo(booleanExpression, editor);
        } else {
            simplifyIntention.removeRedundantAssertion$kotlin_idea(result2);
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)result2;
        boolean $i$f$getStrictParentOfType = false;
        KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtIfExpression.class, (boolean)true);
        if (ktIfExpression != null) {
            KtIfExpression ktIfExpression2;
            KtIfExpression it = ktIfExpression2 = ktIfExpression;
            boolean bl = false;
            v4 = Intrinsics.areEqual((Object)it.getCondition(), (Object)result2) ? ktIfExpression2 : null;
        } else {
            v4 = ifExpression2 = null;
        }
        if (ifExpression2 != null) {
            ConstantConditionIfInspection.Util.INSTANCE.applyFixIfSingle(ifExpression2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SimplifyComparisonFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression = ktExpression;
            DiagnosticWithParameters2 diagnosticWithParameters2 = diagnostic instanceof DiagnosticWithParameters2 ? (DiagnosticWithParameters2)diagnostic : null;
            Object object = diagnosticWithParameters2 != null ? diagnosticWithParameters2.getB() : null;
            Boolean bl = object instanceof Boolean ? (Boolean)object : null;
            if (bl == null) {
                return null;
            }
            boolean value = bl;
            return new SimplifyComparisonFix(expression, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

