/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFixKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J#\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0094\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/WrongPrimitiveLiteralFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "typeName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "expectedTypeIsFloat", "", "expectedTypeIsDouble", "expectedTypeIsUnsigned", "constValue", "", "fixedExpression", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFamilyName", "getText", "invoke", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nWrongPrimitiveLiteralFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrongPrimitiveLiteralFix.kt\norg/jetbrains/kotlin/idea/quickfix/WrongPrimitiveLiteralFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,97:1\n26#2,7:98\n*S KotlinDebug\n*F\n+ 1 WrongPrimitiveLiteralFix.kt\norg/jetbrains/kotlin/idea/quickfix/WrongPrimitiveLiteralFix\n*L\n93#1:98,7\n*E\n"})
public final class WrongPrimitiveLiteralFix
extends KotlinQuickFixAction<KtExpression> {
    @NotNull
    private final FqNameUnsafe typeName;
    private final boolean expectedTypeIsFloat;
    private final boolean expectedTypeIsDouble;
    private final boolean expectedTypeIsUnsigned;
    @Nullable
    private final Number constValue;
    @NotNull
    private final String fixedExpression;

    public WrongPrimitiveLiteralFix(@NotNull KtConstantExpression element, @NotNull KotlinType type2) {
        StringBuilder stringBuilder;
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)element);
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull((Object)classifierDescriptor);
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
        this.typeName = fqNameUnsafe;
        this.expectedTypeIsFloat = KotlinBuiltIns.isFloat((KotlinType)type2);
        this.expectedTypeIsDouble = KotlinBuiltIns.isDouble((KotlinType)type2);
        this.expectedTypeIsUnsigned = TypeUtilsKt.isUnsignedNumberType((KotlinType)type2);
        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = this;
        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix2 = this;
        boolean bl = false;
        boolean shouldInlineConstVals = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element).supportsFeature(LanguageFeature.InlineConstVals);
        ConstantValue constantValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant((KtExpression)((KtExpression)element), (BindingContext)ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL), (boolean)shouldInlineConstVals);
        Object object2 = object = constantValue != null ? constantValue.getValue() : null;
        wrongPrimitiveLiteralFix2.constValue = object instanceof Number ? (Number)((Number)object) : (Number)null;
        StringBuilder $this$constValue_u24lambda_u240 = stringBuilder = new StringBuilder();
        wrongPrimitiveLiteralFix2 = this;
        boolean bl2 = false;
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble) {
            $this$fixedExpression_u24lambda_u241.append(this.constValue);
            if (this.expectedTypeIsFloat) {
                $this$fixedExpression_u24lambda_u241.append('F');
            } else if (!StringsKt.contains$default((CharSequence)((CharSequence)$this$fixedExpression_u24lambda_u241), (char)'.', (boolean)false, (int)2, null)) {
                $this$fixedExpression_u24lambda_u241.append(".0");
            }
        } else if (this.expectedTypeIsUnsigned) {
            $this$fixedExpression_u24lambda_u241.append(this.constValue);
            $this$fixedExpression_u24lambda_u241.append('u');
        } else {
            if (this.constValue instanceof Float || this.constValue instanceof Double) {
                v3 = $this$fixedExpression_u24lambda_u241.append(this.constValue.longValue());
            } else {
                String string = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                char[] cArray = new char[]{'l', 'L', 'u'};
                v3 = $this$fixedExpression_u24lambda_u241.append(StringsKt.trimEnd((String)string, (char[])cArray));
            }
            if (KotlinBuiltIns.isLong((KotlinType)type2)) {
                $this$fixedExpression_u24lambda_u241.append('L');
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        wrongPrimitiveLiteralFix2.fixedExpression = string;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.isAvailable();
    }

    public final boolean isAvailable() {
        if (this.constValue == null) {
            return false;
        }
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble || this.expectedTypeIsUnsigned) {
            return true;
        }
        if (this.constValue instanceof Float || this.constValue instanceof Double) {
            double value = this.constValue.doubleValue();
            if (!(value == Math.floor(value))) {
                return false;
            }
            if (!(-9.223372036854776E18 <= value ? value <= 9.223372036854776E18 : false)) {
                return false;
            }
        }
        LongRange longRange = (LongRange)WrongPrimitiveLiteralFixKt.access$getValueRanges$p().get(this.typeName);
        if (longRange == null) {
            return false;
        }
        LongRange longRange2 = longRange;
        long l = longRange2.getFirst();
        long l2 = longRange2.getLast();
        long l3 = this.constValue.longValue();
        return l <= l3 ? l3 <= l2 : false;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"change.to.correct.primitive.type", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.fixedExpression};
        return KotlinBundle.message((String)"change.to.0", (Object[])objectArray);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block6: {
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element = ktExpression;
            KtExpression expressionToInsert = new KtPsiFactory(project, false, 2, null).createExpression(this.fixedExpression);
            PsiElement $this$replaced$iv = (PsiElement)element;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)expressionToInsert))) {
                psiElement = (PsiElement)expressionToInsert;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)expressionToInsert);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression2;
                }
            }
            KtExpression newExpression = (KtExpression)psiElement;
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block6;
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newExpression)));
        }
    }
}

