/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineFunctionHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineAnonymousFunctionProcessor;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineAnonymousFunctionHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineFunctionHandler;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "<init>", "()V", "canInlineKotlinFunction", "", "function", "inlineKotlinFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class KotlinInlineAnonymousFunctionHandler
extends AbstractKotlinInlineFunctionHandler<KtFunction> {
    @Override
    public boolean canInlineKotlinFunction(@NotNull KtFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return ExpressionExtKt.isAnonymousFunction((PsiElement)function) || function instanceof KtFunctionLiteral;
    }

    @Override
    public void inlineKotlinFunction(@NotNull Project project, @Nullable Editor editor, @NotNull KtFunction function) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtExpression call2 = KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function);
        if (call2 == null) {
            String string;
            if (function instanceof KtFunctionLiteral) {
                var6_5 = new Object[]{this.getRefactoringName()};
                string = KotlinBundle.message((String)"refactoring.cannot.be.applied.to.lambda.expression.without.invocation", (Object[])var6_5);
            } else {
                var6_5 = new Object[]{this.getRefactoringName()};
                string = KotlinBundle.message((String)"refactoring.cannot.be.applied.to.anonymous.function.without.invocation", (Object[])var6_5);
            }
            String message2 = string;
            this.showErrorHint(project, editor, message2);
            return;
        }
        new KotlinInlineAnonymousFunctionProcessor(function, call2, editor, project).run();
    }
}

