/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.extractSuperclass.JavaExtractSuperBaseDialog;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.UiUtils;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ExtractSuperInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinUsesAndInterfacesDependencyMemberInfoModel;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u00018BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010$\u001a\u00020\u000eH\u0002J\b\u0010%\u001a\u00020\u0017H$J\b\u0010&\u001a\u00020\u000bH\u0014J\b\u0010'\u001a\u00020\bH\u0014J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020\u001eH\u0014J\n\u0010+\u001a\u0004\u0018\u00010,H\u0014J\n\u0010-\u001a\u0004\u0018\u00010.H\u0014J\n\u0010/\u001a\u0004\u0018\u00010.H\u0014J\b\u00100\u001a\u00020\u000eH\u0014J\b\u00101\u001a\u00020\u000eH\u0014J\b\u00102\u001a\u00020\bH\u0016J\u0012\u00103\u001a\u0004\u0018\u00010\u000b2\u0006\u00104\u001a\u00020\u000bH\u0014J\n\u00105\u001a\u0004\u0018\u000106H\u0014J\b\u00107\u001a\u00020\u000eH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0011\u0010!\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase;", "Lcom/intellij/refactoring/extractSuperclass/JavaExtractSuperBaseDialog;", "originalClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "targetParent", "Lcom/intellij/psi/PsiElement;", "conflictChecker", "Lkotlin/Function1;", "", "isExtractInterface", "refactoringName", "", "refactoring", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ExtractSuperInfo;", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;ZLjava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getOriginalClass", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getTargetParent", "()Lcom/intellij/psi/PsiElement;", "initComplete", "memberInfoModel", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase$MemberInfoModelBase;", "selectedMembers", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "getSelectedMembers", "()Ljava/util/List;", "fileNameField", "Ljavax/swing/JTextField;", "selectedTargetParent", "getSelectedTargetParent", "targetFileName", "getTargetFileName", "()Ljava/lang/String;", "resetFileNameField", "createMemberInfoModel", "getDocCommentPanelName", "checkConflicts", "createActionComponent", "Ljavax/swing/Box;", "createExtractedSuperNameField", "createDestinationRootPanel", "Ljavax/swing/JPanel;", "createNorthPanel", "Ljavax/swing/JComponent;", "createCenterPanel", "init", "preparePackage", "isExtractSuperclass", "validateName", "name", "createProcessor", "", "executeRefactoring", "MemberInfoModelBase", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinExtractSuperDialogBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtractSuperDialogBase.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n774#2:184\n865#2,2:185\n*S KotlinDebug\n*F\n+ 1 KotlinExtractSuperDialogBase.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase\n*L\n46#1:184\n46#1:185,2\n*E\n"})
public abstract class KotlinExtractSuperDialogBase
extends JavaExtractSuperBaseDialog {
    @NotNull
    private final KtClassOrObject originalClass;
    @NotNull
    private final PsiElement targetParent;
    @NotNull
    private final Function1<KotlinExtractSuperDialogBase, Boolean> conflictChecker;
    private final boolean isExtractInterface;
    @NotNull
    private final Function1<ExtractSuperInfo, Unit> refactoring;
    private boolean initComplete;
    private MemberInfoModelBase memberInfoModel;
    @NotNull
    private final JTextField fileNameField;

    public KotlinExtractSuperDialogBase(@NotNull KtClassOrObject originalClass, @NotNull PsiElement targetParent, @NotNull Function1<? super KotlinExtractSuperDialogBase, Boolean> conflictChecker, boolean isExtractInterface, @Nls @NotNull String refactoringName, @NotNull Function1<? super ExtractSuperInfo, Unit> refactoring) {
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        Intrinsics.checkNotNullParameter((Object)targetParent, (String)"targetParent");
        Intrinsics.checkNotNullParameter(conflictChecker, (String)"conflictChecker");
        Intrinsics.checkNotNullParameter((Object)refactoringName, (String)"refactoringName");
        Intrinsics.checkNotNullParameter(refactoring, (String)"refactoring");
        Project project = originalClass.getProject();
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)originalClass);
        Intrinsics.checkNotNull((Object)ktLightClass);
        super(project, (PsiClass)ktLightClass, CollectionsKt.emptyList(), refactoringName);
        this.originalClass = originalClass;
        this.targetParent = targetParent;
        this.conflictChecker = conflictChecker;
        this.isExtractInterface = isExtractInterface;
        this.refactoring = refactoring;
        this.fileNameField = new JTextField();
    }

    @NotNull
    protected final KtClassOrObject getOriginalClass() {
        return this.originalClass;
    }

    @NotNull
    protected final PsiElement getTargetParent() {
        return this.targetParent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinMemberInfo> getSelectedMembers() {
        void $this$filterTo$iv$iv;
        MemberInfoModelBase memberInfoModelBase = this.memberInfoModel;
        if (memberInfoModelBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"memberInfoModel");
            memberInfoModelBase = null;
        }
        Iterable $this$filter$iv = memberInfoModelBase.getMemberInfos();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinMemberInfo it = (KotlinMemberInfo)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.isChecked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PsiElement getSelectedTargetParent() {
        PsiElement psiElement;
        if (this.targetParent instanceof PsiDirectory) {
            PsiDirectory psiDirectory = this.getTargetDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getTargetDirectory(...)");
            psiElement = (PsiElement)psiDirectory;
        } else {
            psiElement = this.targetParent;
        }
        return psiElement;
    }

    @NotNull
    public final String getTargetFileName() {
        String string = this.fileNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final void resetFileNameField() {
        if (!this.initComplete) {
            return;
        }
        this.fileNameField.setText(this.getExtractedSuperName() + ".kt");
    }

    @NotNull
    protected abstract MemberInfoModelBase createMemberInfoModel();

    @NotNull
    protected String getDocCommentPanelName() {
        return KotlinBundle.message((String)"title.kdoc.for.abstracts", (Object[])new Object[0]);
    }

    protected boolean checkConflicts() {
        return (Boolean)this.conflictChecker.invoke((Object)this);
    }

    @NotNull
    protected Box createActionComponent() {
        Box box = Box.createHorizontalBox();
        Intrinsics.checkNotNull((Object)box);
        return box;
    }

    @NotNull
    protected JTextField createExtractedSuperNameField() {
        JTextField jTextField;
        JTextField $this$createExtractedSuperNameField_u24lambda_u242 = jTextField = super.createExtractedSuperNameField();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$createExtractedSuperNameField_u24lambda_u242);
        UiUtils.onTextChange($this$createExtractedSuperNameField_u24lambda_u242, (Function1<? super DocumentEvent, Unit>)((Function1)arg_0 -> KotlinExtractSuperDialogBase.createExtractedSuperNameField$lambda$2$lambda$1(this, arg_0)));
        JTextField jTextField2 = jTextField;
        Intrinsics.checkNotNullExpressionValue((Object)jTextField2, (String)"apply(...)");
        return jTextField2;
    }

    @Nullable
    protected JPanel createDestinationRootPanel() {
        JPanel jPanel;
        if (!(this.targetParent instanceof PsiDirectory)) {
            return null;
        }
        JPanel targetDirectoryPanel = super.createDestinationRootPanel();
        JPanel $this$createDestinationRootPanel_u24lambda_u243 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createDestinationRootPanel_u24lambda_u243.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JBLabel label2 = new JBLabel(KotlinBundle.message((String)"label.text.target.file.name", (Object[])new Object[0]));
        $this$createDestinationRootPanel_u24lambda_u243.add((Component)label2, "North");
        label2.setLabelFor((Component)this.fileNameField);
        $this$createDestinationRootPanel_u24lambda_u243.add((Component)this.fileNameField, "Center");
        JPanel targetFileNamePanel = jPanel;
        FormBuilder formBuilder = FormBuilder.createFormBuilder();
        if (targetDirectoryPanel != null) {
            formBuilder.addComponent((JComponent)targetDirectoryPanel);
        }
        return formBuilder.addComponent((JComponent)targetFileNamePanel).getPanel();
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JComponent jComponent;
        JComponent $this$createNorthPanel_u24lambda_u244 = jComponent = super.createNorthPanel();
        boolean bl = false;
        if (!(this.targetParent instanceof PsiDirectory)) {
            this.myPackageNameLabel.getParent().remove(this.myPackageNameLabel);
            this.myPackageNameField.getParent().remove((Component)this.myPackageNameField);
        }
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected JComponent createCenterPanel() {
        void $this$createCenterPanel_u24lambda_u245;
        Object object = this.createMemberInfoModel();
        MemberInfoModelBase memberInfoModelBase = object;
        KotlinExtractSuperDialogBase kotlinExtractSuperDialogBase = this;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u245.memberInfoChanged(new MemberInfoChange((Collection)$this$createCenterPanel_u24lambda_u245.getMemberInfos()));
        kotlinExtractSuperDialogBase.memberInfoModel = object;
        Object $this$createCenterPanel_u24lambda_u246 = object = new JPanel(new BorderLayout());
        boolean bl2 = false;
        String string = RefactoringBundle.message((String)(this.isExtractInterface ? "members.to.form.interface" : "members.to.form.superclass"));
        MemberInfoModelBase memberInfoModelBase2 = this.memberInfoModel;
        if (memberInfoModelBase2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"memberInfoModel");
            memberInfoModelBase2 = null;
        }
        KotlinMemberSelectionPanel memberSelectionPanel = new KotlinMemberSelectionPanel(string, memberInfoModelBase2.getMemberInfos(), RefactoringBundle.message((String)"make.abstract"));
        KotlinMemberSelectionTable kotlinMemberSelectionTable = memberSelectionPanel.getTable();
        MemberInfoModelBase memberInfoModelBase3 = this.memberInfoModel;
        if (memberInfoModelBase3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"memberInfoModel");
            memberInfoModelBase3 = null;
        }
        kotlinMemberSelectionTable.setMemberInfoModel((MemberInfoModel)memberInfoModelBase3);
        KotlinMemberSelectionTable kotlinMemberSelectionTable2 = memberSelectionPanel.getTable();
        MemberInfoModelBase memberInfoModelBase4 = this.memberInfoModel;
        if (memberInfoModelBase4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"memberInfoModel");
            memberInfoModelBase4 = null;
        }
        kotlinMemberSelectionTable2.addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModelBase4);
        ((Container)$this$createCenterPanel_u24lambda_u246).add((Component)((Object)memberSelectionPanel), "Center");
        ((Container)$this$createCenterPanel_u24lambda_u246).add((Component)this.myDocCommentPanel, "East");
        return (JComponent)object;
    }

    protected void init() {
        super.init();
        this.initComplete = true;
        this.resetFileNameField();
    }

    protected void preparePackage() {
        if (this.targetParent instanceof PsiDirectory) {
            super.preparePackage();
        }
    }

    public boolean isExtractSuperclass() {
        return true;
    }

    @Nullable
    protected String validateName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return !KtPsiUtilKt.isIdentifier((String)KtPsiUtilKt.quoteIfNeeded((String)name2)) ? RefactoringMessageUtil.getIncorrectIdentifierMessage((String)name2) : (Intrinsics.areEqual((Object)KotlinPsiModificationUtils.unquoteKotlinIdentifier(name2), (Object)((PsiClass)this.mySourceClass).getName()) ? KotlinBundle.message((String)"error.text.different.name.expected", (Object[])new Object[0]) : null);
    }

    @Nullable
    protected Void createProcessor() {
        return null;
    }

    protected void executeRefactoring() {
        PsiElement psiElement = this.mySourceClass;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"mySourceClass");
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)psiElement);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement2;
        Collection collection = this.getSelectedMembers();
        PsiElement psiElement3 = this.targetParent instanceof PsiDirectory ? (PsiElement)this.getTargetDirectory() : this.targetParent;
        Intrinsics.checkNotNull((Object)psiElement3);
        String string = this.getTargetFileName();
        String string2 = this.getExtractedSuperName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtractedSuperName(...)");
        ExtractSuperInfo extractInfo = new ExtractSuperInfo(ktClassOrObject, collection, psiElement3, string, KtPsiUtilKt.quoteIfNeeded((String)string2), this.isExtractInterface, new DocCommentPolicy(this.getDocCommentPolicy()));
        this.refactoring.invoke((Object)extractInfo);
    }

    private static final Unit createExtractedSuperNameField$lambda$2$lambda$1(KotlinExtractSuperDialogBase this$0, DocumentEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.resetFileNameField();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0017\u0010\u0013\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase$MemberInfoModelBase;", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinUsesAndInterfacesDependencyMemberInfoModel;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "originalClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "memberInfos", "", "interfaceContainmentVerifier", "Lkotlin/Function1;", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getMemberInfos", "()Ljava/util/List;", "isMemberEnabled", "member", "isAbstractEnabled", "memberInfo", "isFixedAbstract", "(Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;)Ljava/lang/Boolean;", "kotlin.idea"})
    public static class MemberInfoModelBase
    extends KotlinUsesAndInterfacesDependencyMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> {
        @NotNull
        private final List<KotlinMemberInfo> memberInfos;

        public MemberInfoModelBase(@NotNull KtClassOrObject originalClass, @NotNull List<KotlinMemberInfo> memberInfos, @NotNull Function1<? super KtNamedDeclaration, Boolean> interfaceContainmentVerifier) {
            Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
            Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
            Intrinsics.checkNotNullParameter(interfaceContainmentVerifier, (String)"interfaceContainmentVerifier");
            super(originalClass, null, false, interfaceContainmentVerifier);
            this.memberInfos = memberInfos;
        }

        @NotNull
        public final List<KotlinMemberInfo> getMemberInfos() {
            return this.memberInfos;
        }

        public boolean isMemberEnabled(@NotNull KotlinMemberInfo member) {
            Intrinsics.checkNotNullParameter((Object)((Object)member), (String)"member");
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)member.getMember();
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            return !declaration.hasModifier(KtTokens.CONST_KEYWORD);
        }

        public boolean isAbstractEnabled(@NotNull KotlinMemberInfo memberInfo) {
            Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
            KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
            return !member.hasModifier(KtTokens.INLINE_KEYWORD) && !member.hasModifier(KtTokens.EXTERNAL_KEYWORD) && !member.hasModifier(KtTokens.LATEINIT_KEYWORD);
        }

        @NotNull
        public Boolean isFixedAbstract(@Nullable KotlinMemberInfo memberInfo) {
            return true;
        }
    }
}

