/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.statistics.InspectionData;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeatureInspectionType;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeaturesFUSCollector;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeaturesService;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/LanguageFeatureDeprecationCollector;", "T", "Lorg/jetbrains/kotlin/idea/statistics/InspectionData;", "", "inspectionUpdatedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "inspectionAppliedEvent", "inspectionType", "Lorg/jetbrains/kotlin/idea/statistics/KotlinLanguageFeatureInspectionType;", "<init>", "(Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;Lorg/jetbrains/kotlin/idea/statistics/KotlinLanguageFeatureInspectionType;)V", "logInspectionUpdated", "", "file", "Lcom/intellij/psi/PsiFile;", "data", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/idea/statistics/InspectionData;Lorg/jetbrains/kotlin/config/LanguageVersion;)V", "logQuickFixApplied", "kotlin.base.statistics"})
@SourceDebugExtension(value={"SMAP\nKotlinLanguageFeaturesFUSCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLanguageFeaturesFUSCollector.kt\norg/jetbrains/kotlin/idea/statistics/LanguageFeatureDeprecationCollector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,173:1\n51#2:174\n37#3,2:175\n*S KotlinDebug\n*F\n+ 1 KotlinLanguageFeaturesFUSCollector.kt\norg/jetbrains/kotlin/idea/statistics/LanguageFeatureDeprecationCollector\n*L\n153#1:174\n161#1:175,2\n*E\n"})
public final class LanguageFeatureDeprecationCollector<T extends InspectionData> {
    @NotNull
    private final VarargEventId inspectionUpdatedEvent;
    @NotNull
    private final VarargEventId inspectionAppliedEvent;
    @NotNull
    private final KotlinLanguageFeatureInspectionType inspectionType;

    public LanguageFeatureDeprecationCollector(@NotNull VarargEventId inspectionUpdatedEvent, @NotNull VarargEventId inspectionAppliedEvent, @NotNull KotlinLanguageFeatureInspectionType inspectionType) {
        Intrinsics.checkNotNullParameter((Object)inspectionUpdatedEvent, (String)"inspectionUpdatedEvent");
        Intrinsics.checkNotNullParameter((Object)inspectionAppliedEvent, (String)"inspectionAppliedEvent");
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionType), (String)"inspectionType");
        this.inspectionUpdatedEvent = inspectionUpdatedEvent;
        this.inspectionAppliedEvent = inspectionAppliedEvent;
        this.inspectionType = inspectionType;
    }

    public final void logInspectionUpdated(@NotNull PsiFile file, @NotNull T data, @NotNull LanguageVersion languageVersion) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        if (!(file instanceof KtFile) || ((KtFile)file).getVirtualFile() == null) {
            return;
        }
        Project project = ((KtFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)project;
        boolean $i$f$serviceOrNull = false;
        KotlinLanguageFeaturesService kotlinLanguageFeaturesService = (KotlinLanguageFeaturesService)$this$serviceOrNull$iv.getService(KotlinLanguageFeaturesService.class);
        if (kotlinLanguageFeaturesService == null) {
            return;
        }
        KotlinLanguageFeaturesService service2 = kotlinLanguageFeaturesService;
        if (!service2.recordInspection((KtFile)file, this.inspectionType, (InspectionData)data)) {
            return;
        }
        Project project2 = ((KtFile)file).getProject();
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add((Object)EventFields.AnonymizedPath.with((Object)((KtFile)file).getVirtualFilePath()));
        spreadBuilder.add((Object)KotlinLanguageFeaturesFUSCollector.INSTANCE.getKotlinLanguageVersionField().with((Object)languageVersion.getVersionString()));
        spreadBuilder.add((Object)KotlinLanguageFeaturesFUSCollector.INSTANCE.getInspectionTypeField().with((Object)this.inspectionType));
        Collection $this$toTypedArray$iv = data.toEventPairs();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new EventPair[0]));
        this.inspectionUpdatedEvent.log(project2, (EventPair[])spreadBuilder.toArray((Object[])new EventPair[spreadBuilder.size()]));
    }

    public final void logQuickFixApplied(@Nullable PsiFile file) {
        if (!(file instanceof KtFile) || ((KtFile)file).getVirtualFile() == null) {
            return;
        }
        EventPair[] eventPairArray = new EventPair[]{EventFields.AnonymizedPath.with((Object)((KtFile)file).getVirtualFilePath()), KotlinLanguageFeaturesFUSCollector.INSTANCE.getInspectionTypeField().with((Object)this.inspectionType)};
        this.inspectionAppliedEvent.log(((KtFile)file).getProject(), eventPairArray);
    }
}

