/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumListEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.statistics.KotlinASStatisticsEventFlags;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0002R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getBuildSystemType", "", "it", "Lcom/intellij/openapi/module/Module;", "GROUP", "systemField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "platformField", "languageLevelField", "isMPPBuild", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "pluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "eventFlags", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "nonDefaultLanguageFeaturesField", "Lcom/intellij/internal/statistic/eventLog/events/EnumListEventField;", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "composePlatformFields", "", "buildEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nProjectConfigurationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n368#2,4:104\n1863#3,2:108\n1557#3:110\n1628#3,3:111\n*S KotlinDebug\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n*L\n73#1:104,4\n32#1:108,2\n88#1:110\n88#1:111,3\n*E\n"})
public final class ProjectConfigurationCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.project.configuration", 12, null, 4, null);
    @NotNull
    private final StringEventField systemField;
    @NotNull
    private final StringEventField platformField;
    @NotNull
    private final StringEventField languageLevelField;
    @NotNull
    private final BooleanEventField isMPPBuild;
    @NotNull
    private final PrimitiveEventField<PluginInfo> pluginInfoField;
    @NotNull
    private final LongEventField eventFlags;
    @NotNull
    private final EnumListEventField<LanguageFeature> nonDefaultLanguageFeaturesField;
    @NotNull
    private final VarargEventId buildEvent;

    /*
     * WARNING - void declaration
     */
    public ProjectConfigurationCollector() {
        void name$iv;
        Object object = new String[]{"JPS", "Maven", "Gradle", "unknown"};
        this.systemField = EventFields.String((String)"system", (List)CollectionsKt.listOf((Object[])object));
        this.platformField = EventFields.String((String)"platform", this.composePlatformFields());
        this.languageLevelField = EventFields.StringValidatedByRegexpReference$default((String)"languageLevel", (String)"version", null, (int)4, null);
        this.isMPPBuild = EventFields.Boolean((String)"isMPP");
        this.pluginInfoField = EventFields.PluginInfo;
        this.eventFlags = EventFields.Long$default((String)"eventFlags", null, (int)2, null);
        object = "nonDefaultLanguageFeatures";
        Function1 transform$iv = ProjectConfigurationCollector::nonDefaultLanguageFeaturesField$lambda$1;
        String description$iv = null;
        boolean $i$f$EnumList = false;
        this.nonDefaultLanguageFeaturesField = new EnumListEventField((String)name$iv, description$iv, LanguageFeature.class, transform$iv);
        object = new EventField[]{this.systemField, this.platformField, this.isMPPBuild, this.languageLevelField, this.pluginInfoField, this.eventFlags, this.nonDefaultLanguageFeaturesField};
        this.buildEvent = this.GROUP.registerVarargEvent("Build", (EventField[])object);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set metrics = new LinkedHashSet();
        List list2 = ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getModulesWithFacet(...)");
        List modulesWithFacet = list2;
        if (!((Collection)modulesWithFacet).isEmpty()) {
            Iterable $this$forEach$iv = modulesWithFacet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String buildSystem = this.getBuildSystemType(it);
                String platform = ConfigureKotlinInProjectUtilsKt.getPlatform(it);
                Object object = KotlinFacet.Companion.get(it);
                String languageLevel = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null && (object = object.getSettings()) != null && (object = object.getLanguageLevel()) != null ? object.getVersionString() : null;
                List nonDefaultLanguageFeatures = CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getNonDefaultLanguageFeatures(it));
                EventPair[] eventPairArray = new EventPair[]{this.systemField.with((Object)buildSystem), this.platformField.with((Object)platform), this.languageLevelField.with((Object)languageLevel), this.isMPPBuild.with((Object)(KotlinFacetUtils.isMultiPlatformModule(it) || KotlinFacetUtils.isNewMultiPlatformModule(it) ? 1 : 0)), this.pluginInfoField.with((Object)KotlinIdePlugin.INSTANCE.getPluginInfo()), this.eventFlags.with((Object)KotlinASStatisticsEventFlags.INSTANCE.calculateAndPackEventsFlagsToLong(it)), this.nonDefaultLanguageFeaturesField.with((Object)nonDefaultLanguageFeatures)};
                metrics.add(this.buildEvent.metric(eventPairArray));
            }
        }
        return metrics;
    }

    private final String getBuildSystemType(Module it) {
        String string;
        BuildSystemType buildSystem = BuildSystemTypeKt.getBuildSystemType(it);
        if (buildSystem == BuildSystemType.JPS) {
            string = "JPS";
        } else {
            String string2 = buildSystem.toString().toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"maven", (boolean)false, (int)2, null)) {
                string = "Maven";
            } else {
                String string3 = buildSystem.toString().toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = StringsKt.contains$default((CharSequence)string3, (CharSequence)"gradle", (boolean)false, (int)2, null) ? "Gradle" : "unknown";
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> composePlatformFields() {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new List[2];
        Object object = new String[]{"jvm", "jvm.android", "js", "wasm", "wasm.js", "wasm.wasi", "wasm.unknown", "common", "native.unknown", "unknown"};
        objectArray[0] = CollectionsKt.listOf((Object[])object);
        object = KonanTarget.Companion.getPredefinedTargets().keySet();
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CallSite)((Object)("native." + (String)it)));
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    private static final String nonDefaultLanguageFeaturesField$lambda$1(LanguageFeature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.name();
    }
}

