/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.suggestions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.suggestions.KotlinNotebookPluginSuggestion;
import org.jetbrains.kotlin.idea.suggestions.KotlinNotebookSuggestionProviderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/suggestions/KotlinNotebookSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "isPluginSuggestionDismissed", "", "requiredPluginsInstalled", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/KotlinNotebookSuggestionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1734#2,3:133\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/KotlinNotebookSuggestionProvider\n*L\n40#1:133,3\n*E\n"})
public final class KotlinNotebookSuggestionProvider
implements PluginSuggestionProvider {
    private final boolean isPluginSuggestionDismissed() {
        return PropertiesComponent.getInstance().isTrueValue("notebook.kotlin.suggestion.dismissed");
    }

    private final boolean requiredPluginsInstalled() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = KotlinNotebookSuggestionProviderKt.access$getKOTLIN_NOTEBOOKS_ALL_PLUGIN_IDS$p();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PluginId pluginId;
                    String pluginIdStr = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)PluginId.getId((String)pluginIdStr), (String)"getId(...)");
                    if (PluginManager.isPluginInstalled((PluginId)pluginId) && !PluginManagerCore.isDisabled((PluginId)pluginId)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"ipynb")) {
            return null;
        }
        if (this.requiredPluginsInstalled()) {
            return null;
        }
        if (this.isPluginSuggestionDismissed() || PluginAdvertiserServiceKt.tryUltimateIsDisabled()) {
            return null;
        }
        try {
            JsonElement jsonElement;
            JsonObject jsonObject;
            JsonElement jsonElement2;
            JsonObject jsonObject2;
            String notebookLanguage;
            JsonElement json = JsonParser.parseString((String)VirtualFileUtil.readText((VirtualFile)file));
            JsonElement jsonElement3 = json.getAsJsonObject().get("metadata");
            String string = notebookLanguage = jsonElement3 != null && (jsonObject2 = jsonElement3.getAsJsonObject()) != null && (jsonElement2 = jsonObject2.get("language_info")) != null && (jsonObject = jsonElement2.getAsJsonObject()) != null && (jsonElement = jsonObject.get("name")) != null ? jsonElement.getAsString() : null;
            if (!StringsKt.equals(notebookLanguage, (String)"kotlin", (boolean)true)) {
                return null;
            }
        }
        catch (Throwable ex) {
            return null;
        }
        return new KotlinNotebookPluginSuggestion(project, PluginAdvertiserService.Companion.isCommunityIde());
    }
}

