/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptDependencyModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u001b\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0014\u0010\u0014\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/util/AbstractSingleFileModuleFileEventListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isRelevantEvent", "", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "processEvent", "", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "processEvents", "events", "", "processEvents$kotlin_base_analysis", "mayBeFromSingleFileModule", "getSingleFileModule", "Lorg/jetbrains/kotlin/idea/util/AbstractSingleFileModuleAfterFileEventListener;", "Lorg/jetbrains/kotlin/idea/util/AbstractSingleFileModuleBeforeFileEventListener;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nAbstractSingleFileModuleFileEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSingleFileModuleFileEventListener.kt\norg/jetbrains/kotlin/idea/util/AbstractSingleFileModuleFileEventListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public abstract class AbstractSingleFileModuleFileEventListener
implements BulkFileListener {
    @NotNull
    private final Project project;

    private AbstractSingleFileModuleFileEventListener(Project project) {
        this.project = project;
    }

    protected abstract boolean isRelevantEvent(@NotNull VFileEvent var1, @NotNull VirtualFile var2);

    protected abstract void processEvent(@NotNull VFileEvent var1, @NotNull KaModule var2);

    public final void processEvents$kotlin_base_analysis(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            KaModule module;
            VirtualFile file;
            if (vFileEvent.getFile() == null || !this.isRelevantEvent(vFileEvent, file) || !this.mayBeFromSingleFileModule(file, this.project) || !ProjectFileIndex.getInstance((Project)this.project).isInContent(file) || this.getSingleFileModule(file) == null) continue;
            this.processEvent(vFileEvent, module);
        }
    }

    private final boolean mayBeFromSingleFileModule(VirtualFile $this$mayBeFromSingleFileModule, Project project) {
        return Intrinsics.areEqual((Object)$this$mayBeFromSingleFileModule.getExtension(), (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX) || FileUtils.isKotlinFileType($this$mayBeFromSingleFileModule) && !ProjectFileIndex.getInstance((Project)project).isInSourceContent($this$mayBeFromSingleFileModule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KaModule getSingleFileModule(VirtualFile $this$getSingleFileModule) {
        KaModule kaModule;
        PsiFile psiFile = PhysicalFileSystemUtilsKt.toPsiFile($this$getSingleFileModule, this.project);
        if (psiFile == null) return null;
        PsiFile psiFile2 = psiFile;
        boolean bl = false;
        KaModule kaModule2 = KotlinProjectStructureProvider.Companion.getModule(this.project, (PsiElement)psiFile2, null);
        if (kaModule2 == null) return null;
        KaModule kaModule3 = kaModule = kaModule2;
        boolean bl2 = false;
        if (!(kaModule3 instanceof KaScriptModule) && !(kaModule3 instanceof KaScriptDependencyModule)) {
            if (!(kaModule3 instanceof KaNotUnderContentRootModule)) return null;
        }
        boolean bl3 = true;
        if (!bl3) return null;
        KaModule kaModule4 = kaModule;
        return kaModule4;
    }

    public /* synthetic */ AbstractSingleFileModuleFileEventListener(Project project, DefaultConstructorMarker $constructor_marker) {
        this(project);
    }
}

