/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Operator;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/AssignmentExpression;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "left", "right", "op", "Lorg/jetbrains/kotlin/j2k/ast/Operator;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Operator;)V", "getLeft", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "getRight", "getOp", "()Lorg/jetbrains/kotlin/j2k/ast/Operator;", "isMultiAssignment", "", "appendAssignment", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "generateCode", "kotlin.j2k.k1.old"})
public class AssignmentExpression
extends Expression {
    @NotNull
    private final Expression left;
    @NotNull
    private final Expression right;
    @NotNull
    private final Operator op;

    public AssignmentExpression(@NotNull Expression left, @NotNull Expression right, @NotNull Operator op) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @NotNull
    public final Expression getLeft() {
        return this.left;
    }

    @NotNull
    public final Expression getRight() {
        return this.right;
    }

    @NotNull
    public final Operator getOp() {
        return this.op;
    }

    public final boolean isMultiAssignment() {
        return this.right instanceof AssignmentExpression;
    }

    private final void appendAssignment(CodeBuilder builder2, Expression left, Expression right) {
        UtilKt.appendOperand$default(UtilKt.appendOperand$default(builder2, this, left, false, 4, null).append(" ").append(this.op).append(" "), this, right, false, 4, null);
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        if (!(this.right instanceof AssignmentExpression)) {
            this.appendAssignment(builder2, this.left, this.right);
        } else {
            ((AssignmentExpression)this.right).generateCode(builder2);
            builder2.append("\n");
            this.appendAssignment(builder2, this.left, ((AssignmentExpression)this.right).left);
        }
    }
}

