/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.maven;

import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.GitSilentFileAdderProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;
import org.jetbrains.kotlin.tools.projectWizard.Versions;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.DefaultRepository;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B~\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\u000b\u0010\u000f\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u000e\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010 \u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\"\u001a\u00020\u000eH\u0002R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/maven/MavenKotlinModuleBuilderHelper;", "Lorg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper;", "projectId", "Lorg/jetbrains/idea/maven/model/MavenId;", "aggregatorProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "parentProject", "inheritGroupId", "", "inheritVersion", "archetype", "Lorg/jetbrains/idea/maven/model/MavenArchetype;", "propertiesToCreateByArtifact", "", "", "commandName", "Lcom/intellij/openapi/util/NlsContexts$Command;", "kotlinPluginWizardVersion", "outputDirectory", "filesToOpen", "", "<init>", "(Lorg/jetbrains/idea/maven/model/MavenId;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProject;ZZLorg/jetbrains/idea/maven/model/MavenArchetype;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInteractive", "getConditions", "Ljava/util/Properties;", "findBuildPluginInRootPom", "groupId", "artifactId", "Companion", "kotlin.project-wizard.maven"})
@SourceDebugExtension(value={"SMAP\nMavenKotlinModuleBuilderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenKotlinModuleBuilderHelper.kt\norg/jetbrains/kotlin/tools/projectWizard/maven/MavenKotlinModuleBuilderHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1755#2,3:153\n*S KotlinDebug\n*F\n+ 1 MavenKotlinModuleBuilderHelper.kt\norg/jetbrains/kotlin/tools/projectWizard/maven/MavenKotlinModuleBuilderHelper\n*L\n142#1:153,3\n*E\n"})
public final class MavenKotlinModuleBuilderHelper
extends MavenModuleBuilderHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kotlinPluginWizardVersion;
    @NotNull
    private final String outputDirectory;
    @NotNull
    private final List<String> filesToOpen;
    @NotNull
    private static final Logger LOG;

    public MavenKotlinModuleBuilderHelper(@NotNull MavenId projectId, @Nullable MavenProject aggregatorProject, @Nullable MavenProject parentProject, boolean inheritGroupId, boolean inheritVersion, @Nullable MavenArchetype archetype, @Nullable Map<String, String> propertiesToCreateByArtifact, @NotNull String commandName, @NotNull String kotlinPluginWizardVersion, @NotNull String outputDirectory, @NotNull List<String> filesToOpen) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        Intrinsics.checkNotNullParameter((Object)kotlinPluginWizardVersion, (String)"kotlinPluginWizardVersion");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter(filesToOpen, (String)"filesToOpen");
        super(projectId, aggregatorProject, parentProject, inheritGroupId, inheritVersion, archetype, propertiesToCreateByArtifact, commandName);
        this.kotlinPluginWizardVersion = kotlinPluginWizardVersion;
        this.outputDirectory = outputDirectory;
        this.filesToOpen = filesToOpen;
    }

    public void configure(@NotNull Project project, @NotNull VirtualFile root, boolean isInteractive) {
        PsiFile[] psiFileArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        MavenProject aggregatorProject = this.getMyAggregatorProject();
        if (aggregatorProject != null) {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray2[0] = MavenModuleBuilderHelper.getPsiFile((Project)project, (VirtualFile)aggregatorProject.getFile());
            psiFileArray = psiFileArray2;
        } else {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFiles = psiFileArray;
        VirtualFile virtualFile = (VirtualFile)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])Arrays.copyOf(psiFiles, psiFiles.length)).withName(this.getMyCommandName()).compute(() -> MavenKotlinModuleBuilderHelper.configure$lambda$0(project, root, this, isInteractive));
        if (virtualFile == null) {
            return;
        }
        VirtualFile pom = virtualFile;
        if (this.getMyAggregatorProject() == null) {
            MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)project);
            manager.addManagedFilesOrUnignoreNoUpdate(CollectionsKt.listOf((Object)pom));
        }
        LOG.info(((Object)((Object)this)).getClass().getSimpleName() + " forceUpdateAllProjectsOrFindAllAvailablePomFiles");
        MavenProjectsManager.getInstance((Project)project).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
        MavenUtil.invokeLater((Project)project, (ModalityState)ModalityState.nonModal(), () -> MavenKotlinModuleBuilderHelper.configure$lambda$1(pom, project, this));
    }

    private final Properties getConditions(Project project) {
        Properties conditions = new Properties();
        conditions.setProperty("KOTLIN_PLUGIN_WIZARD_VERSION", this.kotlinPluginWizardVersion);
        conditions.setProperty("MAVEN_SUREFIRE_PLUGIN_VERSION", Versions.MAVEN_PLUGINS.INSTANCE.getSUREFIRE().getText());
        conditions.setProperty("MAVEN_FAILSAFE_PLUGIN_VERSION", Versions.MAVEN_PLUGINS.INSTANCE.getFAILSAFE().getText());
        conditions.setProperty("MAVEN_CODEHAUS_MOJO_EXEC_PLUGIN_VERSION", Versions.MAVEN_PLUGINS.INSTANCE.getCODEHAUS_MOJO_EXEC().getText());
        conditions.setProperty("JUNIT_JUPITER_VERSION", Versions.INSTANCE.getJUNIT5().getText());
        conditions.setProperty("MAVEN_CENTRAL_REPOSITORY_ID", DefaultRepository.Companion.getMAVEN_CENTRAL().getIdForMaven());
        conditions.setProperty("MAVEN_CENTRAL_REPOSITORY_URL", DefaultRepository.Companion.getMAVEN_CENTRAL().getUrl());
        conditions.setProperty("INHERIT_MAVEN_KOTLIN_PLUGIN_VERSION", String.valueOf(this.findBuildPluginInRootPom(project, "org.jetbrains.kotlin", "kotlin-maven-plugin")));
        conditions.setProperty("INHERIT_MAVEN_SUREFIRE_PLUGIN_VERSION", String.valueOf(this.findBuildPluginInRootPom(project, null, "maven-surefire-plugin")));
        conditions.setProperty("INHERIT_MAVEN_FAILSAFE_PLUGIN_VERSION", String.valueOf(this.findBuildPluginInRootPom(project, null, "maven-failsafe-plugin")));
        conditions.setProperty("INHERIT_CODEHAUS_MOJO_EXEC_PLUGIN_VERSION", String.valueOf(this.findBuildPluginInRootPom(project, "org.codehaus.mojo", "exec-maven-plugin")));
        return conditions;
    }

    private final boolean findBuildPluginInRootPom(Project project, String groupId, String artifactId) {
        MavenProject mavenProject = this.getMyAggregatorProject();
        if (mavenProject == null || (mavenProject = mavenProject.getFile()) == null) {
            return false;
        }
        MavenProject aggregatorProjectFile = mavenProject;
        MavenDomProjectModel model2 = MavenDomUtil.getMavenDomProjectModel((Project)project, (VirtualFile)aggregatorProjectFile);
        if (model2 != null) {
            boolean bl;
            block5: {
                List list2 = model2.getBuild().getPlugins().getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPlugins(...)");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MavenDomPlugin it = (MavenDomPlugin)element$iv;
                        boolean bl2 = false;
                        String string = (String)it.getGroupId().getValue();
                        if (!((string != null ? string.equals(groupId) : true) && Intrinsics.areEqual((Object)it.getArtifactId().getValue(), (Object)artifactId))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final VirtualFile configure$lambda$0(Project $project, VirtualFile $root, MavenKotlinModuleBuilderHelper this$0, boolean $isInteractive) {
        GitSilentFileAdder gitSilentFileAdder = GitSilentFileAdderProvider.create((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)gitSilentFileAdder, (String)"create(...)");
        GitSilentFileAdder vcsFileAdder = gitSilentFileAdder;
        VirtualFile file = null;
        try {
            try {
                VirtualFile virtualFile = file = $root.findChild("pom.xml");
                if (virtualFile != null) {
                    virtualFile.delete((Object)this$0);
                }
                file = $root.createChildData((Object)this$0, "pom.xml");
                vcsFileAdder.markFileForAdding(file);
                MavenUtil.runOrApplyMavenProjectFileTemplate((Project)$project, (VirtualFile)file, (MavenId)this$0.getMyProjectId(), null, null, (Properties)new Properties(), (Properties)this$0.getConditions($project), (String)"Maven Kotlin Project.xml", (boolean)$isInteractive);
            }
            catch (IOException e) {
                MavenModuleBuilderHelper.showError((Project)$project, (Throwable)e);
                VirtualFile virtualFile = file;
                vcsFileAdder.finish();
                return virtualFile;
            }
            this$0.updateProjectPom($project, file);
        }
        finally {
            vcsFileAdder.finish();
        }
        if (this$0.getMyAggregatorProject() != null) {
            this$0.setPomPackagingForAggregatorProject($project, file);
        }
        return file;
    }

    private static final void configure$lambda$1(VirtualFile $pom, Project $project, MavenKotlinModuleBuilderHelper this$0) {
        if (!$pom.isValid()) {
            MavenModuleBuilderHelper.showError((Project)$project, (Throwable)new RuntimeException("Project is not valid"));
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
        fileEditorManager.openFile($pom);
        for (String path2 : this$0.filesToOpen) {
            VirtualFile virtualFile;
            Path path3 = Path.of(this$0.outputDirectory, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
            if (VirtualFileUtil.refreshAndFindVirtualFile((Path)NioPathUtil.getResolvedPath((Path)path3, (String)path2)) == null) continue;
            fileEditorManager.openFile(virtualFile);
        }
    }

    static {
        Logger logger = Logger.getInstance(MavenKotlinModuleBuilderHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/maven/MavenKotlinModuleBuilderHelper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.project-wizard.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

