/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.JavaCodeInsightTestCase;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.JavaExpectedHighlightingData;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.LightQuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.ExternalAnnotatorsFilter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.StartupActivityTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlSchemaProvider;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DaemonAnalyzerTestCase
extends JavaCodeInsightTestCase {
    private VirtualFileFilter myVirtualFileFilter = new FileTreeAccessFilter();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LocalInspectionTool[] tools = this.configureLocalInspectionTools();
        InspectionsKt.configureInspections((InspectionProfileEntry[])tools, this.getProject(), this.getTestRootDisposable());
        DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
        daemonCodeAnalyzer.prepareForTest();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
        if (this.isStressTest()) {
            IntentionManager.getInstance().getAvailableIntentions();
            PathManagerEx.getTestDataPath();
            ReferenceProvidersRegistry.getInstance();
            InjectedLanguageManager.getInstance((Project)this.getProject());
            LanguageAnnotators.INSTANCE.allForLanguage((Language)JavaLanguage.INSTANCE);
            LanguageAnnotators.INSTANCE.allForLanguage((Language)XMLLanguage.INSTANCE);
            ProblemHighlightFilter.EP_NAME.getExtensions();
            ImplicitUsageProvider.EP_NAME.getExtensionList();
            XmlSchemaProvider.EP_NAME.getExtensionList();
            XmlFileNSInfoProvider.EP_NAME.getExtensionList();
            ExternalAnnotatorsFilter.EXTENSION_POINT_NAME.getExtensionList();
            IndexPatternBuilder.EP_NAME.getExtensionList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            Project project;
            DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings = (DaemonCodeAnalyzerSettings)ApplicationManager.getApplication().getServiceIfCreated(DaemonCodeAnalyzerSettings.class);
            if (daemonCodeAnalyzerSettings != null) {
                daemonCodeAnalyzerSettings.setImportHintEnabled(true);
            }
            if ((project = this.getProject()) != null) {
                DaemonCodeAnalyzer daemonCodeAnalyzer;
                StartupManager startupManager = (StartupManager)project.getServiceIfCreated(StartupManager.class);
                if (startupManager != null) {
                    StartupActivityTestUtil.waitForProjectActivitiesToComplete(project);
                    ((StartupManagerImpl)startupManager).checkCleared();
                }
                if ((daemonCodeAnalyzer = (DaemonCodeAnalyzer)project.getServiceIfCreated(DaemonCodeAnalyzer.class)) != null) {
                    ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).cleanupAfterTest();
                }
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(0);
        }
        ((CoreProgressManager)ProgressManager.getInstance()).suppressAllDeprioritizationsDuringLongTestsExecutionIn(() -> {
            super.runTestRunnable(testRunnable);
            return null;
        });
    }

    protected final void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(1);
        }
        InspectionsKt.enableInspectionTool(this.getProject(), tool, this.getTestRootDisposable());
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        if (tools == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(2);
        }
        InspectionsKt.enableInspectionTools(this.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void disableInspectionTool(@NotNull String shortName) {
        InspectionProfileImpl profile;
        if (shortName == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(3);
        }
        if ((profile = InspectionProjectProfileManager.getInstance((Project)this.getProject()).getCurrentProfile()).getInspectionTool(shortName, this.getProject()) != null) {
            profile.setToolEnabled(shortName, false);
        }
    }

    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    protected static LocalInspectionTool[] createLocalInspectionTools(InspectionToolProvider ... provider) {
        ArrayList<LocalInspectionTool> result = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider toolProvider : provider) {
            for (Class aClass : toolProvider.getInspectionClasses()) {
                try {
                    LocalInspectionTool tool = (LocalInspectionTool)InspectionTestUtil.instantiateTool(aClass);
                    result.add(tool);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return result.toArray(LocalInspectionTool.EMPTY_ARRAY);
    }

    protected void doTest(@NonNls @NotNull String filePath, boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) throws Exception {
        if (filePath == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(4);
        }
        this.configureByFile(filePath);
        this.doDoTest(checkWarnings, checkInfos, checkWeakWarnings);
    }

    protected void doTest(@NonNls @NotNull String filePath, boolean checkWarnings, boolean checkInfos) throws Exception {
        if (filePath == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(5);
        }
        this.doTest(filePath, checkWarnings, checkInfos, false);
    }

    protected void doTest(@NonNls @NotNull String filePath, @NonNls String projectRoot, boolean checkWarnings, boolean checkInfos) throws Exception {
        if (filePath == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(6);
        }
        this.configureByFile(filePath, projectRoot);
        this.doDoTest(checkWarnings, checkInfos);
    }

    @NotNull
    protected HighlightTestInfo testFile(String ... filePath) {
        if (filePath == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(7);
        }
        return new HighlightTestInfo(this.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                try {
                    DaemonAnalyzerTestCase.this.configureByFiles(this.projectRoot, this.filePaths);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                JavaExpectedHighlightingData data = new JavaExpectedHighlightingData(DaemonAnalyzerTestCase.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                DaemonAnalyzerTestCase.this.checkHighlighting(data);
                return this;
            }
        };
    }

    protected void doTest(@NotNull VirtualFile vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        if (vFile == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(8);
        }
        this.doTest(new VirtualFile[]{vFile}, checkWarnings, checkInfos);
    }

    protected void doTest(VirtualFile @NotNull [] vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        if (vFile == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(9);
        }
        this.configureByFiles(null, vFile);
        this.doDoTest(checkWarnings, checkInfos);
    }

    protected void doTest(boolean checkWarnings, boolean checkInfos, String ... files) throws Exception {
        if (files == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(10);
        }
        this.configureByFiles(null, files);
        this.doDoTest(checkWarnings, checkInfos);
    }

    @NotNull
    protected Collection<HighlightInfo> doDoTest(boolean checkWarnings, boolean checkInfos) {
        Collection<HighlightInfo> collection = this.doDoTest(checkWarnings, checkInfos, false);
        if (collection == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(11);
        }
        return collection;
    }

    protected Collection<HighlightInfo> doDoTest(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return ContainerUtil.filter(this.checkHighlighting(new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos)), info -> info.getSeverity() == HighlightSeverity.INFORMATION && checkInfos || info.getSeverity() == HighlightSeverity.WARNING && checkWarnings || info.getSeverity() == HighlightSeverity.WEAK_WARNING && checkWeakWarnings || info.getSeverity().compareTo(HighlightSeverity.WARNING) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Collection<HighlightInfo> checkHighlighting(@NotNull ExpectedHighlightingData data) {
        if (data == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(12);
        }
        data.init();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(this.myVirtualFileFilter, this.getTestRootDisposable());
        List<HighlightInfo> infos = this.doHighlighting();
        String text = this.myEditor.getDocument().getText();
        this.doCheckResult(data, infos, text);
        List<HighlightInfo> list = infos;
        List<HighlightInfo> list2 = list;
        if (list2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(13);
        }
        return list2;
        finally {
            PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.getTestRootDisposable());
        }
    }

    protected void doCheckResult(@NotNull ExpectedHighlightingData data, @NotNull Collection<? extends HighlightInfo> infos, @NotNull String text) {
        if (data == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(14);
        }
        if (infos == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(15);
        }
        if (text == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(16);
        }
        PsiFile file2 = this.getFile();
        ActionUtil.underModalProgress((Project)this.myProject, (String)"", () -> {
            data.checkLineMarkers(file2, DaemonCodeAnalyzerImpl.getLineMarkers((Document)this.getDocument(file2), (Project)this.getProject()), text);
            return null;
        });
        data.checkResult(file2, infos, text);
    }

    @Override
    protected Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(17);
        }
        if (this.myVirtualFileFilter instanceof FileTreeAccessFilter) {
            this.allowTreeAccessForFile(file2);
        }
        return super.createEditor(file2);
    }

    protected void setVirtualFileFilter(@NotNull VirtualFileFilter filter) {
        if (filter == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(18);
        }
        this.myVirtualFileFilter = filter;
    }

    protected void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(19);
        }
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file2);
    }

    protected void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    @NotNull
    protected final List<HighlightInfo> highlightErrors() {
        return this.doHighlighting(HighlightSeverity.ERROR);
    }

    @NotNull
    protected final List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minSeverity) {
        if (minSeverity == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(20);
        }
        return DaemonAnalyzerTestCase.filter(this.doHighlighting(), minSeverity);
    }

    @NotNull
    protected final List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        IntArrayList toIgnore = new IntArrayList();
        if (!this.doTestLineMarkers()) {
            toIgnore.add(11);
            toIgnore.add(13);
        }
        if (!this.doExternalValidation()) {
            toIgnore.add(8);
        }
        if (this.forceExternalValidation()) {
            toIgnore.add(11);
            toIgnore.add(13);
            toIgnore.add(7);
            toIgnore.add(3);
            toIgnore.add(4);
        }
        boolean canChange = this.canChangeDocumentDuringHighlighting();
        List<HighlightInfo> infos = CodeInsightTestFixtureImpl.instantiateAndRun(this.getFile(), this.getEditor(), toIgnore.toIntArray(), canChange);
        if (!canChange) {
            Document document = this.getDocument(this.getFile());
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject);
            daemonCodeAnalyzer.getFileStatusMap().assertAllDirtyScopesAreNull(document);
        }
        List<HighlightInfo> list = infos;
        if (list == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(21);
        }
        return list;
    }

    private boolean canChangeDocumentDuringHighlighting() {
        return this.annotatedWith(CanChangeDocumentDuringHighlighting.class);
    }

    @NotNull
    public static List<HighlightInfo> filter(@NotNull List<? extends HighlightInfo> infos, @NotNull HighlightSeverity minSeverity) {
        if (infos == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(22);
        }
        if (minSeverity == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(23);
        }
        List list = ContainerUtil.filter(infos, info -> info.getSeverity().compareTo(minSeverity) >= 0);
        if (list == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(24);
        }
        return list;
    }

    protected boolean doTestLineMarkers() {
        return false;
    }

    protected boolean doExternalValidation() {
        return true;
    }

    protected boolean forceExternalValidation() {
        return false;
    }

    protected static void findAndInvokeIntentionAction(@NotNull Collection<? extends HighlightInfo> infos, @NotNull String intentionActionName, @NotNull Editor editor2, @NotNull PsiFile file2) {
        List<IntentionAction> actions;
        IntentionAction intentionAction;
        if (infos == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(25);
        }
        if (intentionActionName == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(26);
        }
        if (editor2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(28);
        }
        if ((intentionAction = LightQuickFixTestCase.findActionWithText(actions = DaemonAnalyzerTestCase.getIntentionActions(infos, editor2, file2), intentionActionName)) == null) {
            DaemonAnalyzerTestCase.fail((String)("Could not find action '" + intentionActionName + "'.\nAvailable actions: [" + StringUtil.join((Collection)ContainerUtil.map(actions, c -> c.getText()), (String)", ") + "]\nHighlightInfos: [" + StringUtil.join(infos, (String)", ") + "]"));
        }
        CodeInsightTestFixtureImpl.invokeIntention(intentionAction, file2, editor2);
    }

    @Nullable
    protected static IntentionAction findIntentionAction(@NotNull Collection<? extends HighlightInfo> infos, @NotNull String intentionActionName, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (infos == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(29);
        }
        if (intentionActionName == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(30);
        }
        if (editor2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(31);
        }
        if (file2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(32);
        }
        List<IntentionAction> actions = DaemonAnalyzerTestCase.getIntentionActions(infos, editor2, file2);
        return LightQuickFixTestCase.findActionWithText(actions, intentionActionName);
    }

    @NotNull
    protected static List<IntentionAction> getIntentionActions(@NotNull Collection<? extends HighlightInfo> infos, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (infos == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(33);
        }
        if (editor2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(34);
        }
        if (file2 == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(35);
        }
        List<IntentionAction> actions = LightQuickFixTestCase.getAvailableActions(editor2, file2);
        ArrayList quickFixActions = new ArrayList();
        for (HighlightInfo highlightInfo : infos) {
            highlightInfo.findRegisteredQuickFix((descriptor, range) -> {
                IntentionAction action = descriptor.getAction();
                if (!actions.contains(action) && action.isAvailable(file2.getProject(), editor2, file2)) {
                    quickFixActions.add(action);
                }
                return null;
            });
        }
        List list = ContainerUtil.concat(actions, quickFixActions);
        if (list == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(36);
        }
        return list;
    }

    public void checkHighlighting(Editor editor2, boolean checkWarnings, boolean checkInfos) {
        this.setActiveEditor(editor2);
        this.doDoTest(checkWarnings, checkInfos);
    }

    @NotNull
    public PsiClass createClass(@NotNull @org.intellij.lang.annotations.Language(value="JAVA") String text) throws IOException {
        if (text == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(37);
        }
        VirtualFile classVFile = (VirtualFile)WriteCommandAction.writeCommandAction((Project)this.getProject()).compute(() -> {
            File dir;
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getProject());
            PsiJavaFile javaFile = (PsiJavaFile)factory.createFileFromText("a.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text);
            String qname = javaFile.getClasses()[0].getQualifiedName();
            DaemonAnalyzerTestCase.assertNotNull((Object)qname);
            VirtualFile[] files = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots();
            if (files.length > 0) {
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)files[0]);
            } else {
                dir = this.createTempDirectory();
                VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
                this.addSourceContentToRoots(this.myModule, vDir);
            }
            File file2 = new File(dir, qname.replace('.', '/') + ".java");
            FileUtil.createIfDoesntExist((File)file2);
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(file2.getCanonicalPath().replace(File.separatorChar, '/'));
            DaemonAnalyzerTestCase.assertNotNull((Object)vFile);
            VfsUtil.saveText((VirtualFile)vFile, (String)text);
            return vFile;
        });
        IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
        PsiJavaFile psiFile = (PsiJavaFile)this.myPsiManager.findFile(classVFile);
        DaemonAnalyzerTestCase.assertNotNull((Object)psiFile);
        PsiClass psiClass = psiFile.getClasses()[0];
        if (psiClass == null) {
            DaemonAnalyzerTestCase.$$$reportNull$$$0(38);
        }
        return psiClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 21, 24, 36, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 13: 
            case 21: 
            case 24: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/DaemonAnalyzerTestCase";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: 
            case 22: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: 
            case 19: 
            case 28: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionActionName";
                break;
            }
            case 27: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/DaemonAnalyzerTestCase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doDoTest";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "checkHighlighting";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActions";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTool";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTools";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "disableInspectionTool";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "testFile";
                break;
            }
            case 11: 
            case 13: 
            case 21: 
            case 24: 
            case 36: 
            case 38: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkHighlighting";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCheckResult";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setVirtualFileFilter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "allowTreeAccessForFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doHighlighting";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findAndInvokeIntentionAction";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findIntentionAction";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionActions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 21, 24, 36, 38 -> new IllegalStateException(string);
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface CanChangeDocumentDuringHighlighting {
    }
}

