/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.lang.Language;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileTypeManager
extends FileTypeManagerEx {
    private final FileType fileType;

    public MockFileTypeManager(FileType fileType) {
        this.fileType = fileType;
    }

    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable) {
        if (file2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            MockFileTypeManager.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public String getIgnoredFilesList() {
        throw new IncorrectOperationException();
    }

    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            MockFileTypeManager.$$$reportNull$$$0(2);
        }
    }

    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list) {
        if (list == null) {
            MockFileTypeManager.$$$reportNull$$$0(3);
        }
        return false;
    }

    public void save() {
    }

    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            MockFileTypeManager.$$$reportNull$$$0(4);
        }
        return "";
    }

    public void fireFileTypesChanged() {
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            MockFileTypeManager.$$$reportNull$$$0(5);
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(6);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(7);
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            MockFileTypeManager.$$$reportNull$$$0(9);
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(10);
        }
        return fileType;
    }

    public FileType @NotNull [] getRegisteredFileTypes() {
        if (FileType.EMPTY_ARRAY == null) {
            MockFileTypeManager.$$$reportNull$$$0(11);
        }
        return FileType.EMPTY_ARRAY;
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            MockFileTypeManager.$$$reportNull$$$0(12);
        }
        return false;
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(13);
        }
        return false;
    }

    public void fireBeforeFileTypesChanged() {
    }

    public void makeFileTypesChange(@NotNull String message, @NotNull Runnable command) {
        if (message == null) {
            MockFileTypeManager.$$$reportNull$$$0(14);
        }
        if (command == null) {
            MockFileTypeManager.$$$reportNull$$$0(15);
        }
        command.run();
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(16);
        }
        if (project == null) {
            MockFileTypeManager.$$$reportNull$$$0(17);
        }
        return file2.getFileType();
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(18);
        }
        List<FileNameMatcher> list = Collections.emptyList();
        if (list == null) {
            MockFileTypeManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(20);
        }
        if (matcher == null) {
            MockFileTypeManager.$$$reportNull$$$0(21);
        }
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(22);
        }
        if (matcher == null) {
            MockFileTypeManager.$$$reportNull$$$0(23);
        }
    }

    @NotNull
    public FileType getStdFileType(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            MockFileTypeManager.$$$reportNull$$$0(24);
        }
        if ("ARCHIVE".equals(fileTypeName)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(25);
            }
            return fileType;
        }
        if ("PLAIN_TEXT".equals(fileTypeName)) {
            PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
            if (plainTextFileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(26);
            }
            return plainTextFileType;
        }
        if ("CLASS".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaClassFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(27);
            }
            return fileType;
        }
        if ("JAVA".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(28);
            }
            return fileType;
        }
        if ("XML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XmlFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(29);
            }
            return fileType;
        }
        if ("DTD".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.DTDFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(30);
            }
            return fileType;
        }
        if ("JSP".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.NewJspFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(31);
            }
            return fileType;
        }
        if ("JSPX".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JspxFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(32);
            }
            return fileType;
        }
        if ("HTML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.HtmlFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(33);
            }
            return fileType;
        }
        if ("XHTML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XHtmlFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(34);
            }
            return fileType;
        }
        if ("JavaScript".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.javascript.JavaScriptFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(35);
            }
            return fileType;
        }
        if ("Properties".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.properties.PropertiesFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(36);
            }
            return fileType;
        }
        if ("GUI_DESIGNER_FORM".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.uiDesigner.GuiFormFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(37);
            }
            return fileType;
        }
        return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase(Locale.ENGLISH));
    }

    private static FileType loadFileTypeSafe(String className, String fileTypeName) {
        try {
            return (FileType)Class.forName(className).getField("INSTANCE").get(null);
        }
        catch (Exception ignored) {
            return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase(Locale.ENGLISH));
        }
    }

    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            MockFileTypeManager.$$$reportNull$$$0(38);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 10, 11, 19, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockFileTypeManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockFileTypeManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "freezeFileTypeTemporarilyIn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFilesListEqualToCurrent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "makeFileTypesChange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getStdFileType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 10, 11, 19, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 -> new IllegalStateException(string);
        };
    }
}

