/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.diff;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.statistics.FusAwareActionGroup;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.callusage.FlameGraphComponent;
import com.intellij.profiler.ui.diff.DifferentialFlameGraphModel;
import com.intellij.profiler.ui.diff.DifferentialFlameGraphRenderer;
import com.intellij.profiler.ui.diff.DifferentialFlameGraphType;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J(\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphTypeManager;", "", "flameGraphComponent", "Lcom/intellij/profiler/ui/callusage/FlameGraphComponent;", "baseRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/ui/callusage/FlameGraphComponent;Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "flameGraphTypes", "", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphType;", "initialFlameGraphType", "selectedFlameGraphType", "createRenderer", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphRenderer;", "createModel", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphModel;", "model", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "createActions", "Lcom/intellij/profiler/statistics/FusAwareActionGroup;", "updateFlameGraphType", "", "panel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "type", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nDifferentialFlameGraphTypeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DifferentialFlameGraphTypeManager.kt\ncom/intellij/profiler/ui/diff/DifferentialFlameGraphTypeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1863#2,2:72\n*S KotlinDebug\n*F\n+ 1 DifferentialFlameGraphTypeManager.kt\ncom/intellij/profiler/ui/diff/DifferentialFlameGraphTypeManager\n*L\n41#1:72,2\n*E\n"})
public final class DifferentialFlameGraphTypeManager {
    @NotNull
    private final FlameGraphComponent flameGraphComponent;
    @NotNull
    private final BaseCallStackElementRenderer baseRenderer;
    @NotNull
    private final ValueMetric metric;
    @NotNull
    private final List<DifferentialFlameGraphType> flameGraphTypes;
    @NotNull
    private final DifferentialFlameGraphType initialFlameGraphType;
    @NotNull
    private DifferentialFlameGraphType selectedFlameGraphType;

    public DifferentialFlameGraphTypeManager(@NotNull FlameGraphComponent flameGraphComponent, @NotNull BaseCallStackElementRenderer baseRenderer, @NotNull ValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)((Object)flameGraphComponent), (String)"flameGraphComponent");
        Intrinsics.checkNotNullParameter((Object)baseRenderer, (String)"baseRenderer");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.flameGraphComponent = flameGraphComponent;
        this.baseRenderer = baseRenderer;
        this.metric = metric;
        Object[] objectArray = new DifferentialFlameGraphType[]{new DifferentialFlameGraphType.BaselineTreeBased(), new DifferentialFlameGraphType.NewTreeBased(), new DifferentialFlameGraphType.DifferenceBased(), new DifferentialFlameGraphType.ShowDiffToTheRight()};
        this.flameGraphTypes = CollectionsKt.listOf((Object[])objectArray);
        this.selectedFlameGraphType = this.initialFlameGraphType = (DifferentialFlameGraphType)CollectionsKt.last(this.flameGraphTypes);
    }

    @NotNull
    public final DifferentialFlameGraphRenderer createRenderer() {
        return new DifferentialFlameGraphRenderer(this.initialFlameGraphType.getCellRenderer(), this.baseRenderer, this.metric);
    }

    @NotNull
    public final DifferentialFlameGraphModel createModel(@NotNull CallTreeNode<? extends BaseCallStackElement> model2) {
        DifferentialFlameGraphModel differentialFlameGraphModel;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        DifferentialFlameGraphModel $this$createModel_u24lambda_u240 = differentialFlameGraphModel = new DifferentialFlameGraphModel(model2);
        boolean bl = false;
        $this$createModel_u24lambda_u240.updateFractionRule(this.initialFlameGraphType.getFractionRule());
        return differentialFlameGraphModel;
    }

    @NotNull
    public final FusAwareActionGroup createActions() {
        FusAwareActionGroup fusAwareActionGroup;
        FusAwareActionGroup $this$createActions_u24lambda_u242 = fusAwareActionGroup = new FusAwareActionGroup(ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.DIFF_FG_SELECT_TYPE, null, 2, null);
        boolean bl = false;
        $this$createActions_u24lambda_u242.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        $this$createActions_u24lambda_u242.getTemplatePresentation().setText(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.diff.select.type", new Object[0]));
        $this$createActions_u24lambda_u242.setPopup(true);
        Iterable $this$forEach$iv = this.flameGraphTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DifferentialFlameGraphType type = (DifferentialFlameGraphType)element$iv;
            boolean bl2 = false;
            String string = type.getName();
            $this$createActions_u24lambda_u242.add((AnAction)new DumbAwareToggleAction(type, this, string){
                final /* synthetic */ DifferentialFlameGraphType $type;
                final /* synthetic */ DifferentialFlameGraphTypeManager this$0;
                {
                    this.$type = $type;
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public boolean isSelected(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    return this.$type == DifferentialFlameGraphTypeManager.access$getSelectedFlameGraphType$p(this.this$0);
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!state && this.isSelected(e)) {
                        return;
                    }
                    ProfilerUsageTriggerCollector.INSTANCE.logDiffFlameGraphTypeChanged(e.getProject(), this.$type);
                    DifferentialFlameGraphTypeManager.access$setSelectedFlameGraphType$p(this.this$0, this.$type);
                    DifferentialFlameGraphTypeManager.access$updateFlameGraphType(this.this$0, DifferentialFlameGraphTypeManager.access$getFlameGraphComponent$p(this.this$0).getFlameGraphPanel(), this.$type);
                }

                public ActionUpdateThread getActionUpdateThread() {
                    return ActionUpdateThread.BGT;
                }
            });
        }
        return fusAwareActionGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFlameGraphType(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> panel2, DifferentialFlameGraphType type) {
        DifferentialFlameGraphModel model2;
        panel2.setRenderer(new DifferentialFlameGraphRenderer(type.getCellRenderer(), this.baseRenderer, this.metric));
        DifferentialFlameGraphModel differentialFlameGraphModel = panel2.getModel();
        DifferentialFlameGraphModel differentialFlameGraphModel2 = model2 = differentialFlameGraphModel instanceof DifferentialFlameGraphModel ? (DifferentialFlameGraphModel)differentialFlameGraphModel : null;
        if (model2 != null) {
            void $this$updateFlameGraphType_u24lambda_u243;
            DifferentialFlameGraphModel differentialFlameGraphModel3 = differentialFlameGraphModel = model2;
            FlameGraphPanel<CallTreeNode<BaseCallStackElement>> flameGraphPanel2 = panel2;
            boolean bl = false;
            $this$updateFlameGraphType_u24lambda_u243.updateFractionRule(type.getFractionRule());
            flameGraphPanel2.setModel(differentialFlameGraphModel);
        }
    }

    public static final /* synthetic */ DifferentialFlameGraphType access$getSelectedFlameGraphType$p(DifferentialFlameGraphTypeManager $this) {
        return $this.selectedFlameGraphType;
    }

    public static final /* synthetic */ void access$setSelectedFlameGraphType$p(DifferentialFlameGraphTypeManager $this, DifferentialFlameGraphType differentialFlameGraphType) {
        $this.selectedFlameGraphType = differentialFlameGraphType;
    }

    public static final /* synthetic */ void access$updateFlameGraphType(DifferentialFlameGraphTypeManager $this, FlameGraphPanel panel2, DifferentialFlameGraphType type) {
        $this.updateFlameGraphType(panel2, type);
    }

    public static final /* synthetic */ FlameGraphComponent access$getFlameGraphComponent$p(DifferentialFlameGraphTypeManager $this) {
        return $this.flameGraphComponent;
    }
}

