/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.model.task.event.TestAssertionFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.util.text.StringKt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/events/GradleXmlTestEventConverter;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "convertTestDescriptor", "Lcom/intellij/openapi/externalSystem/model/task/event/TestOperationDescriptor;", "eventTime", "", "eventXml", "Lorg/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXmlView;", "convertOperationResult", "Lcom/intellij/openapi/externalSystem/model/task/event/OperationResult;", "decode", "", "s", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleXmlTestEventConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleXmlTestEventConverter.kt\norg/jetbrains/plugins/gradle/execution/test/runner/events/GradleXmlTestEventConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n14#2:81\n*S KotlinDebug\n*F\n+ 1 GradleXmlTestEventConverter.kt\norg/jetbrains/plugins/gradle/execution/test/runner/events/GradleXmlTestEventConverter\n*L\n12#1:81\n*E\n"})
public final class GradleXmlTestEventConverter {
    @NotNull
    public static final GradleXmlTestEventConverter INSTANCE = new GradleXmlTestEventConverter();
    @NotNull
    private static final Logger LOG;

    private GradleXmlTestEventConverter() {
    }

    @JvmStatic
    @NotNull
    public static final TestOperationDescriptor convertTestDescriptor(long eventTime, @NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException, NumberFormatException {
        Intrinsics.checkNotNullParameter((Object)eventXml, (String)"eventXml");
        String string = eventXml.getTestClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTestClassName(...)");
        String suiteName = string;
        String string2 = eventXml.getTestClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTestClassName(...)");
        String className = string2;
        String string3 = eventXml.getTestName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTestName(...)");
        String methodName = string3;
        String string4 = eventXml.getTestDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getTestDisplayName(...)");
        String displayName = string4;
        return new TestOperationDescriptor(displayName, eventTime, suiteName, className, methodName);
    }

    @JvmStatic
    @NotNull
    public static final OperationResult convertOperationResult(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException, NumberFormatException {
        Intrinsics.checkNotNullParameter((Object)eventXml, (String)"eventXml");
        String string = eventXml.getEventTestResultStartTime();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEventTestResultStartTime(...)");
        long startTime = Long.parseLong(string);
        String string2 = eventXml.getEventTestResultEndTime();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEventTestResultEndTime(...)");
        long endTime = Long.parseLong(string2);
        TestEventResult resultType = TestEventResult.fromValue(eventXml.getTestEventResultType());
        if (resultType == TestEventResult.SUCCESS) {
            return (OperationResult)new SuccessResult(startTime, endTime, false);
        }
        if (resultType == TestEventResult.SKIPPED) {
            return (OperationResult)new SkippedResult(startTime, endTime);
        }
        if (resultType == TestEventResult.FAILURE) {
            String string3 = eventXml.getEventTestResultFailureType();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getEventTestResultFailureType(...)");
            String failureType = string3;
            String string4 = eventXml.getEventTestResultErrorMsg();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getEventTestResultErrorMsg(...)");
            String message = GradleXmlTestEventConverter.decode(string4);
            String string5 = eventXml.getEventTestResultExceptionName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getEventTestResultExceptionName(...)");
            String exceptionName = GradleXmlTestEventConverter.decode(string5);
            String string6 = eventXml.getEventTestResultStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getEventTestResultStackTrace(...)");
            String stackTrace = GradleXmlTestEventConverter.decode(string6);
            String string7 = eventXml.getTestEventTestDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getTestEventTestDescription(...)");
            String description = GradleXmlTestEventConverter.decode(string7);
            if (Intrinsics.areEqual((Object)"comparison", (Object)failureType)) {
                String string8 = eventXml.getEventTestResultActual();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getEventTestResultActual(...)");
                String actualText = GradleXmlTestEventConverter.decode(string8);
                String string9 = eventXml.getEventTestResultExpected();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getEventTestResultExpected(...)");
                String expectedText = GradleXmlTestEventConverter.decode(string9);
                String string10 = eventXml.getEventTestResultFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getEventTestResultFilePath(...)");
                String expectedFilePath = StringKt.nullize$default((String)GradleXmlTestEventConverter.decode(string10), (boolean)false, (int)1, null);
                String string11 = eventXml.getEventTestResultActualFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getEventTestResultActualFilePath(...)");
                String actualFilePath = StringKt.nullize$default((String)GradleXmlTestEventConverter.decode(string11), (boolean)false, (int)1, null);
                TestFailure failure = ((CharSequence)expectedText).length() == 0 && ((CharSequence)actualText).length() == 0 ? new TestFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), false) : (TestFailure)new TestAssertionFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), expectedText, actualText, expectedFilePath, actualFilePath);
                return (OperationResult)new FailureResult(startTime, endTime, CollectionsKt.listOf((Object)failure));
            }
            if (Intrinsics.areEqual((Object)"assertionFailed", (Object)failureType)) {
                TestFailure failure = new TestFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), false);
                return (OperationResult)new FailureResult(startTime, endTime, CollectionsKt.listOf((Object)failure));
            }
            if (Intrinsics.areEqual((Object)"error", (Object)failureType)) {
                TestFailure failure = new TestFailure(exceptionName, message, stackTrace, description, CollectionsKt.emptyList(), true);
                return (OperationResult)new FailureResult(startTime, endTime, CollectionsKt.listOf((Object)failure));
            }
            LOG.error("Undefined test failure type: " + failureType);
            Failure failure = new Failure(message, stackTrace, CollectionsKt.emptyList());
            return (OperationResult)new FailureResult(startTime, endTime, CollectionsKt.listOf((Object)failure));
        }
        LOG.error("Undefined test result type: " + resultType);
        return new OperationResult(startTime, endTime);
    }

    @JvmStatic
    @NotNull
    public static final String decode(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] bytes = Base64.getDecoder().decode(s);
        Intrinsics.checkNotNull((Object)bytes);
        byte[] byArray = bytes;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleXmlTestEventConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

