/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageDirectoryCache;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleBuildClasspathManager {
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile List<VirtualFile> allFilesCache;
    @NotNull
    private final AtomicReference<Map<String, List<VirtualFile>>> myClasspathMap;
    @NotNull
    private final Map<String, PackageDirectoryCache> myClassFinderCache;

    public GradleBuildClasspathManager(@NotNull Project project) {
        if (project == null) {
            GradleBuildClasspathManager.$$$reportNull$$$0(0);
        }
        this.allFilesCache = null;
        this.myClasspathMap = new AtomicReference(new HashMap());
        this.myClassFinderCache = ConcurrentFactoryMap.createMap(path -> PackageDirectoryCache.createCache(this.getModuleClasspathEntries((String)path)));
        this.myProject = project;
    }

    @NotNull
    public static GradleBuildClasspathManager getInstance(@NotNull Project project) {
        if (project == null) {
            GradleBuildClasspathManager.$$$reportNull$$$0(1);
        }
        GradleBuildClasspathManager gradleBuildClasspathManager = (GradleBuildClasspathManager)project.getService(GradleBuildClasspathManager.class);
        if (gradleBuildClasspathManager == null) {
            GradleBuildClasspathManager.$$$reportNull$$$0(2);
        }
        return gradleBuildClasspathManager;
    }

    public void reload() {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
        HashMap map = new HashMap();
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        HashMap<String, VirtualFile> localVFCache = new HashMap<String, VirtualFile>();
        for (ExternalProjectBuildClasspathPojo projectBuildClasspathPojo : localSettings.getProjectBuildClasspath().values()) {
            ArrayList projectBuildClasspath = new ArrayList();
            for (String path : projectBuildClasspathPojo.getProjectBuildClasspath()) {
                VirtualFile virtualFile = localVFCache.computeIfAbsent(path, it -> ExternalSystemUtil.findLocalFileByPath((String)it));
                ContainerUtil.addIfNotNull(projectBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
            }
            for (ExternalModuleBuildClasspathPojo moduleBuildClasspathPojo : projectBuildClasspathPojo.getModulesBuildClasspath().values()) {
                ArrayList moduleBuildClasspath = new ArrayList(projectBuildClasspath);
                for (String path : moduleBuildClasspathPojo.getEntries()) {
                    VirtualFile virtualFile = localVFCache.computeIfAbsent(path, it -> ExternalSystemUtil.findLocalFileByPath((String)it));
                    ContainerUtil.addIfNotNull(moduleBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
                }
                map.put(moduleBuildClasspathPojo.getPath(), moduleBuildClasspath);
            }
        }
        this.myClasspathMap.set(map);
        LinkedHashSet<VirtualFile> set = new LinkedHashSet<VirtualFile>();
        for (List<VirtualFile> virtualFiles : this.myClasspathMap.get().values()) {
            set.addAll(virtualFiles);
        }
        this.allFilesCache = new ArrayList<VirtualFile>(set);
        this.myClassFinderCache.clear();
    }

    @NotNull
    public Map<String, PackageDirectoryCache> getClassFinderCache() {
        Map<String, PackageDirectoryCache> map = this.myClassFinderCache;
        if (map == null) {
            GradleBuildClasspathManager.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public List<VirtualFile> getAllClasspathEntries() {
        this.checkRootsValidity(this.allFilesCache);
        if (this.allFilesCache == null) {
            this.reload();
        }
        List<VirtualFile> list = Objects.requireNonNull(this.allFilesCache);
        if (list == null) {
            GradleBuildClasspathManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getModuleClasspathEntries(@NotNull String externalModulePath) {
        if (externalModulePath == null) {
            GradleBuildClasspathManager.$$$reportNull$$$0(5);
        }
        this.checkRootsValidity(this.myClasspathMap.get().get(externalModulePath));
        List<VirtualFile> virtualFiles = this.myClasspathMap.get().get(externalModulePath);
        List<Object> list = virtualFiles == null ? Collections.emptyList() : virtualFiles;
        if (list == null) {
            GradleBuildClasspathManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void checkRootsValidity(@Nullable List<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            return;
        }
        if (!virtualFiles.isEmpty()) {
            for (VirtualFile file : virtualFiles) {
                if (file.isValid()) continue;
                this.reload();
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/GradleBuildClasspathManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFinderCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasspathEntries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleClasspathEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleClasspathEntries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

