/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.execution.Location;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a&\u0010\u0002\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0007\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a(\u0010\t\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u00020\u000bH\u0002\u001a\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u0015H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u000bH\u0002\u001a\f\u0010\u0018\u001a\u00020\u0017*\u00020\u000bH\u0002\u00a8\u0006\u0019"}, d2={"createTestWildcardFilter", "", "createTestFilter", "filter", "className", "methodName", "paramName", "createTestFilterFromPackage", "packageName", "createTestFilterFrom", "psiClass", "Lcom/intellij/psi/PsiClass;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "psiPackage", "Lcom/intellij/psi/PsiPackage;", "location", "Lcom/intellij/execution/Location;", "getRuntimeQualifiedName", "getParents", "", "Lcom/intellij/psi/PsiElement;", "isJunit4ParameterizedClass", "", "isRobolectricParameterizedClass", "intellij.gradle.java"})
@JvmName(name="GradleExecutionSettingsUtil")
@SourceDebugExtension(value={"SMAP\nGradleExecutionSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleExecutionSettingsUtil.kt\norg/jetbrains/plugins/gradle/util/GradleExecutionSettingsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n808#2,11:122\n*S KotlinDebug\n*F\n+ 1 GradleExecutionSettingsUtil.kt\norg/jetbrains/plugins/gradle/util/GradleExecutionSettingsUtil\n*L\n90#1:122,11\n*E\n"})
public final class GradleExecutionSettingsUtil {
    @NotNull
    public static final String createTestWildcardFilter() {
        return "--tests *";
    }

    private static final String createTestFilter(String filter) {
        String escaped = StringsKt.replace$default((String)filter, (char)'\"', (char)'*', (boolean)false, (int)4, null);
        return "--tests \"" + escaped + "\"";
    }

    @VisibleForTesting
    @NotNull
    public static final String createTestFilter(@Nullable String className, @Nullable String methodName, @Nullable String paramName) {
        CharSequence charSequence = className;
        if (charSequence == null || charSequence.length() == 0) {
            return GradleExecutionSettingsUtil.createTestWildcardFilter();
        }
        charSequence = methodName;
        if (charSequence == null || charSequence.length() == 0) {
            return GradleExecutionSettingsUtil.createTestFilter(className);
        }
        String escapedMethod = StringsKt.replace$default((String)methodName, (char)'.', (char)'*', (boolean)false, (int)4, null);
        CharSequence charSequence2 = paramName;
        if (charSequence2 == null || charSequence2.length() == 0) {
            return GradleExecutionSettingsUtil.createTestFilter(className + "." + escapedMethod);
        }
        return GradleExecutionSettingsUtil.createTestFilter(className + "." + escapedMethod + paramName);
    }

    @VisibleForTesting
    @NotNull
    public static final String createTestFilterFromPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (((CharSequence)packageName).length() == 0) {
            return GradleExecutionSettingsUtil.createTestWildcardFilter();
        }
        return GradleExecutionSettingsUtil.createTestFilter(packageName + ".*");
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return GradleExecutionSettingsUtil.createTestFilterFrom(psiClass, null);
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiClass psiClass, @Nullable String methodName) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        String className = GradleExecutionSettingsUtil.getRuntimeQualifiedName(psiClass);
        return GradleExecutionSettingsUtil.createTestFilter(className, methodName, null);
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        PsiClass psiClass = psiMethod.getContainingClass();
        Intrinsics.checkNotNull((Object)psiClass);
        PsiClass psiClass2 = psiClass;
        String string = psiMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodName = string;
        return GradleExecutionSettingsUtil.createTestFilterFrom(psiClass2, methodName);
    }

    @NotNull
    public static final String createTestFilterFrom(@NotNull PsiPackage psiPackage) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        String string = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        String packageName = string;
        return GradleExecutionSettingsUtil.createTestFilterFromPackage(packageName);
    }

    @NotNull
    public static final String createTestFilterFrom(@Nullable Location<?> location, @Nullable PsiClass psiClass, @Nullable PsiMethod psiMethod) {
        PsiClass psiClass2 = psiClass;
        String className = psiClass2 != null ? GradleExecutionSettingsUtil.getRuntimeQualifiedName(psiClass2) : null;
        PsiMethod psiMethod2 = psiMethod;
        String methodName = psiMethod2 != null ? psiMethod2.getName() : null;
        Object parameterName = null;
        if (location instanceof PsiMemberParameterizedLocation) {
            String string = ((PsiMemberParameterizedLocation)location).getParamSetName();
            Object object = parameterName = string != null ? StringKt.nullize$default((String)string, (boolean)false, (int)1, null) : null;
            if (parameterName != null && Intrinsics.areEqual((Object)StringsKt.removeSurrounding((String)parameterName, (CharSequence)"[", (CharSequence)"]"), (Object)parameterName)) {
                parameterName = "[*" + (String)parameterName + "*]";
            }
        } else if (psiClass != null && GradleExecutionSettingsUtil.isJunit4ParameterizedClass(psiClass)) {
            parameterName = "[*]";
        } else if (psiClass != null && GradleExecutionSettingsUtil.isRobolectricParameterizedClass(psiClass)) {
            parameterName = "[*]";
        }
        return GradleExecutionSettingsUtil.createTestFilter(className, methodName, (String)parameterName);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getRuntimeQualifiedName(PsiClass $this$getRuntimeQualifiedName) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = GradleExecutionSettingsUtil.getParents((PsiElement)$this$getRuntimeQualifiedName);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classes = (List)destination$iv$iv;
        StringJoiner joiner = new StringJoiner("$");
        PsiClass rootClass = (PsiClass)CollectionsKt.last((List)classes);
        String string = rootClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        String qualifiedName = string;
        joiner.add(qualifiedName);
        for (PsiClass innerClass : CollectionsKt.asReversed((List)CollectionsKt.dropLast((List)classes, (int)1))) {
            String name;
            if (innerClass.getName() == null) {
                return null;
            }
            joiner.add(name);
        }
        return joiner.toString();
    }

    private static final List<PsiElement> getParents(PsiElement $this$getParents) {
        ArrayList<PsiElement> parents = new ArrayList<PsiElement>();
        for (PsiElement element = $this$getParents; element != null; element = element.getParent()) {
            parents.add(element);
        }
        return parents;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJunit4ParameterizedClass(PsiClass $this$isJunit4ParameterizedClass) {
        PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation((PsiClass)$this$isJunit4ParameterizedClass);
        if (annotation == null) return false;
        String[] stringArray = new String[]{"org.junit.runners.Parameterized"};
        if (!JUnitUtil.isOneOf((PsiAnnotation)annotation, (String[])stringArray)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRobolectricParameterizedClass(PsiClass $this$isRobolectricParameterizedClass) {
        PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation((PsiClass)$this$isRobolectricParameterizedClass);
        if (annotation == null) return false;
        String[] stringArray = new String[]{"org.robolectric.ParameterizedRobolectricTestRunner"};
        if (!JUnitUtil.isOneOf((PsiAnnotation)annotation, (String[])stringArray)) return false;
        return true;
    }
}

