/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class CustomizableThreadFactory
implements ThreadFactory {
    private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private final String threadNamePrefix;
    private final boolean isDaemon;

    public CustomizableThreadFactory(String threadNamePrefix, boolean isDaemon) {
        this.threadNamePrefix = threadNamePrefix;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.defaultThreadFactory.newThread(r);
        if (this.threadNamePrefix != null && !this.threadNamePrefix.isEmpty()) {
            thread.setName(this.threadNamePrefix + thread.getName());
        }
        if (thread.isDaemon() != this.isDaemon) {
            thread.setDaemon(this.isDaemon);
        }
        return thread;
    }
}

