/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.newUsersOnboarding;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingStep;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingBundle;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingDialog;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingExecutor;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingExperiment;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingStatistics;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\u0012J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "currentExecutor", "Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingExecutor;", "currentDialog", "Lcom/intellij/openapi/ui/DialogWrapper;", "value", "", "wasDialogShownDuringIdeSession", "getWasDialogShownDuringIdeSession", "()Z", "showOnboardingDialog", "", "onDialogClosed", "exitCode", "", "shouldShowOnboardingDialog", "startOnboarding", "getSteps", "", "Lkotlin/Pair;", "", "Lcom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingStep;", "getStepsOrder", "Companion", "intellij.platform.ide.newUsersOnboarding"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNewUsersOnboardingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n40#2,3:113\n1611#3,9:116\n1863#3:125\n1864#3:127\n1620#3:128\n1#4:126\n*S KotlinDebug\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService\n*L\n67#1:113,3\n87#1:116,9\n87#1:125\n87#1:127\n87#1:128\n87#1:126\n*E\n"})
public final class NewUsersOnboardingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private NewUsersOnboardingExecutor currentExecutor;
    @Nullable
    private DialogWrapper currentDialog;
    private boolean wasDialogShownDuringIdeSession;
    @NotNull
    private static final String NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY = "NEW_USERS_ONBOARDING_DIALOG_SHOWN";

    public NewUsersOnboardingService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    public final boolean getWasDialogShownDuringIdeSession() {
        return this.wasDialogShownDuringIdeSession;
    }

    public final void showOnboardingDialog() {
        DialogWrapper dialogWrapper = this.currentDialog;
        if (dialogWrapper != null) {
            dialogWrapper.close(2);
        }
        NewUsersOnboardingDialog dialog2 = new NewUsersOnboardingDialog(this.project, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                NewUsersOnboardingService.access$onDialogClosed((NewUsersOnboardingService)this.receiver, p0);
            }
        }));
        this.currentDialog = dialog2;
        dialog2.show();
        this.wasDialogShownDuringIdeSession = true;
        PropertiesComponent.getInstance().setValue(NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY, true);
        NewUsersOnboardingStatistics.INSTANCE.logDialogShown(this.project);
    }

    private final void onDialogClosed(int exitCode) {
        this.currentDialog = null;
        switch (exitCode) {
            case 0: {
                this.startOnboarding();
                NewUsersOnboardingStatistics.INSTANCE.logOnboardingStarted(this.project, NewUsersOnboardingStatistics.OnboardingStartingPlace.DIALOG);
                break;
            }
            case 1: {
                new Notification("newUsersOnboarding", NewUsersOnboardingBundle.INSTANCE.message("notification.text", new Object[0]), NotificationType.INFORMATION).notify(this.project);
                NewUsersOnboardingStatistics.INSTANCE.logDialogSkipPressed(this.project);
            }
        }
    }

    public final boolean shouldShowOnboardingDialog() {
        boolean $i$f$service = false;
        Class<NewUsersOnboardingExperiment> serviceClass$iv = NewUsersOnboardingExperiment.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((NewUsersOnboardingExperiment)object).isEnabled() && !PropertiesComponent.getInstance().getBoolean(NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY) && ConfigImportHelper.isNewUser();
    }

    public final void startOnboarding() {
        NewUsersOnboardingExecutor executor;
        NewUsersOnboardingExecutor newUsersOnboardingExecutor = this.currentExecutor;
        if (newUsersOnboardingExecutor != null) {
            newUsersOnboardingExecutor.finishOnboarding(NewUsersOnboardingStatistics.OnboardingStopReason.INTERRUPTED);
        }
        List<Pair<String, NewUiOnboardingStep>> steps = this.getSteps();
        CoroutineScope childScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"onboarding executor", null, (boolean)false, (int)6, null);
        this.currentExecutor = executor = new NewUsersOnboardingExecutor(this.project, steps, childScope, (Disposable)this.project, (Function0<Unit>)((Function0)() -> NewUsersOnboardingService.startOnboarding$lambda$0(this)));
        executor.start();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, NewUiOnboardingStep>> getSteps() {
        void $this$mapNotNullTo$iv$iv;
        List<String> stepIds = this.getStepsOrder();
        Iterable $this$mapNotNull$iv = stepIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            NewUiOnboardingStep step;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String id = (String)element$iv$iv;
            boolean bl2 = false;
            NewUiOnboardingStep newUiOnboardingStep = step = NewUiOnboardingStep.Companion.getIfAvailable(id);
            if ((newUiOnboardingStep != null ? TuplesKt.to((Object)id, (Object)newUiOnboardingStep) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getStepsOrder() {
        Object[] objectArray = new String[]{"mainMenu", "projectWidget", "gitWidget", "runWidget", "searchEverywhere", "settingsPopup", "toolWindowLayouts", "moreToolWindows", "learnToolWindow"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit startOnboarding$lambda$0(NewUsersOnboardingService this$0) {
        this$0.currentExecutor = null;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onDialogClosed(NewUsersOnboardingService $this, int exitCode) {
        $this.onDialogClosed(exitCode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService;", "project", "Lcom/intellij/openapi/project/Project;", "NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY", "", "intellij.platform.ide.newUsersOnboarding"})
    @SourceDebugExtension(value={"SMAP\nNewUsersOnboardingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,112:1\n31#2,2:113\n*S KotlinDebug\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService$Companion\n*L\n108#1:113,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewUsersOnboardingService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NewUsersOnboardingService> serviceClass$iv = NewUsersOnboardingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NewUsersOnboardingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

