/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongIntAssociativeContainer;
import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.LongIntMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.comparators.LongComparator;
import com.carrotsearch.hppc.comparators.LongIntComparator;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.LongIntPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.LongIntProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationLongIntHashMap
implements LongIntMap {
    public final LongIntHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationLongIntHashMap(LongIntHashMap delegate2, LongComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongIntHashMap(LongIntHashMap delegate2, LongIntComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongIntComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final int[] values;
            {
                this.keys = SortedIterationLongIntHashMap.this.delegate.keys;
                this.values = SortedIterationLongIntHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongIntCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongIntPredicate predicate) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public <T extends LongIntProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongIntPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public int get(long key2) {
        return this.delegate.get(key2);
    }

    @Override
    public int getOrDefault(long key2, int defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public int put(long key2, int value) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongIntAssociativeContainer container) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongIntCursor> iterable) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int putOrAdd(long key2, int putValue, int incrementValue) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int addTo(long key2, int additionValue) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int remove(long key2) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public int indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public int indexReplace(int index, int newValue) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key2, int value) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public int indexRemove(int index) {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongIntHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongIntCursor> {
        private final LongIntCursor cursor = new LongIntCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongIntCursor fetch() {
            if (this.index < SortedIterationLongIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongIntHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongIntHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongIntCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongIntHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationLongIntHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final SortedIterationLongIntHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (LongIntCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongIntHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationLongIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongIntHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

