/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotationWriteHelper;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;

public final class GenericMain {
    private static final String[] typeNames = new String[]{"byte", "char", "double", "float", "int", "long", "short", "boolean"};

    public static GenericClassDescriptor parseClassSignature(String qualifiedName, String signature) {
        String original = signature;
        try {
            GenericClassDescriptor descriptor = new GenericClassDescriptor();
            signature = GenericMain.parseFormalParameters(signature, descriptor.fparameters, descriptor.fbounds);
            String superCl = GenericType.getNextType(signature);
            descriptor.superclass = GenericType.parse(superCl);
            signature = signature.substring(superCl.length());
            while (!signature.isEmpty()) {
                String superIf = GenericType.getNextType(signature);
                descriptor.superinterfaces.add(GenericType.parse(superIf));
                signature = signature.substring(superIf.length());
            }
            StringBuilder buf = new StringBuilder();
            buf.append('L').append(qualifiedName).append('<');
            for (String t : descriptor.fparameters) {
                buf.append('T').append(t).append(';');
            }
            buf.append(">;");
            descriptor.genericType = (GenericType)GenericType.parse(buf.toString());
            return descriptor;
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + original, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    public static GenericFieldDescriptor parseFieldSignature(String signature) {
        try {
            return new GenericFieldDescriptor(GenericType.parse(signature));
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + signature, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    public static GenericMethodDescriptor parseMethodSignature(String signature) {
        String original = signature;
        try {
            ArrayList<String> typeParameters = new ArrayList<String>();
            ArrayList<List<VarType>> typeParameterBounds = new ArrayList<List<VarType>>();
            signature = GenericMain.parseFormalParameters(signature, typeParameters, typeParameterBounds);
            int to = signature.indexOf(")");
            String parameters = signature.substring(1, to);
            signature = signature.substring(to + 1);
            ArrayList<VarType> parameterTypes = new ArrayList<VarType>();
            while (!parameters.isEmpty()) {
                String par = GenericType.getNextType(parameters);
                parameterTypes.add(GenericType.parse(par));
                parameters = parameters.substring(par.length());
            }
            String ret = GenericType.getNextType(signature);
            VarType returnType = GenericType.parse(ret);
            signature = signature.substring(ret.length());
            ArrayList<VarType> exceptionTypes = new ArrayList<VarType>();
            if (!signature.isEmpty()) {
                String[] exceptions = signature.split("\\^");
                for (int i = 1; i < exceptions.length; ++i) {
                    exceptionTypes.add(GenericType.parse(exceptions[i]));
                }
            }
            return new GenericMethodDescriptor(typeParameters, typeParameterBounds, parameterTypes, returnType, exceptionTypes);
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + original, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parseFormalParameters(String signature, List<String> parameters, List<List<VarType>> bounds) {
        int index;
        if (signature.charAt(0) != '<') {
            return signature;
        }
        int counter = 1;
        block4: for (index = 1; index < signature.length(); ++index) {
            switch (signature.charAt(index)) {
                case '<': {
                    ++counter;
                    break;
                }
                case '>': {
                    if (--counter == 0) break block4;
                }
            }
        }
        String value = signature.substring(1, index);
        signature = signature.substring(index + 1);
        while (!value.isEmpty()) {
            int to = value.indexOf(":");
            String param = value.substring(0, to);
            value = value.substring(to + 1);
            ArrayList<VarType> lstBounds = new ArrayList<VarType>();
            while (true) {
                if (value.charAt(0) == ':') {
                    value = value.substring(1);
                }
                String bound = GenericType.getNextType(value);
                lstBounds.add(GenericType.parse(bound));
                value = value.substring(bound.length());
                if (value.isEmpty() || value.charAt(0) != ':') break;
                value = value.substring(1);
            }
            parameters.add(param);
            bounds.add(lstBounds);
        }
        return signature;
    }

    public static String getGenericCastTypeName(GenericType type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        List<TypeAnnotationWriteHelper> arrayTypeAnnWriteHelpers = ExprProcessor.arrayPath(type, typeAnnWriteHelpers);
        List<TypeAnnotationWriteHelper> nonArrayTypeAnnWriteHelpers = ExprProcessor.nonArrayPath(type, typeAnnWriteHelpers);
        StringBuilder sb = new StringBuilder(GenericMain.getTypeName(type, nonArrayTypeAnnWriteHelpers));
        ExprProcessor.writeArray(sb, type.getArrayDim(), arrayTypeAnnWriteHelpers);
        return sb.toString();
    }

    private static String getTypeName(GenericType type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        int tp = type.getType();
        if (tp <= 7) {
            return typeNames[tp];
        }
        if (tp == 10) {
            return "void";
        }
        if (tp == 18) {
            StringBuilder sb = new StringBuilder();
            ExprProcessor.writeTypeAnnotationBeforeType(type, sb, typeAnnWriteHelpers);
            sb.append(type.getValue());
            return sb.toString();
        }
        if (tp == 8) {
            StringBuilder sb = new StringBuilder();
            type.appendCastName(sb, typeAnnWriteHelpers);
            return sb.toString();
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static List<TypeAnnotationWriteHelper> getGenericTypeAnnotations(int argIndex, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            boolean inGeneric;
            StructTypePathEntry entry = typeAnnWriteHelper.getPaths().peek();
            boolean bl = inGeneric = entry != null && entry.getTypeArgumentIndex() == argIndex && entry.getTypePathEntryKind() == StructTypePathEntry.Kind.TYPE.getId();
            if (inGeneric) {
                typeAnnWriteHelper.getPaths().pop();
            }
            return inGeneric;
        }).collect(Collectors.toList());
    }

    public static List<TypeAnnotationWriteHelper> writeTypeAnnotationBeforeWildCard(StringBuilder sb, VarType type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            GenericType genericType;
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            if ((type instanceof GenericType && (genericType = (GenericType)type).getWildcard() != 4 || type == null) && path == null) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            if (type != null && type.getArrayDim() == typeAnnWriteHelper.getPaths().size() && type.getArrayDim() == typeAnnWriteHelper.arrayPathCount()) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public static List<TypeAnnotationWriteHelper> writeTypeAnnotationAfterWildCard(StringBuilder sb, VarType type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        typeAnnWriteHelpers.forEach(typeAnnWriteHelper -> {
            boolean isWildCard;
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            boolean bl = isWildCard = path != null && path.getTypePathEntryKind() == StructTypePathEntry.Kind.TYPE_WILDCARD.getId();
            if (isWildCard) {
                typeAnnWriteHelper.getPaths().pop();
            }
        });
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            if (type.getArrayDim() == 0 && path == null) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            if (type.getArrayDim() == typeAnnWriteHelper.getPaths().size() && type.getArrayDim() == typeAnnWriteHelper.arrayPathCount()) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }
}

