/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SuspensionPointInsideMutexLockChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCall", "", "parent", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "child", "insideLambda", "reportProblem", "frontend.java"})
public final class SuspensionPointInsideMutexLockChecker
implements CallChecker {
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getCandidateDescriptor(...)");
        CallableDescriptor descriptor2 = callableDescriptor;
        if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend()) {
            return;
        }
        Object object = CoroutineCallCheckerKt.findEnclosingSuspendFunction((CallCheckerContext)context);
        if (object == null || (object = object.getSource()) == null || (object = PsiSourceElementKt.getPsi((SourceElement)object)) == null) {
            return;
        }
        Object enclosingSuspendFunctionSource = object;
        PsiElement parent = reportOn;
        PsiElement child = reportOn;
        boolean insideLambda = false;
        while (!(Intrinsics.areEqual((Object)parent, (Object)enclosingSuspendFunctionSource) || parent instanceof KtCallExpression && this.checkCall(context, (KtCallExpression)parent, child, insideLambda, reportOn, resolvedCall))) {
            if (parent instanceof KtLambdaExpression) {
                insideLambda = true;
            }
            if (!(parent instanceof KtValueArgumentList)) {
                child = parent;
            }
            if (parent.getParent() != null) continue;
            return;
        }
    }

    private final boolean checkCall(CallCheckerContext context, KtCallExpression parent, PsiElement child, boolean insideLambda, PsiElement reportOn, ResolvedCall<?> resolvedCall) {
        Call call = (Call)context.getTrace().get((ReadOnlySlice)BindingContext.CALL, (Object)parent.getCalleeExpression());
        if (call == null) {
            return false;
        }
        Call call2 = call;
        ResolvedCall resolvedCall2 = (ResolvedCall)context.getTrace().get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolved = resolvedCall2;
        CallableDescriptor callableDescriptor = resolved.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        boolean isSynchronized = DescriptorUtilKt.isTopLevelInPackage(callableDescriptor, "synchronized", "kotlin");
        if (isSynchronized) {
            List list = resolved.getValueArgumentsByIndex();
            ResolvedValueArgument resolvedValueArgument = list != null ? (ResolvedValueArgument)list.get(1) : null;
            ExpressionValueArgument expressionValueArgument = resolvedValueArgument instanceof ExpressionValueArgument ? (ExpressionValueArgument)resolvedValueArgument : null;
            boolean isSecondArgument = Intrinsics.areEqual((Object)(expressionValueArgument != null ? expressionValueArgument.getValueArgument() : null), (Object)child);
            if (insideLambda && isSecondArgument) {
                this.reportProblem(context, reportOn, resolvedCall);
            }
            return true;
        }
        CallableDescriptor callableDescriptor2 = resolved.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"getResultingDescriptor(...)");
        boolean isWithLock = DescriptorUtilKt.isTopLevelInPackage(callableDescriptor2, "withLock", "kotlin.concurrent");
        if (isWithLock) {
            this.reportProblem(context, reportOn, resolvedCall);
            return true;
        }
        return false;
    }

    private final void reportProblem(CallCheckerContext context, PsiElement reportOn, ResolvedCall<?> resolvedCall) {
        context.getTrace().report((Diagnostic)ErrorsJvm.SUSPENSION_POINT_INSIDE_CRITICAL_SECTION.on(reportOn, (Object)resolvedCall.getResultingDescriptor()));
    }
}

