/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.intention.TestNGExternalLibraryResolver;
import com.theoryinpractice.testng.util.TestNGUtil;
import icons.TestngIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestNGFramework
extends JavaTestFramework
implements DumbAware {
    private static final List<String> SECONDARY_BEFORE_ANNOTATIONS = Arrays.asList("org.testng.annotations.BeforeTest", "org.testng.annotations.BeforeClass", "org.testng.annotations.BeforeSuite", "org.testng.annotations.BeforeGroups");

    @NotNull
    public String getName() {
        return "TestNG";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TestngIcons.TestNG;
        if (icon == null) {
            TestNGFramework.$$$reportNull$$$0(0);
        }
        return icon;
    }

    protected String getMarkerClassFQName() {
        return "org.testng.annotations.Test";
    }

    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return TestNGExternalLibraryResolver.TESTNG_DESCRIPTOR;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return null;
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (clazz == null) {
            return false;
        }
        return (Boolean)TestNGFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            if (canBePotential) {
                return this.isUnderTestSources(clazz);
            }
            return TestNGUtil.isTestNGClass(clazz);
        }, (Object)false);
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            TestNGFramework.$$$reportNull$$$0(1);
        }
        return (PsiMethod)TestNGFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.testng.annotations.BeforeMethod", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findBeforeClassMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            TestNGFramework.$$$reportNull$$$0(2);
        }
        return (PsiMethod)TestNGFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.testng.annotations.BeforeClass", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            TestNGFramework.$$$reportNull$$$0(3);
        }
        return (PsiMethod)TestNGFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.testng.annotations.AfterMethod", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findAfterClassMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            TestNGFramework.$$$reportNull$$$0(4);
        }
        return (PsiMethod)TestNGFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.testng.annotations.AfterClass", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    /*
     * WARNING - void declaration
     */
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiModifierList modifierList;
        PsiMethod[] methods;
        PsiClass superClass;
        PsiMethod method = this.findSetUpMethod(clazz);
        if (method != null) {
            return method;
        }
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String setUpName = "setUp";
        PsiMethod patternMethod = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiMethod inClass = clazz.findMethodBySignature(patternMethod, false);
        if (inClass != null) {
            int exit;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)inClass, SECONDARY_BEFORE_ANNOTATIONS, (int)0)) {
                return inClass;
            }
            int n = exit = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)manager.getProject(), (String)TestngBundle.message("testng.create.setup.dialog.message", setUpName), (String)TestngBundle.message("testng.create.setup.dialog.title", new Object[0]), (String)TestngBundle.message("testng.annotate.dialog.title", new Object[0]), (String)TestngBundle.message("testng.create.new.method.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (exit == 0) {
                new AddAnnotationFix(BeforeMethod.class.getName(), (PsiModifierListOwner)inClass, new String[0]).invoke(inClass.getProject(), null, inClass.getContainingFile());
                return inClass;
            }
            if (exit == 1) {
                inClass = null;
                int i = 0;
                while (clazz.findMethodBySignature(patternMethod, false) != null) {
                    patternMethod.setName(setUpName + ++i);
                }
                setUpName = patternMethod.getName();
            }
        }
        if ((superClass = clazz.getSuperClass()) != null && (methods = superClass.findMethodsBySignature(patternMethod, false)).length > 0 && !(modifierList = methods[0].getModifierList()).hasModifierProperty("private")) {
            void var11_17;
            @NonNls String string = "@" + BeforeMethod.class.getName() + "\n";
            if (modifierList.hasModifierProperty("protected")) {
                @NonNls String string2 = string + "protected ";
            } else if (modifierList.hasModifierProperty("public")) {
                @NonNls String string3 = string + "public ";
            }
            patternMethod = factory.createMethodFromText((String)var11_17 + "void " + setUpName + "() throws Exception {\nsuper." + setUpName + "();\n}", null);
        }
        PsiMethod[] psiMethods = clazz.getMethods();
        PsiMethod testMethod = null;
        for (PsiMethod psiMethod : psiMethods) {
            if (inClass == null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)BeforeMethod.class.getName(), (int)0)) {
                inClass = psiMethod;
            }
            if (testMethod != null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)Test.class.getName(), (int)0) || psiMethod.hasModifierProperty("private")) continue;
            testMethod = psiMethod;
        }
        if (inClass == null) {
            void var11_21;
            if (testMethod != null) {
                PsiMethod psiMethod = (PsiMethod)clazz.addBefore((PsiElement)patternMethod, testMethod);
            } else {
                PsiMethod psiMethod = (PsiMethod)clazz.add((PsiElement)patternMethod);
            }
            JavaCodeStyleManager.getInstance((Project)clazz.getProject()).shortenClassReferences((PsiElement)clazz);
            return var11_21;
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG Test Class.java");
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG SetUp Method.java");
    }

    public FileTemplateDescriptor getBeforeClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG BeforeClass Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG TearDown Method.java");
    }

    public FileTemplateDescriptor getAfterClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG AfterClass Method.java");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG Test Method.java");
    }

    @Nullable
    public FileTemplateDescriptor getParametersMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("TestNG Parameters Method.java");
    }

    public boolean isTestMethod(PsiElement element, boolean checkAbstract) {
        if (element == null) {
            return false;
        }
        return (Boolean)TestNGFramework.callWithAlternateResolver((Project)element.getProject(), () -> element instanceof PsiMethod && this.isFrameworkAvailable(element) && TestNGUtil.hasTest((PsiModifierListOwner)element), (Object)false);
    }

    public boolean isMyConfigurationType(ConfigurationType type) {
        return type instanceof TestNGConfigurationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/theoryinpractice/testng/TestNGFramework";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/theoryinpractice/testng/TestNGFramework";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSetUpMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findBeforeClassMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTearDownMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAfterClassMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

